// $Id: RxArray.h,v 1.7 2002/08/16 07:13:13 yuya Exp $

#if !defined(AFX_RXARRAY_H__3D8FBFA6_3346_4358_BE71_27DBC0AB2696__INCLUDED_)
#define AFX_RXARRAY_H__3D8FBFA6_3346_4358_BE71_27DBC0AB2696__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxObject.h"
#include "rubyxx/RxNil.h"
#include "rubyxx/RxNumeric.h"

class RxArray : public RxObject
{

public:
	RxArray();
	RxArray(RxObject& obj);
	RxArray(int n, ...);
	virtual ~RxArray();

public:
	virtual RxObject operator[](int idx) const;
	virtual RxObject operator[](RxObject idx) const;
	//virtual RxObject operator+() const;
	//virtual RxObject operator-() const;
	//virtual RxObject operator*() const;
	//virtual RxObject operator<<() const;

public:
	virtual RxObject assoc(RxObject key) const;
	virtual RxObject at(RxObject pos) const;
	virtual RxObject clear() const;
	virtual RxObject collect_() const;
	virtual RxObject compact() const;
	virtual RxObject compact_() const;
	virtual RxObject concat(RxObject other) const;
	virtual RxObject delete_(RxObject val) const;
	virtual RxObject delete_at(RxObject pos) const;
	virtual RxObject delete_if() const;
	virtual RxObject each() const;
	virtual RxObject each_index() const;
	virtual RxObject empty_() const;
	virtual RxObject fill(RxObject val) const;
	virtual RxObject filter() const;
	virtual RxObject first() const;
	virtual RxObject flatten() const;
	virtual RxObject flatten_() const;
	virtual RxObject index(RxObject val) const;
	virtual RxObject indexes(RxObject index) const;
	virtual RxObject indices(RxObject index) const;
	virtual RxObject join(RxObject sep = RxNil()) const;
	virtual RxObject last() const;
	virtual RxObject length() const;
	virtual RxObject map_() const;
	virtual RxObject nitems() const;
	virtual RxObject pack(RxObject template_) const;
	virtual RxObject pop() const;
	virtual RxObject push(RxObject obj) const;
	virtual RxObject rassoc(RxObject obj) const;
	virtual RxObject reject_() const;
	virtual RxObject replace(RxObject another) const;
	virtual RxObject reverse() const;
	virtual RxObject reverse_() const;
	virtual RxObject reverse_each() const;
	virtual RxObject rindex(RxObject val) const;
	virtual RxObject shift() const;
	virtual RxObject size() const;
	virtual RxObject slice(RxObject range) const;
	virtual RxObject slice_(RxObject range) const;
	virtual RxObject sort_() const;
	virtual RxObject to_ary() const;
	virtual RxObject uniq() const;
	virtual RxObject uniq_() const;
	virtual RxObject unshift(RxObject obj) const;

};

#endif
