// $Id: RxKernel.h,v 1.5 2002/08/16 07:10:41 yuya Exp $

#if !defined(AFX_RXKERNEL_H__5E2E31AF_666A_4E38_A56E_498E3215BF3B__INCLUDED_)
#define AFX_RXKERNEL_H__5E2E31AF_666A_4E38_A56E_498E3215BF3B__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxObject.h"
#include "rubyxx/RxNil.h"
#include "rubyxx/RxString.h"
#include "rubyxx/RxClass.h"
#include "rubyxx/RxArray.h"
#include "rubyxx/RxIO.h"

class RxKernel
{

private:
	RxKernel();
	virtual ~RxKernel();

public:
	static RxClass meta();
	static RxObject abort();
	static RxObject ancestors();
	static RxObject at_exit();
	static RxObject autoload();
	static RxObject binding();
	static RxObject block_given_();
	static RxObject callcc();
	static RxObject caller();
	static RxObject catch_();
	static RxObject chomp();
	static RxObject chomp_();
	static RxObject chop();
	static RxObject chop_();
	static RxObject class_();
	static RxObject class_eval();
	static RxObject class_variables();
	static RxObject clone();
	static RxObject const_defined_();
	static RxObject const_get();
	static RxObject const_set();
	static RxObject constants();
	static RxObject display();
	static RxObject dup_();
	static RxObject eql_();
	static RxObject equal_();
	static RxObject eval(RxString source, RxObject binding = RxNil());
	static RxObject exec();
	static RxObject exit();
	static RxObject exit_();
	static RxObject extend();
	static RxObject fail();
	static RxObject fork();
	static RxObject format(RxString format, RxArray args);
	static RxObject freeze();
	static RxObject frozen_();
	static RxObject getc_();
	static RxObject gets();
	static RxObject global_variables();
	static RxObject gsub();
	static RxObject gsub_();
	static RxObject hash();
	static RxObject id();
	static RxObject included_modules();
	static RxObject inspect();
	static RxObject instance_eval();
	static RxObject instance_method();
	static RxObject instance_methods();
	static RxObject instance_of_();
	static RxObject instance_variables();
	static RxObject is_a_();
	static RxObject iterator_();
	static RxObject kind_of_();
	static RxObject lambda();
	static RxObject load();
	static RxObject local_variables();
	static RxObject loop();
	static RxObject method();
	static RxObject method_defined_();
	static RxObject method_missing();
	static RxObject methods();
	static RxObject module_eval();
	static RxObject name();
	static RxObject nil_();
	static RxObject open();
	static RxObject p();
	static RxObject print();
	static RxObject printf();
	static RxObject private_class_method();
	static RxObject private_instance_methods();
	static RxObject private_methods();
	static RxObject proc();
	static RxObject protected_instance_methods();
	static RxObject protected_methods();
	static RxObject public_class_method();
	static RxObject public_instance_methods();
	static RxObject public_methods();
	static RxObject putc_();
	static RxObject puts();
	static RxObject raise();
	static RxObject rand();
	static RxObject readline();
	static RxObject readlines();
	static RxObject require(RxString filename);
	static RxObject respond_to_();
	static RxObject scan();
	static RxObject select();
	static RxObject send();
	static RxObject set_trace_func();
	static RxObject singleton_method_added();
	static RxObject singleton_methods();
	static RxObject sleep_();
	static RxObject split();
	static RxObject sprintf();
	static RxObject srand();
	static RxObject sub();
	static RxObject sub_();
	static RxObject syscall();
	static RxObject system();
	static RxObject taint();
	static RxObject tainted_();
	static RxObject test();
	static RxObject throw_();
	static RxObject to_a();
	static RxObject to_s();
	static RxObject trace_var();
	static RxObject trap();
	static RxObject type();
	static RxObject untaint();
	static RxObject untrace_var();

	static RxIO STDIN();
	static RxIO STDOUT();
	static RxIO STDERR();

};

#endif
