// $Id: RxObject.h,v 1.11 2002/08/16 07:11:34 yuya Exp $

#if !defined(AFX_RXOBJECT_H__4F0241C5_16D9_4FF5_83F3_D8D6AB4FAFC2__INCLUDED_)
#define AFX_RXOBJECT_H__4F0241C5_16D9_4FF5_83F3_D8D6AB4FAFC2__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxID.h"

class RxClass;
class RxString;
class RxNumeric;
class RxArray;

class RxObject
{

public:
	RxObject();
	RxObject(VALUE vObject);
	RxObject(RxObject &Object);
	virtual ~RxObject();

public:
	virtual operator bool() const;
	virtual bool operator==(RxObject obj) const;
	virtual bool operator!=(RxObject obj) const;
	virtual bool operator>(RxObject obj) const;
	virtual bool operator>=(RxObject obj) const;
	virtual bool operator<(RxObject obj) const;
	virtual bool operator<=(RxObject obj) const;

public:
	virtual VALUE value() const;
	virtual bool is_nil() const;
	virtual bool is_true() const;
	virtual bool is_false() const;

	virtual RxObject send(RxID method_name) const;
	virtual RxObject send(RxID method_name, RxObject param1) const;
	virtual RxObject send(RxID method_name, RxObject param1, RxObject param2) const;
	virtual RxObject apply(RxID mid, RxArray args) const;
	virtual RxObject apply2(RxID mid, RxObject arg_1, RxArray arg_n) const;

	virtual RxObject class_() const;
	virtual RxObject clone() const;
	virtual RxObject display() const;
	virtual RxObject dup_() const;
	virtual RxObject eql() const;
	virtual RxObject equal() const;
	virtual RxObject extend() const;
	virtual RxObject freeze() const;
	virtual RxObject frozen() const;
	virtual RxNumeric hash() const;
	virtual RxNumeric id() const;
	virtual RxString inspect() const;
	virtual RxObject instance_eval() const;
	virtual RxObject instance_of() const;
	virtual RxObject instance_variables() const;
	virtual RxObject is_a(RxObject obj) const;
	virtual RxObject kind_of(RxObject obj) const;
	virtual RxObject method() const;
	virtual RxObject methods() const;
	virtual RxObject private_methods() const;
	virtual RxObject protected_methods() const;
	virtual RxObject public_methods() const;
	virtual RxObject singleton_methods() const;
	virtual RxObject taint() const;
	virtual RxObject tainted() const;
	virtual RxObject to_a() const;
	virtual RxObject to_ary() const;
	virtual RxObject to_hash() const;
	virtual RxObject to_int() const;
	virtual RxString to_s() const;
	virtual RxString to_str() const;
	virtual RxClass  type() const;
	virtual RxObject untaint() const;

public:
	static RxClass meta();
	static RxObject new_();

protected:
	static void register_global_variable(VALUE value);
	static void unregister_global_variable(VALUE value);

protected:
	VALUE m_vObject;

protected:
	static VALUE m_vGlobalVariable;

};

#endif
