// $Id: RxString.h,v 1.10 2002/08/16 07:15:11 yuya Exp $

#if !defined(AFX_RXSTRING_H__7CFC4ACF_1A10_416D_8798_A48F6DBC7989__INCLUDED_)
#define AFX_RXSTRING_H__7CFC4ACF_1A10_416D_8798_A48F6DBC7989__INCLUDED_

#include "rubyxx/RxBase.h"
#include "rubyxx/RxObject.h"
#include "rubyxx/RxNil.h"
#include "rubyxx/RxNumeric.h"

class RxString : public RxObject
{

public:
	RxString();
	RxString(RxObject& Object);
	RxString(const char* string);
	virtual ~RxString();

public:
	virtual operator const char*() const;
	virtual RxString operator*(RxNumeric num) const;

public:
	virtual const char* string() const;

	virtual RxObject capitalize() const;
	virtual RxObject capitalize_() const;
	virtual RxObject center(RxObject width = RxNil()) const;
	virtual RxObject chomp(RxObject rs = RxNil()) const;
	virtual RxObject chomp_(RxObject rs = RxNil()) const;
	virtual RxObject chop() const;
	virtual RxObject chop_() const;
	virtual RxObject concat(RxObject other) const;
	virtual RxObject count(RxObject str) const;
	virtual RxObject crypt(RxObject salt) const;
	virtual RxObject delete_(RxObject str) const;
	virtual RxObject delete__(RxObject str) const;
	virtual RxObject downcase() const;
	virtual RxObject downcase_() const;
	virtual RxObject dump() const;
	virtual RxObject each(RxObject rs = RxNil()) const;
	virtual RxObject each_byte() const;
	virtual RxObject each_line(RxObject rs = RxNil()) const;
	virtual RxObject empty_() const;
	virtual RxObject gsub(RxObject pattern, RxObject replace = RxNil()) const;
	virtual RxObject gsub_(RxObject pattern, RxObject replace = RxNil()) const;
	virtual RxObject hex() const;
	virtual RxObject index(RxObject pattern, RxObject pos = RxNil()) const;
	virtual RxObject intern() const;
	virtual RxNumeric length() const;
	virtual RxObject ljust(RxObject width = RxNil()) const;
	virtual RxObject next() const;
	virtual RxObject next_() const;
	virtual RxObject oct() const;
	virtual RxObject replace(RxObject other) const;
	virtual RxObject reverse() const;
	virtual RxObject reverse_() const;
	virtual RxObject rindex(RxObject pattern, RxObject pos = RxNil()) const;
	virtual RxObject rjust(RxObject width = RxNil()) const;
	virtual RxObject scan(RxObject re) const;
	virtual RxNumeric size() const;
	virtual RxObject slice(RxObject range) const;
	virtual RxObject slice_(RxObject range) const;
	virtual RxObject split(RxObject sep = RxNil(), RxObject limit = RxNil()) const;
	virtual RxObject squeeze(RxObject str) const;
	virtual RxObject squeeze_(RxObject str) const;
	virtual RxObject strip() const;
	virtual RxObject strip_() const;
	virtual RxObject sub(RxObject pattern, RxObject replace = RxNil()) const;
	virtual RxObject sub_(RxObject pattern, RxObject replace = RxNil()) const;
	virtual RxObject succ() const;
	virtual RxObject succ_() const;
	virtual RxObject sum(RxObject bits = RxNil()) const;
	virtual RxObject swapcase() const;
	virtual RxObject swapcase_() const;
	virtual RxObject to_f() const;
	virtual RxObject to_i() const;
	virtual RxObject tr(RxObject search, RxObject replace) const;
	virtual RxObject tr_(RxObject search, RxObject replace) const;
	virtual RxObject tr_s(RxObject search, RxObject replace) const;
	virtual RxObject tr_s_(RxObject search, RxObject replace) const;
	virtual RxObject unpack(RxObject template_) const;
	virtual RxObject upcase() const;
	virtual RxObject upcase_() const;
	virtual RxObject upto(RxObject max) const;

public:
	static RxObject meta();

};

#endif
