// $Id: RxClass.cpp,v 1.9 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxClass.h"

////////////////////////////////////////////////////////////////////////////////

RxClass::RxClass()
	: RxModule()
{
}

RxClass::RxClass(RxObject& obj)
	: RxModule(obj)
{
}

RxClass::~RxClass()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxClass::new_() const
{
	return send("new");
}

RxClass
RxClass::superclass() const
{
	return send("superclass");
}

RxObject
RxClass::get_const(RxID name)
{
	return ::rb_const_get(value(), name.id());
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxClass::new_()
{
	return RxObject(rb_cClass).send("new");
}

RxClass
RxClass::define(RxString name)
{
	return RxObject(::rb_define_class(name.string(), 0));
}

RxClass
RxClass::define(RxString name, RxClass super)
{
	return RxObject(::rb_define_class(name.string(), super.value()));
}

RxClass
RxClass::define_under(RxString name, RxClass outer)
{
	return RxObject(::rb_define_class_under(outer.value(), name.string(), 0));
}

RxClass
RxClass::define_under(RxString name, RxClass outer, RxClass super)
{
	return RxObject(::rb_define_class_under(outer.value(), name.string(), super.value()));
}

////////////////////////////////////////////////////////////////////////////////
