// $Id: RxFile.cpp,v 1.7 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxFile.h"

////////////////////////////////////////////////////////////////////////////////

RxFile::RxFile()
	: RxIO()
{
}

RxFile::RxFile(RxObject& obj)
	: RxIO(obj)
{
}

RxFile::~RxFile()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxFile::atime() const
{
	return send("atime");
}

RxObject
RxFile::chmod() const
{
	return send("chmod");
}

RxObject
RxFile::chown() const
{
	return send("chown");
}

RxObject
RxFile::ctime() const
{
	return send("ctime");
}

RxObject
RxFile::flock() const
{
	return send("flock");
}

RxObject
RxFile::lstat() const
{
	return send("lstat");
}

RxObject
RxFile::mtime() const
{
	return send("mtime");
}

RxObject
RxFile::path() const
{
	return send("path");
}

RxObject
RxFile::truncate() const
{
	return send("truncate");
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxFile::meta()
{
	return RxClass(RxObject(rb_cFile));
}

RxFile
RxFile::open_(RxString path, RxString mode)
{
	return meta().send("open", path, mode);
}

////////////////////////////////////////////////////////////////////////////////
