// $Id: RxHash.cpp,v 1.7 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxHash.h"

////////////////////////////////////////////////////////////////////////////////

RxHash::RxHash()
	: RxObject(::rb_hash_new())
{
}

RxHash::RxHash(RxObject& obj)
	: RxObject(obj)
{
}

RxHash::~RxHash()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxHash::clear() const
{
	return send("clear");
}

RxObject
RxHash::default_() const
{
	return send("default");
}

RxObject
RxHash::default__() const
{
	return send("default=");
}

RxObject
RxHash::delete_(RxObject key) const
{
	return send("delete", key);
}

RxObject
RxHash::delete_if() const
{
	return send("delete_if");
}

RxObject
RxHash::each() const
{
	return send("each");
}

RxObject
RxHash::each_key() const
{
	return send("each_key");
}

RxObject
RxHash::each_pair() const
{
	return send("each_pair");
}

RxObject
RxHash::each_value() const
{
	return send("each_value");
}

RxObject
RxHash::empty_() const
{
	return send("empty?");
}

RxObject
RxHash::fetch(RxObject key, RxObject default_) const
{
	return send("fetch", key, default_);
}

RxObject
RxHash::has_key_(RxObject key) const
{
	return send("has_key?", key);
}

RxObject
RxHash::has_value_(RxObject value) const
{
	return send("has_value?", value);
}

RxObject
RxHash::index(RxObject val) const
{
	return send("index", val);
}

RxObject
RxHash::indexes(RxObject key) const
{
	return send("indexes", key);
}

RxObject
RxHash::indices(RxObject key) const
{
	return send("indices", key);
}

RxObject
RxHash::invert() const
{
	return send("invert");
}

RxObject
RxHash::key_() const
{
	return send("key?");
}

RxObject
RxHash::keys() const
{
	return send("keys");
}

RxObject
RxHash::length() const
{
	return send("length");
}

RxObject
RxHash::rehash() const
{
	return send("rehash");
}

RxObject
RxHash::reject_() const
{
	return send("reject!");
}

RxObject
RxHash::replace(RxObject other) const
{
	return send("replace", other);
}

RxObject
RxHash::shift() const
{
	return send("shift");
}

RxObject
RxHash::size() const
{
	return send("size");
}

RxObject
RxHash::store(RxObject key, RxObject value) const
{
	return send("store", key, value);
}

RxObject
RxHash::to_hash() const
{
	return send("to_hash");
}

RxObject
RxHash::update(RxObject other) const
{
	return send("update", other);
}

RxObject
RxHash::value_(RxObject value) const
{
	return send("value?", value);
}

RxObject
RxHash::values() const
{
	return send("values");
}

////////////////////////////////////////////////////////////////////////////////
