// $Id: RxKernel.cpp,v 1.5 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxKernel.h"

////////////////////////////////////////////////////////////////////////////////

RxKernel::RxKernel()
{
}

RxKernel::~RxKernel()
{
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxKernel::meta()
{
	return RxClass(RxObject(rb_mKernel));
}

RxObject
RxKernel::abort()
{
	return meta().send("abort");
}

RxObject
RxKernel::ancestors()
{
	return meta().send("ancestors");
}

RxObject
RxKernel::at_exit()
{
	return meta().send("at_exit");
}

RxObject
RxKernel::autoload()
{
	return meta().send("autoload");
}

RxObject
RxKernel::binding()
{
	return meta().send("binding");
}

RxObject
RxKernel::block_given_()
{
	return meta().send("block_given?");
}

RxObject
RxKernel::callcc()
{
	return meta().send("callcc");
}

RxObject
RxKernel::caller()
{
	return meta().send("caller");
}

RxObject
RxKernel::catch_()
{
	return meta().send("catch");
}

RxObject
RxKernel::chomp()
{
	return meta().send("chomp");
}

RxObject
RxKernel::chomp_()
{
	return meta().send("chomp!");
}

RxObject
RxKernel::chop()
{
	return meta().send("chop");
}

RxObject
RxKernel::chop_()
{
	return meta().send("chop!");
}

RxObject
RxKernel::class_()
{
	return meta().send("class");
}

RxObject
RxKernel::class_eval()
{
	return meta().send("class_eval");
}

RxObject
RxKernel::class_variables()
{
	return meta().send("class_variables");
}

RxObject
RxKernel::clone()
{
	return meta().send("clone");
}

RxObject
RxKernel::const_defined_()
{
	return meta().send("const_defined?");
}

RxObject
RxKernel::const_get()
{
	return meta().send("const_get");
}

RxObject
RxKernel::const_set()
{
	return meta().send("const_set");
}

RxObject
RxKernel::constants()
{
	return meta().send("constants");
}

RxObject
RxKernel::display()
{
	return meta().send("display");
}

RxObject
RxKernel::dup_()
{
	return meta().send("dup");
}

RxObject
RxKernel::eql_()
{
	return meta().send("eql?");
}

RxObject
RxKernel::equal_()
{
	return meta().send("equal?");
}

RxObject
RxKernel::eval(RxString source, RxObject binding)
{
	if ( !binding.is_nil() ) {
		return meta().send("eval", source);
	} else {
		return meta().send("eval", source, binding);
	}
}

RxObject
RxKernel::exec()
{
	return meta().send("exec");
}

RxObject
RxKernel::exit()
{
	return meta().send("exit");
}

RxObject
RxKernel::exit_()
{
	return meta().send("exit!");
}

RxObject
RxKernel::extend()
{
	return meta().send("extend");
}

RxObject
RxKernel::fail()
{
	return meta().send("fail");
}

RxObject
RxKernel::fork()
{
	return meta().send("fork");
}

RxObject
RxKernel::format(RxString format, RxArray args)
{
	return meta().apply2("format", format, args);
}

RxObject
RxKernel::freeze()
{
	return meta().send("freeze");
}

RxObject
RxKernel::frozen_()
{
	return meta().send("frozen?");
}

RxObject
RxKernel::getc_()
{
	return meta().send("getc");
}

RxObject
RxKernel::gets()
{
	return meta().send("gets");
}

RxObject
RxKernel::global_variables()
{
	return meta().send("global_variables");
}

RxObject
RxKernel::gsub()
{
	return meta().send("gsub");
}

RxObject
RxKernel::gsub_()
{
	return meta().send("gsub!");
}

RxObject
RxKernel::hash()
{
	return meta().send("hash");
}

RxObject
RxKernel::id()
{
	return meta().send("id");
}

RxObject
RxKernel::included_modules()
{
	return meta().send("included_modules");
}

RxObject
RxKernel::inspect()
{
	return meta().send("inspect");
}

RxObject
RxKernel::instance_eval()
{
	return meta().send("instance_eval");
}

RxObject
RxKernel::instance_method()
{
	return meta().send("instance_method");
}

RxObject
RxKernel::instance_methods()
{
	return meta().send("instance_methods");
}

RxObject
RxKernel::instance_of_()
{
	return meta().send("instance_of?");
}

RxObject
RxKernel::instance_variables()
{
	return meta().send("instance_variables");
}

RxObject
RxKernel::is_a_()
{
	return meta().send("is_a?");
}

RxObject
RxKernel::iterator_()
{
	return meta().send("iterator?");
}

RxObject
RxKernel::kind_of_()
{
	return meta().send("kind_of?");
}

RxObject
RxKernel::lambda()
{
	return meta().send("lambda");
}

RxObject
RxKernel::load()
{
	return meta().send("load");
}

RxObject
RxKernel::local_variables()
{
	return meta().send("local_variables");
}

RxObject
RxKernel::loop()
{
	return meta().send("loop");
}

RxObject
RxKernel::method()
{
	return meta().send("method");
}

RxObject
RxKernel::method_defined_()
{
	return meta().send("method_defined?");
}

RxObject
RxKernel::method_missing()
{
	return meta().send("method_missing");
}

RxObject
RxKernel::methods()
{
	return meta().send("methods");
}

RxObject
RxKernel::module_eval()
{
	return meta().send("module_eval");
}

RxObject
RxKernel::name()
{
	return meta().send("name");
}

RxObject
RxKernel::nil_()
{
	return meta().send("nil?");
}

RxObject
RxKernel::open()
{
	return meta().send("open");
}

RxObject
RxKernel::p()
{
	return meta().send("p");
}

RxObject
RxKernel::print()
{
	return meta().send("print");
}

RxObject
RxKernel::printf()
{
	return meta().send("printf");
}

RxObject
RxKernel::private_class_method()
{
	return meta().send("private_class_method");
}

RxObject
RxKernel::private_instance_methods()
{
	return meta().send("private_instance_methods");
}

RxObject
RxKernel::private_methods()
{
	return meta().send("private_methods");
}

RxObject
RxKernel::proc()
{
	return meta().send("proc");
}

RxObject
RxKernel::protected_instance_methods()
{
	return meta().send("protected_instance_methods");
}

RxObject
RxKernel::protected_methods()
{
	return meta().send("protected_methods");
}

RxObject
RxKernel::public_class_method()
{
	return meta().send("public_class_method");
}

RxObject
RxKernel::public_instance_methods()
{
	return meta().send("public_instance_methods");
}

RxObject
RxKernel::public_methods()
{
	return meta().send("public_methods");
}

RxObject
RxKernel::putc_()
{
	return meta().send("putc");
}

RxObject
RxKernel::puts()
{
	return meta().send("puts");
}

RxObject
RxKernel::raise()
{
	return meta().send("raise");
}

RxObject
RxKernel::rand()
{
	return meta().send("rand");
}

RxObject
RxKernel::readline()
{
	return meta().send("readline");
}

RxObject
RxKernel::readlines()
{
	return meta().send("readlines");
}

RxObject
RxKernel::require(RxString filename)
{
	return meta().send("require", filename);
}

RxObject
RxKernel::respond_to_()
{
	return meta().send("respond_to?");
}

RxObject
RxKernel::scan()
{
	return meta().send("scan");
}

RxObject
RxKernel::select()
{
	return meta().send("select");
}

RxObject
RxKernel::send()
{
	return meta().send("send");
}

RxObject
RxKernel::set_trace_func()
{
	return meta().send("set_trace_func");
}

RxObject
RxKernel::singleton_method_added()
{
	return meta().send("singleton_method_added");
}

RxObject
RxKernel::singleton_methods()
{
	return meta().send("singleton_methods");
}

RxObject
RxKernel::sleep_()
{
	return meta().send("sleep");
}

RxObject
RxKernel::split()
{
	return meta().send("split");
}

RxObject
RxKernel::sprintf()
{
	return meta().send("sprintf");
}

RxObject
RxKernel::srand()
{
	return meta().send("srand");
}

RxObject
RxKernel::sub()
{
	return meta().send("sub");
}

RxObject
RxKernel::sub_()
{
	return meta().send("sub!");
}

RxObject
RxKernel::syscall()
{
	return meta().send("syscall");
}

RxObject
RxKernel::system()
{
	return meta().send("system");
}

RxObject
RxKernel::taint()
{
	return meta().send("taint");
}

RxObject
RxKernel::tainted_()
{
	return meta().send("tainted?");
}

RxObject
RxKernel::test()
{
	return meta().send("test");
}

RxObject
RxKernel::throw_()
{
	return meta().send("throw");
}

RxObject
RxKernel::to_a()
{
	return meta().send("to_a");
}

RxObject
RxKernel::to_s()
{
	return meta().send("to_s");
}

RxObject
RxKernel::trace_var()
{
	return meta().send("trace_var");
}

RxObject
RxKernel::trap()
{
	return meta().send("trap");
}

RxObject
RxKernel::type()
{
	return meta().send("type");
}

RxObject
RxKernel::untaint()
{
	return meta().send("untaint");
}

RxObject
RxKernel::untrace_var()
{
	return meta().send("untrace_var");
}


RxIO
RxKernel::STDIN()
{
	return RxIO(RxObject::meta().get_const("STDIN"));
}

RxIO
RxKernel::STDOUT()
{
	return RxIO(RxObject::meta().get_const("STDOUT"));
}

RxIO
RxKernel::STDERR()
{
	return RxIO(RxObject::meta().get_const("STDERR"));
}

////////////////////////////////////////////////////////////////////////////////
