// $Id: RxString.cpp,v 1.12 2002/08/18 15:35:44 yuya Exp $

#include "rubyxx/RxString.h"

////////////////////////////////////////////////////////////////////////////////

RxString::RxString()
	: RxObject(::rb_str_new2(""))
{
}

RxString::RxString(RxObject& Object)
	: RxObject(Object)
{
}

RxString::RxString(const char* string)
	: RxObject(::rb_str_new2(string))
{
}

RxString::~RxString()
{
}

////////////////////////////////////////////////////////////////////////////////

RxString::operator const char*() const
{
	return string();
}

const char*
RxString::string() const
{
	return STR2CSTR(m_vObject);
}

RxString
RxString::operator*(RxNumeric num) const
{
	return RxString(*this * num);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxString::capitalize() const
{
	return send("capitalize");
}

RxObject
RxString::capitalize_() const
{
	return send("capitalize!");
}

RxObject
RxString::center(RxObject width) const
{
	return send("center", width);
}

RxObject
RxString::chomp(RxObject rs) const
{
	return send("chomp", rs);
}

RxObject
RxString::chomp_(RxObject rs) const
{
	return send("chomp!", rs);
}

RxObject
RxString::chop() const
{
	return send("chop");
}

RxObject
RxString::chop_() const
{
	return send("chop!");
}

RxObject
RxString::concat(RxObject other) const
{
	return send("concat", other);
}

RxObject
RxString::count(RxObject str) const
{
	return send("count", str);
}

RxObject
RxString::crypt(RxObject salt) const
{
	return send("crypt", salt);
}

RxObject
RxString::delete_(RxObject str) const
{
	return send("delete", str);
}

RxObject
RxString::delete__(RxObject str) const
{
	return send("delete!", str);
}

RxObject
RxString::downcase() const
{
	return send("downcase");
}

RxObject
RxString::downcase_() const
{
	return send("downcase!");
}

RxObject
RxString::dump() const
{
	return send("dump");
}

RxObject
RxString::each(RxObject rs) const
{
	return send("each", rs);
}

RxObject
RxString::each_byte() const
{
	return send("each_byte");
}

RxObject
RxString::each_line(RxObject rs) const
{
	return send("each_line", rs);
}

RxObject
RxString::empty_() const
{
	return send("empty");
}

RxObject
RxString::gsub(RxObject pattern, RxObject replace) const
{
	return send("gsub", pattern, replace);
}

RxObject
RxString::gsub_(RxObject pattern, RxObject replace) const
{
	return send("gsub", pattern, replace);
}

RxObject
RxString::hex() const
{
	return send("hex");
}

RxObject
RxString::index(RxObject pattern, RxObject pos) const
{
	return send("index", pattern, pos);
}

RxObject
RxString::intern() const
{
	return send("intern");
}

RxNumeric
RxString::length() const
{
	return send("length");
}

RxObject
RxString::ljust(RxObject width) const
{
	return send("ljust");
}

RxObject
RxString::next() const
{
	return send("next");
}

RxObject
RxString::next_() const
{
	return send("next!");
}

RxObject
RxString::oct() const
{
	return send("oct");
}

RxObject
RxString::replace(RxObject other) const
{
	return send("replace");
}

RxObject
RxString::reverse() const
{
	return send("reverse");
}

RxObject
RxString::reverse_() const
{
	return send("reverse!");
}

RxObject
RxString::rindex(RxObject pattern, RxObject pos) const
{
	return send("rindex", pattern, pos);
}

RxObject
RxString::rjust(RxObject width) const
{
	return send("rjust", width);
}

RxObject
RxString::scan(RxObject re) const
{
	return send("scan", re);
}

RxNumeric
RxString::size() const
{
	return send("size");
}

RxObject
RxString::slice(RxObject range) const
{
	return send("slice");
}

RxObject
RxString::slice_(RxObject range) const
{
	return send("slice!");
}

RxObject
RxString::split(RxObject sep, RxObject limit) const
{
	return send("split", sep, limit);
}

RxObject
RxString::squeeze(RxObject str) const
{
	return send("squeeze", str);
}

RxObject
RxString::squeeze_(RxObject str) const
{
	return send("squeeze!", str);
}

RxObject
RxString::strip() const
{
	return send("strip");
}

RxObject
RxString::strip_() const
{
	return send("strip!");
}

RxObject
RxString::sub(RxObject pattern, RxObject replace) const
{
	return send("sub", pattern, replace);
}

RxObject
RxString::sub_(RxObject pattern, RxObject replace) const
{
	return send("sub", pattern, replace);
}

RxObject
RxString::succ() const
{
	return send("succ");
}

RxObject
RxString::succ_() const
{
	return send("succ!");
}

RxObject
RxString::sum(RxObject bits) const
{
	return send("sum", bits);
}

RxObject
RxString::swapcase() const
{
	return send("swapcase");
}

RxObject
RxString::swapcase_() const
{
	return send("swapcase!");
}

RxObject
RxString::to_f() const
{
	return send("to_f");
}

RxObject
RxString::to_i() const
{
	return send("to_i");
}

RxObject
RxString::tr(RxObject search, RxObject replace) const
{
	return send("tr", search, replace);
}

RxObject
RxString::tr_(RxObject search, RxObject replace) const
{
	return send("tr!", search, replace);
}

RxObject
RxString::tr_s(RxObject search, RxObject replace) const
{
	return send("tr_s", search, replace);
}

RxObject
RxString::tr_s_(RxObject search, RxObject replace) const
{
	return send("tr_s!", search, replace);
}

RxObject
RxString::unpack(RxObject template_) const
{
	return send("unpack", template_);
}

RxObject
RxString::upcase() const
{
	return send("upcase");
}

RxObject
RxString::upcase_() const
{
	return send("upcase!");
}

RxObject
RxString::upto(RxObject max) const
{
	return send("upto", max);
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxString::meta()
{
	return RxObject(rb_cString);
}

////////////////////////////////////////////////////////////////////////////////
