
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxNil : public TestCase
{
public:

	TestRxNil(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxNil");

		suite->addTest(new TEST_CALLER(TestRxNil, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxNil, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxNil, test_is_false));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxNil().is_nil() == true);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxNil().is_true() == false);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxNil().is_false() == false);
	}

};
