
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxString : public TestCase
{
public:

	TestRxString(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxString");

		suite->addTest(new TEST_CALLER(TestRxString, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxString, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxString, test_is_false));
		suite->addTest(new TEST_CALLER(TestRxString, test_size));
		suite->addTest(new TEST_CALLER(TestRxString, test_length));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxString().is_nil() == false);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxString().is_true() == false);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxString().is_false() == false);
	}

	void test_size()
	{
		TEST_ASSERT(RxString("").size() == RxNumeric(0));
		TEST_ASSERT(RxString("1").size() == RxNumeric(1));
		TEST_ASSERT(RxString("22").size() == RxNumeric(2));
	}

	void test_length()
	{
		TEST_ASSERT(RxString("").length() == RxNumeric(0));
		TEST_ASSERT(RxString("1").length() == RxNumeric(1));
		TEST_ASSERT(RxString("22").length() == RxNumeric(2));
	}

};
