
#include <stdio.h>
#include <cppunit/TestRunner.h>
#include <rubyxx/Rx.h>

#include "TestRxObject.h"
#include "TestRxNil.h"
#include "TestRxTrue.h"
#include "TestRxFalse.h"
#include "TestRxNumeric.h"
#include "TestRxArray.h"
#include "TestRxString.h"

USING_NAMESPACE_CPPUNIT

int main(int argc, char* argv[]) {
	RxRuby::init();

	TestRunner runner;

	runner.addTest("TestRxObject", TestRxObject::suite());
	runner.addTest("TestRxNil",    TestRxNil::suite());
	runner.addTest("TestRxTrue",   TestRxTrue::suite());
	runner.addTest("TestRxFalse",  TestRxFalse::suite());
	runner.addTest("TestRxNumeric", TestRxNumeric::suite());
	runner.addTest("TestRxArray", TestRxArray::suite());
	runner.addTest("TestRxString", TestRxString::suite());

	printf("Ruby++ Unit Test.\n\n");

	const int code = runner.run(argc, argv);

	printf("\n[press enter key]");
	getc(stdin);

	return code;
}
