// $Id: RxClass.cpp,v 1.1 2002/08/30 08:15:56 yuya Exp $

#include "rubyxx/RxClass.h"

////////////////////////////////////////////////////////////////////////////////

RxClass::RxClass()
	: RxModule()
{
}

RxClass::RxClass(const RxObject& obj)
	: RxModule(obj)
{
}

RxClass::~RxClass()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxClass::new_() const
{
	return send("new");
}

RxClass
RxClass::superclass() const
{
	return send("superclass");
}

RxObject
RxClass::get_const(RxID name)
{
	return ::rb_const_get(value(), name.id());
}

////////////////////////////////////////////////////////////////////////////////

RxClass
RxClass::meta()
{
	return RxObject(rb_cClass);
}

RxClass
RxClass::define(RxString name)
{
	return RxObject(::rb_define_class(name.string(), 0));
}

RxClass
RxClass::define(RxString name, RxClass super)
{
	return RxObject(::rb_define_class(name.string(), super.value()));
}

RxClass
RxClass::define_under(RxString name, RxClass outer)
{
	return RxObject(::rb_define_class_under(outer.value(), name.string(), 0));
}

RxClass
RxClass::define_under(RxString name, RxClass outer, RxClass super)
{
	return RxObject(::rb_define_class_under(outer.value(), name.string(), super.value()));
}

////////////////////////////////////////////////////////////////////////////////
