// $Id: RxIO.cpp,v 1.1 2002/08/30 08:15:57 yuya Exp $

#include "rubyxx/RxIO.h"

////////////////////////////////////////////////////////////////////////////////

RxIO::RxIO()
	: RxObject()
{
}

RxIO::RxIO(const RxObject& obj)
	: RxObject(obj)
{
}

RxIO::~RxIO()
{
}

////////////////////////////////////////////////////////////////////////////////

RxObject
RxIO::binmode() const
{
	return send("binmode");
}

RxObject
RxIO::close_() const
{
	return send("close");
}

RxObject
RxIO::close_read() const
{
	return send("close_read");
}

RxObject
RxIO::close_write() const
{
	return send("close_write");
}

RxObject
RxIO::closed_() const
{
	return send("closed?");
}

RxObject
RxIO::each() const
{
	return send("each");
}

RxObject
RxIO::each_byte() const
{
	return send("each_byte");
}

RxObject
RxIO::each_line() const
{
	return send("each_line");
}

RxObject
RxIO::eof() const
{
	return send("eof");
}

RxObject
RxIO::eof_() const
{
	return send("eof?");
}

RxObject
RxIO::fcntl() const
{
	return send("fcntl");
}

RxObject
RxIO::fileno() const
{
	return send("fileno");
}

RxObject
RxIO::flush() const
{
	return send("flush");
}

RxObject
RxIO::getc_() const
{
	return send("getc");
}

RxObject
RxIO::gets() const
{
	return send("gets");
}

RxObject
RxIO::ioctl() const
{
	return send("ioctl");
}

RxObject
RxIO::isatty() const
{
	return send("isatty");
}

RxObject
RxIO::lineno() const
{
	return send("lineno");
}

RxObject
RxIO::lineno_() const
{
	return send("lineno=");
}

RxObject
RxIO::pid() const
{
	return send("pid");
}

RxObject
RxIO::pos() const
{
	return send("pos");
}

RxObject
RxIO::pos_() const
{
	return send("pos=");
}

RxObject
RxIO::print() const
{
	return send("print");
}

RxObject
RxIO::printf(RxString format, RxArray args) const
{
	return apply2("printf", format, args);
}

RxObject
RxIO::putc_() const
{
	return send("putc");
}

RxObject
RxIO::puts(RxObject obj) const
{
	return send("puts", obj);
}

RxString
RxIO::read_() const
{
	return send("read");
}

RxObject
RxIO::readchar() const
{
	return send("readchar");
}

RxObject
RxIO::readline() const
{
	return send("readline");
}

RxObject
RxIO::readlines() const
{
	return send("readlines");
}

RxObject
RxIO::reopen() const
{
	return send("reopen");
}

RxObject
RxIO::rewind() const
{
	return send("rewind");
}

RxObject
RxIO::seek() const
{
	return send("seek");
}

RxObject
RxIO::stat() const
{
	return send("stat");
}

RxObject
RxIO::sync() const
{
	return send("sync");
}

RxObject
RxIO::sync_() const
{
	return send("sync=");
}

RxObject
RxIO::sysread() const
{
	return send("sysread");
}

RxObject
RxIO::syswrite() const
{
	return send("syswrite");
}

RxObject
RxIO::tell() const
{
	return send("tell");
}

RxObject
RxIO::to_i() const
{
	return send("to_i");
}

RxObject
RxIO::to_io() const
{
	return send("to_io");
}

RxObject
RxIO::tty_() const
{
	return send("tty?");
}

RxObject
RxIO::ungetc() const
{
	return send("ungetc");
}

RxObject
RxIO::write() const
{
	return send("write");
}

////////////////////////////////////////////////////////////////////////////////
