
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <rubyxx/Rx.h>

USING_NAMESPACE_CPPUNIT

class TestRxTrue : public TestCase
{
public:

	TestRxTrue(const char* name) : TestCase(name) {}

	static Test* suite()
	{
		TestSuite* suite = new TestSuite("TestRxTrue");

		suite->addTest(new TEST_CALLER(TestRxTrue, test_is_nil));
		suite->addTest(new TEST_CALLER(TestRxTrue, test_is_true));
		suite->addTest(new TEST_CALLER(TestRxTrue, test_is_false));

		return suite;
	}

	virtual void setUp()
	{
		RxGC::start();
	}

	void test_is_nil()
	{
		TEST_ASSERT(RxTrue().is_nil() == false);
	}

	void test_is_true()
	{
		TEST_ASSERT(RxTrue().is_true() == true);
	}

	void test_is_false()
	{
		TEST_ASSERT(RxTrue().is_false() == false);
	}

};
