# Linux
# gnu Ada compile script for cube, seven
#
# uses rpath to tell runtime linker to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libglfw.so

# Note that libfreetype.so.6.12.1 needs
# special preparation using "patchelf"
# in order to allow libfreetype* to find it
# under GnuCompilerCollection-GNAT.
# Not so using AdaCore Ada.

#########################################################



# set priority path to GNU Ada compiler...
export PATH=$HOME/opt/gnat-x86_64-linux-12.2.0-1/bin:$PATH




gnatmake $1  \
-O3 -gnat12 \
-D $PWD/obj \
-I$PWD/../src \
-I$PWD/../src/adabindings/gl \
-I$PWD/../src/adabindings/glfwada \
-I$PWD/../src/adabindings/AdaPngLib \
-I$PWD/../src/adabindings/adaOpenAL \
-I$PWD/../src/adabindings/adaOpenAL/OalBinding \
-I$PWD/../src/adabindings/FreeTypeAda \
-largs \
oal.o \
-lGL -lX11 -lpthread -lstdc++ -lm -lz \
-lopenal \
-Wl,-rpath,'$ORIGIN/libs/gnu' \
-L$PWD/../libs/gnu \
-lfreetype -lpng15 \
-lglfw

mv $1 ../$1_gnu



# -- Copyright (C) 2022  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

