
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


separate( cube )


procedure getMouseInputs( mainWin : access GLFWwindow; Wwid,Whit: gldouble ) is
	use interfaces.c;
	use type interfaces.c.double;

	xpos,ypos : aliased gldouble;
	msl,msr : glint;

	currentTime, dt: gldouble;

begin

	glfwgetcursorpos(mainWin,xpos'access,ypos'access);
	msr := glfwGetMouseButton(mainWin, glfw_mouse_button_2); -- ?3?
	msl := glfwGetMouseButton(mainWin, glfw_mouse_button_1);


	if msl=glfw_press then
		if dragging then
			roty:=0.2*float(xpos-xold);
			rotx:=0.2*float(ypos-yold);
			xold:=xpos;
			yold:=ypos;
		else --not dragging yet
			dragging:=true;
			xold:=xpos;
			yold:=ypos;
		end if;

	elsif msl=glfw_release then
		dragging:=false;
	end if;


	currentTime:=glfwGetTime;
	dt := currentTime-oldTimeMs;
	if (msr=glfw_press) and (dt>btndlay) then
		oldTimeMs:=currentTime;

		clickRight(xpos,ypos,Wwid,Whit);


	elsif msr=glfw_release then
		null;

	end if;

end getMouseInputs;


