
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


separate( seven )

procedure clickRight(msx,msy, Wwid, Whit : gldouble ) is
	fmx : float := float(msx/Wwid);
	fmy : float := 1.0 - float(msy/Whit);
	fmz : float := 0.0;
	srow, scol, slay : integer;
	mindist : float := 1000.0;
	xndc, yndc, zndc, xn,yn,zn, dist : float;
	i, dif : integer;
	v4, vcc : vec4;
	found : boolean := false;
begin

	for row in rngs loop
	for col in rngs loop
	for lay in rngs loop

		dif := abs(row-brow) + abs(col-bcol) + abs(lay-blay);

		if dif=1 then

			i:=indx( row, col, lay );

			v4 := ( xxx(i), yyy(i), zzz(i), 1.0 );
			matXvec( mvp, v4, vcc );

			xndc:=vcc(1)/vcc(4); --// ndc in [-1..1]
			yndc:=vcc(2)/vcc(4); --// 
			zndc:=vcc(3)/vcc(4); --// bigger zndc if further away

			xn:=(1.0+xndc)/2.0;
			yn:=(1.0+yndc)/2.0;
			zn:=(1.0+zndc)/2.0;
			dist := (fmx-xn)*(fmx-xn)+(fmy-yn)*(fmy-yn)+(fmz-zn)*(fmz-zn);
			if( dist < mindist ) then
				found:=true;
				mindist:=dist;
				srow:=row; scol:=col; slay:=lay;
			end if;

		end if;

	end loop; --lay
	end loop; --col
	end loop; --row


		if found and ( mindist < 1.0 ) then

			winner:=false;
			haveSolution:=0; --cancel autosolve
			nsol:=0; --disable shuffle-undo

			if( srow /= brow ) then
				if(srow>brow) then
					moveYm;
				else         
					moveYp;
				end if;

			elsif( scol /= bcol ) then
				if(scol>bcol) then
					moveXm;
				else         
					moveXp;
				end if;
			elsif( slay /= blay ) then
				if(slay>blay) then
					moveZm;
				else         
					moveZp;
				end if;
			end if;

		end if;


end clickRight;



