
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate ( seven )



procedure cubic( 
	rr : float;  
	perm : permtype
	) is








procedure ccwNx( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

--put_line("k="&integer'image(k)); -- 1

	Vertices(k+ 0):=xm;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xm;	Vertices(k+10):=ym;	Vertices(k+11):=zm;
	Vertices(k+12):=xm;	Vertices(k+13):=yp;	Vertices(k+14):=zp;
	Vertices(k+15):=xm;	Vertices(k+16):=yp;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNx;

procedure ccwPx( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xp;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xp;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xp;	Vertices(k+10):=ym;	Vertices(k+11):=zm;
	Vertices(k+12):=xp;	Vertices(k+13):=yp;	Vertices(k+14):=zm;
	Vertices(k+15):=xp;	Vertices(k+16):=yp;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPx;





procedure ccwNy( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=ym;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xp;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=ym;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=ym;	Vertices(k+14):=zp;
	Vertices(k+15):=xm;	Vertices(k+16):=ym;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNy;

procedure ccwPy( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xp;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=yp;	Vertices(k+14):=zm;
	Vertices(k+15):=xm;	Vertices(k+16):=yp;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPy;







procedure ccwNz( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;

begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zm;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=ym;	Vertices(k+ 5):=zm;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=yp;	Vertices(k+ 8):=zm;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zm;
	Vertices(k+12):=xp;	Vertices(k+13):=ym;	Vertices(k+14):=zm;
	Vertices(k+15):=xm;	Vertices(k+16):=ym;	Vertices(k+17):=zm;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwNz;

procedure ccwPz( sred,sgrn,sblu, x,y,z,r : float; k : integer ) is

	xm : constant float := x-r;
	ym : constant float := y-r;
	zm : constant float := z-r;

	xp : constant float := x+r;
	yp : constant float := y+r;
	zp : constant float := z+r;


begin

	Vertices(k+ 0):=xp;	Vertices(k+ 1):=yp;	Vertices(k+ 2):=zp;
	Vertices(k+ 3):=xm;	Vertices(k+ 4):=yp;	Vertices(k+ 5):=zp;
	Vertices(k+ 6):=xm;	Vertices(k+ 7):=ym;	Vertices(k+ 8):=zp;

	Vertices(k+ 9):=xp;	Vertices(k+10):=yp;	Vertices(k+11):=zp;
	Vertices(k+12):=xm;	Vertices(k+13):=ym;	Vertices(k+14):=zp;
	Vertices(k+15):=xp;	Vertices(k+16):=ym;	Vertices(k+17):=zp;

	for i in 0..5 loop
		Colors(k+i*3+0):=sred;
		Colors(k+i*3+1):=sgrn;
		Colors(k+i*3+2):=sblu;
	end loop;

end ccwPz;







procedure cubelet( x,y,z,r : float;  kk, p : integer ) is
	k : integer := 1;
begin --cubelet

if firstcallcubic then -- set complex Vadasz colors:

	if x <-0.1 then --green
		red(6*p+1):=0.0;
		grn(6*p+1):=1.0;
		blu(6*p+1):=0.0;
	else            --black
		red(6*p+1):=0.0;
		grn(6*p+1):=0.0;
		blu(6*p+1):=0.0;
	end if;

	if x > 0.1 then --yellow
		red(6*p+2):=0.9;
		grn(6*p+2):=0.9;
		blu(6*p+2):=0.0;
	else            --black
		red(6*p+2):=0.0;
		grn(6*p+2):=0.0;
		blu(6*p+2):=0.0;
	end if;

	if y <-0.1 then --magenta
		red(6*p+3):=1.0;
		grn(6*p+3):=0.0;
		blu(6*p+3):=1.0;
	else            --black
		red(6*p+3):=0.0;
		grn(6*p+3):=0.0;
		blu(6*p+3):=0.0;
	end if;

	if y > 0.1 then --red
		red(6*p+4):=1.0;
		grn(6*p+4):=0.0;
		blu(6*p+4):=0.0;
	else            --black
		red(6*p+4):=0.0;
		grn(6*p+4):=0.0;
		blu(6*p+4):=0.0;
	end if;

	if z <-0.1 then --blue
		red(6*p+5):=0.0;
		grn(6*p+5):=0.0;
		blu(6*p+5):=1.0;
	else            --black
		red(6*p+5):=0.0;
		grn(6*p+5):=0.0;
		blu(6*p+5):=0.0;
	end if;

	if z > 0.1 then --cyan
		red(6*p+6):=0.0;
		grn(6*p+6):=1.0;
		blu(6*p+6):=1.0;
	else            --black
		red(6*p+6):=0.0;
		grn(6*p+6):=0.0;
		blu(6*p+6):=0.0;
	end if;


--///// begin special case adjustments due to exposed faces on 4,6,7

	if( (x>0.1) and (y>0.1) ) then --// #7 needs Pz (anterior face) cyan
		red(6*p+6):=0.0;
		grn(6*p+6):=1.0;
		blu(6*p+6):=1.0;
	elsif( (x>0.1) and (z>0.1) ) then --// #4 needs Py (top face) red
		red(6*p+4):=1.0;
		grn(6*p+4):=0.0;
		blu(6*p+4):=0.0;
	elsif( (y>0.1) and (z>0.1) ) then --// #6 needs Px (right face ) yellow
		red(6*p+2):=0.9;
		grn(6*p+2):=0.9;
		blu(6*p+2):=0.0;
	end if;

--///// end special case adjustments due to exposed faces on 4,6,7


end if; -- firstcall


if origskin then

	ccwNx(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r,  1+kk);
	ccwPx(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r, 19+kk);
	ccwNy(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r, 37+kk);
	ccwPy(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r, 55+kk);
	ccwNz(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r, 73+kk);
	ccwPz(red8(p+1), grn8(p+1), blu8(p+1), x,y,z,r, 91+kk);

else --Vadasz colors

	ccwNx(red(6*p+1), grn(6*p+1), blu(6*p+1), x,y,z,r,  1+kk);
	ccwPx(red(6*p+2), grn(6*p+2), blu(6*p+2), x,y,z,r, 19+kk);
	ccwNy(red(6*p+3), grn(6*p+3), blu(6*p+3), x,y,z,r, 37+kk);
	ccwPy(red(6*p+4), grn(6*p+4), blu(6*p+4), x,y,z,r, 55+kk);
	ccwNz(red(6*p+5), grn(6*p+5), blu(6*p+5), x,y,z,r, 73+kk);
	ccwPz(red(6*p+6), grn(6*p+6), blu(6*p+6), x,y,z,r, 91+kk);

end if;

end cubelet;








	rrr : constant float := rr;
	k : integer := 0;
	idx,p : rngm;

	xx,yy,zz : float;

	shrink : constant float := 0.95;

	rval, gval, bval : float;

begin --cubic

	for row in rngs loop

		zz := (float(row-1)-0.5)*rrr;
		bval := 0.3 + float(row-1)*0.7;

		for col in rngs loop

			yy := (float(col-1)-0.5)*rrr;
			gval := 0.2 + float(col-1)*0.7;

			for lay in rngs loop

				xx := (float(lay-1)-0.5)*rrr;
				rval := 0.3 + float(lay-1)*0.7;

				idx := indx(row,col,lay);
				p := perm(row,col,lay); --1st call:  p=idx

				if firstcallcubic then
					-- here we define the default RGB skin colors...
					-- same on all faces of each cubelet
					red8(p):=rval;
					grn8(p):=gval;
					blu8(p):=bval;
				end if;

				if firstcallcubic then
					if p /= idx then
						put_line("FirstCall to cubic was permuted?");
						raise program_error;
					end if;
					xxx(p) := xx;
					yyy(p) := yy; --save for use in moving text
					zzz(p) := zz;
				end if;

				if (row/=brow) or (col/=bcol) or (lay/=blay) or winner then
					cubelet(xx,yy,zz, shrink*rrr/2.0, k, p-1);--use zero-based p
					k := k + 108;
				end if;

			end loop; --for lay

		end loop; --col

	end loop; --row

	firstcallcubic := false;

end cubic;




