#-----------------------------------------------------------
# Rumix Rakefile
#
# Requirement:
#   Ruby (1.8.0 later)
#   Rake - <http://rake.rubyforge.org/> or `gem install rake` with RubyGems
#   Exerb - <http://exerb.sourceforge.jp/>
#   Info-Zip - If you use Windows, you can get it from GnuWin32 <http://gnuwin32.sourceforge.net/>
#   msvcr71.dll, msvcp71.dll
#
# Author:   Dice <tetradice@gmail.com>
# License:  NYSL 0.9982 <http://www.kmonos.net/nysl/>
# URL:      http://ruby.morphball.net/rumix/
#-----------------------------------------------------------


require 'rake/clean'
require 'yaml'
require 'spec/rake/spectask'

UNINSTALLER_ZIP = 'package/uninstaller.zip'
UNINSTALLER_SRCS = FileList.new
UNINSTALLER_SRCS.include('rumix_uninstall.exe')
UNINSTALLER_SRCS.include('rumix_uninstall.exe.manifest')




SRCS = FileList['package/*.zip']
SRCS.include(UNINSTALLER_ZIP)
SRCS.include('res/**/*')
SRCS.include('license/**/*')
SRCS.include('rumix_install.exe')
SRCS.include('rumix_install_cui.exe')
SRCS.include('rumix_install.exe.manifest')
SRCS.include('*_license.txt')
SRCS.include('readme.txt')
SRCS.include('rumix.ini')
#SRCS.include('*.dll')


RUBY18_ZIP = 'rumix-0.0.zip'
RUBY18_SRCS = SRCS.dup
RUBY18_SRCS.exclude('package/ruby191.zip')
RUBY18_SRCS.exclude('package/rubyman-newchm-191.zip')

RUBY191_ZIP = 'rumix-0.0_ruby191.zip'
RUBY191_SRCS = SRCS.dup
RUBY191_SRCS.exclude('package/ruby18.zip')
RUBY191_SRCS.exclude('package/rubyman-newchm-18.zip')
RUBY191_SRCS.exclude('package/rubygems.zip', 'package/rake.zip', 'package/exerb.zip')


ORIGINAL_SRCS = FileList.new
ORIGINAL_SRCS.include('readme.txt')
ORIGINAL_SRCS.include('*.ini')
ORIGINAL_SRCS.include('rumix_*.rb')
ORIGINAL_SRCS.include('*.exe.manifest')
ORIGINAL_SRCS.include('Rakefile.rb')
ORIGINAL_SRCS.include('lib/**/*')
ORIGINAL_SRCS.include('res/**/*')
ORIGINAL_SRCS.include('license/**/*')

PACKAGE_ZIP = 'rumix-0.0_bundled-package.zip'
PACKAGE_SRCS = FileList['package/*.zip']
PACKAGE_SRCS.exclude('package/uninstaller.zip')

CLEAN.include('*.filelist', '*.exy')
CLEAN.include('*.log')
CLEAN.include('temp/**/*')
CLEAN.include('__wxautoload.rb')
CLOBBER.include('rumix-*.zip', 'rumix_*.exe', UNINSTALLER_ZIP)
ZIP = 'zip'


task :checkenv do
	require 'tempfile'

	data = [
		[ZIP, '--version'],
		['exerb', '--version'],
		['mkexy', '--help'],
	]
	
	results = []
	
	# Kernel#system output to STDOUT
	data.each do |name, *args|
		if sh(name, *args) then
			results << [true, name, $?]
		else
			results << [false, name, $?]
		end
	end
	
	puts
	puts '--------------------------------'
	
	results.each do |suc, name, code|
		if suc then
			puts "#{name} is OK."
		else
			puts "#{name} is NG... (#{code})"
		end
	end
	
end



task :default => [:build]

desc "Clobber and package."
task :repackage => [:clobber, :package]

desc "Package all release files, with Info-zip. (default)"
task :package => [RUBY18_ZIP, RUBY191_ZIP, 'rumix-0.0_src.zip', PACKAGE_ZIP]

desc "compile script files to windows-exe files by exerb."
task :build => ['rumix_install.exe', 'rumix_install_cui.exe', 'rumix_uninstall.exe']



data = [
	[RUBY18_ZIP, RUBY18_SRCS],
	['rumix-0.0_src.zip', ORIGINAL_SRCS],
	[RUBY191_ZIP, RUBY191_SRCS],
	[UNINSTALLER_ZIP, UNINSTALLER_SRCS],
	[PACKAGE_ZIP, PACKAGE_SRCS],
]

mkdir 'temp' unless File.exist?('temp')
data.each do |zip_name, srcs|
	file zip_name => srcs do |task|
		puts "#{task.name} archiving..."
		src_list = task.prerequisites.to_a.map{|x| %Q|"#{x}"|}.join(' ')
		system "#{ZIP} #{task.name} #{src_list}"

		# include rumix_ruby191.ini
		if zip_name == RUBY191_ZIP then
			
			cp 'rumix_ruby191.ini', 'temp/rumix.ini'
			cd 'temp' do
				system "#{ZIP} ../#{task.name} rumix.ini"
			end
			rm 'temp/rumix.ini'
		end

		puts "#{task.name} maked."
	end
end









rule '.exe' => '.exy' do |task|
	sh "exerb -v #{task.source}"
end

['rumix_install', 'rumix_uninstall'].each do |name|
	file "#{name}.exy" => (FileList['*.rb'] + FileList['lib/**/*.rb'] + ['__wxautoload.rb']) do |task|
		sh "ruby -Ku -r exerb/mkexy #{name}.rb"
	
		data = YAML.load_file(task.name)
		data['general']['core'] = 'gui'
		data['file']['msvcr71.dll'] = {'type' => 'dynamic-library'}
		data['file']['msvcp71.dll'] = {'type' => 'dynamic-library'}
		data['file']['zlib1.dll'] = {'type' => 'dynamic-library'}
		
		data['resource'] ||= {}
		data['resource']['icon'] = []
		[4, 8].each do |color|
			[48, 36, 32, 16].each do |size|
				data['resource']['icon'] << {'file' => 'res/image/ce_jacas/ruby_ns.ico', 'width' => size, 'height' => size, 'color' => color}
			end
		end
		
		open(task.name, 'w'){|f| f.write(data.to_yaml)}
		
	end
end

file 'rumix_install_cui.exy' => (FileList['*.rb'] + FileList['lib/**/*.rb']) do |task|
	sh 'ruby -Ku -r exerb/mkexy rumix_install_cui.rb'
end


# This file is generated because Exerb and WxRuby are not friendly.
# (refer to 'Load in all the class extension methods' in lib/wx.rb)
file '__wxautoload.rb' do |task|
	list = nil
	cd 'lib' do
		list = Dir.glob('wx/**/*.rb')
	end
		
	open(task.name, 'w'){|f|
		f.puts "# This file was generated by Rake."
		f.puts "require 'wx'"
		list.each do |name|
			f.puts "require '#{name}'"
		end
	}
	
	puts "#{task.name} maked."
end



# Proc for initializing each spec-tasks by common parameters
setting = proc do |st|
	st.libs << ['./lib']
	st.verbose = true
	st.ruby_opts = %w(-Ku)
end

desc "Run all spec files. (alias: test)"
Spec::Rake::SpecTask.new do |st|
	setting.call(st)
	st.spec_files = FileList['spec/*.rb']
end

namespace :spec do
	desc "Run spec files of Registry."
	Spec::Rake::SpecTask.new(:registry) do |st|
		setting.call(st)
		st.spec_files = FileList['spec/registry.rb']
	end
end

task :test => :spec
