/*
 * AP-RZA-0A board support
 *
 * Copyright (C) 2013-2014  Renesas Solutions Corp.
 * Copyright (C) 2010  Magnus Damm
 * Copyright (C) 2008  Yoshihiro Shimoda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#include <asm/hardware/gic.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <linux/export.h>
#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <linux/mtd/physmap.h>
#include <linux/platform_device.h>
#include <linux/regulator/fixed.h>
#include <linux/regulator/machine.h>
#include <linux/spi/smanalog.h>
#include <linux/spi/spi.h>
#include <linux/spi/flash.h>
#include <linux/mmc/host.h>
#include <linux/mmc/sh_mmcif.h>
#include <linux/mmc/sh_mobile_sdhi.h>
#include <linux/mfd/tmio.h>
#include <linux/platform_data/dma-rza1.h>
#include <linux/delay.h>
#include <linux/io.h>
#include <mach/common.h>
#include <mach/rza1.h>
#include <linux/i2c.h>
#include <linux/sh_intc.h>
#include <../sound/soc/codecs/wm8978.h>
#include <video/vdc5fb.h>
#include <linux/i2c/lcdkitb01.h>

/* SDHI0 */
static struct sh_mobile_sdhi_info sdhi0_info = {
	.dma_slave_tx	= RZA1DMA_SLAVE_SDHI0_TX,
	.dma_slave_rx	= RZA1DMA_SLAVE_SDHI0_RX,
	.tmio_caps	= MMC_CAP_SD_HIGHSPEED | MMC_CAP_SDIO_IRQ,
	.tmio_ocr_mask	= MMC_VDD_32_33,
	.tmio_flags	= TMIO_MMC_HAS_IDLE_WAIT,
};

static struct resource sdhi0_resources[] = {
	[0] = {
		.name	= "SDHI0",
		.start	= 0xe804e000,
		.end	= 0xe804e0ff,
		.flags	= IORESOURCE_MEM,
	},
	[1] = {
		.name   = SH_MOBILE_SDHI_IRQ_CARD_DETECT,
		.start	= 302,
		.flags	= IORESOURCE_IRQ,
	},
	[2] = {
		.name   = SH_MOBILE_SDHI_IRQ_SDCARD,
		.start	= 303,
		.flags	= IORESOURCE_IRQ,
	},
	[3] = {
		.name   = SH_MOBILE_SDHI_IRQ_SDIO,
		.start	= 304,
		.flags	= IORESOURCE_IRQ,
	},
};

static struct platform_device sdhi0_device = {
	.name		= "sh_mobile_sdhi",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(sdhi0_resources),
	.resource	= sdhi0_resources,
	.dev	= {
		.platform_data	= &sdhi0_info,
	},
};

#include "aprza0a-vdc5fb.c"

static struct platform_device *aprza0a_devices[] __initdata = {
	&sdhi0_device,
};

static struct mtd_partition spibsc0_flash_partitions[] = {
	{
		.name		= "spibsc0_loader",
		.offset		= 0x00000000,
		.size		= 0x00080000,
		/* .mask_flags	= MTD_WRITEABLE, */
	},
	{
		.name		= "spibsc0_bootenv",
		.offset		= MTDPART_OFS_APPEND,
		.size		= 0x00040000,
	},
	{
		.name		= "spibsc0_kernel",
		.offset		= MTDPART_OFS_APPEND,
		.size		= 0x00400000,
	},
	{
		.name		= "spibsc0_rootfs",
		.offset		= MTDPART_OFS_APPEND,
		.size		= MTDPART_SIZ_FULL,
	},
};

static struct mtd_partition spibsc1_flash_partitions[] = {
	{
		.name		= "spibsc1_data",
		.offset		= 0x00000000,
		.size		= MTDPART_SIZ_FULL,
	},
};


static struct flash_platform_data spi_flash_data0 = {
	.name	= "m25p80",
	.parts	= spibsc0_flash_partitions,
	.nr_parts = ARRAY_SIZE(spibsc0_flash_partitions),
	.type = "s25fl512s",
};


static struct flash_platform_data spi_flash_data1 = {
	.name	= "m25p80",
	.parts	= spibsc1_flash_partitions,
	.nr_parts = ARRAY_SIZE(spibsc1_flash_partitions),
	.type = "s25fl512s",
};


static struct spi_board_info aprza0a_spi_devices[] __initdata = {
#if (defined(CONFIG_SPI_MASTER) && defined(CONFIG_MACH_RSKRZA1))
	{
		.modalias = "wm8978",
		.max_speed_hz = 3125000,
		/* max spi clock (SCK) speed in HZ */
		.bus_num = 4,
		.chip_select = 0,
		.mode = SPI_MODE_3,
	},
#endif
	{
		/* spidev */
		.modalias		= "spidev",
		.chip_select		= 0,
		.max_speed_hz		= 5000000,
		.bus_num		= 1,
		.mode			= SPI_MODE_3,
		.clk_delay		= 2,
		.cs_negate_delay	= 2,
		.next_access_delay	= 2,
	},
	{
		/* SPI Flash0 */
		.modalias = "m25p80",
		/* .max_speed_hz = 25000000, */
		.bus_num = 5,
		.chip_select = 0,
		.platform_data = &spi_flash_data0,
	},
	{
		/* SPI Flash1 */
		.modalias = "m25p80",
		/* .max_speed_hz = 25000000, */
		.bus_num = 6,
		.chip_select = 0,
		.platform_data = &spi_flash_data1,
	},
};

static void __init aprza0a_init_spi(void)
{
	/* register SPI device information */
	spi_register_board_info(aprza0a_spi_devices,
				ARRAY_SIZE(aprza0a_spi_devices));
}

static int lcdkitb01_get_irq(void)
{
	printk("%s:%d\n", __func__, __LINE__);
	return 0;
}

static struct lcdkitb01_platform_data lcdkitb01_platform __initdata = {
	.get_irq_pin_state = lcdkitb01_get_irq,
	.poll_period = 100,
};

/* 2014/07/22 追加 */
static struct i2c_board_info aprza0a_i2c_device[] __initdata = {
	[0] = {
		I2C_BOARD_INFO("24c01", 0x50),
		.platform_data = NULL,
	},
	[1] = {
		I2C_BOARD_INFO("s35390a", 0x30),
		.platform_data = NULL,
	},
	[2] = {
		I2C_BOARD_INFO("max9867", 0x18),
		.platform_data = NULL,
	},
	[3] = {
		I2C_BOARD_INFO("LCD-KIT-B01", 0x42),
		.platform_data = &lcdkitb01_platform,
		.irq = 37,
		.flags = I2C_CLIENT_WAKE,
	}
};

static void __init aprza0a_init_i2c(void)
{
	i2c_register_board_info(0,
	                        aprza0a_i2c_device,
	                        ARRAY_SIZE(aprza0a_i2c_device));
}

void __init aprza0a_init(void)
{
	printk("*** %s:%d ***\n  Start.\n", __func__, __LINE__);

//	if (disable_sdhi)
//		sdhi0_device.name = "mobile_sdhi(hidden)";

	platform_add_devices(aprza0a_devices, ARRAY_SIZE(aprza0a_devices));

	rza1_pinmux_setup();

	rza1_devices_setup();

	rza1_pfc_pin_assign(P4_10, ALT3, DIIO_PBDC_EN);		/* SD_D1_0 */
	rza1_pfc_pin_assign(P4_11, ALT3, DIIO_PBDC_EN);		/* SD_D0_0 */
	rza1_pfc_pin_assign(P4_12, ALT3, DIIO_PBDC_DIS);	/* SD_CLK_0 */
	rza1_pfc_pin_assign(P4_13, ALT3, DIIO_PBDC_EN);		/* SD_CMD_0 */
	rza1_pfc_pin_assign(P4_14, ALT3, DIIO_PBDC_EN);		/* SD_D3_0 */
	rza1_pfc_pin_assign(P4_15, ALT3, DIIO_PBDC_EN);		/* SD_D2_0 */

#if defined(CONFIG_SPI_MASTER)
	aprza0a_init_spi();
#endif

#if defined(CONFIG_FB_VDC5)
	vdc5fb_setup();

	/* 2014/07/22 */
	aprza0a_init_i2c();
	rza1_pfc_pin_assign(P1_5, ALT4, DIIO_PBDC_EN);	/* IRQ5 */
#endif
}

int rskrza1_board_i2c_pfc_assign(int id)
{
	/* set I2C pfc configuration */
	switch (id) {
	case 0:
		rza1_pfc_pin_assign(P1_0, ALT1, DIIO_PBDC_EN);	/* I2C SCL0 */
		rza1_pfc_pin_assign(P1_1, ALT1, DIIO_PBDC_EN);	/* I2C SDA0 */
		break;
	case 1:
		break;
	case 2:
		break;
	case 3:
		break;
	}
	return 0;
}

int sf3_enable;

//EXPORT_SYMBOL(aprza0a_board_i2c_pfc_assign);
EXPORT_SYMBOL(rskrza1_board_i2c_pfc_assign);

static const char *aprza0a_boards_compat_dt[] __initdata = {
	"alphaproject,aprza0a",
	NULL,
};

DT_MACHINE_START(APRZA0A_DT, "aprza0a")
	.nr_irqs	= NR_IRQS_LEGACY,
	.map_io		= rza1_map_io,
	.init_early	= rza1_add_early_devices,
	.init_irq	= rza1_init_irq,
	.handle_irq	= gic_handle_irq,
	.init_machine	= aprza0a_init,
	.init_late	= shmobile_init_late,
	.timer		= &shmobile_timer,
	.dt_compat	= aprza0a_boards_compat_dt,
MACHINE_END

