/*
 * Configuation settings for the AlphaProject AP-RZA-0A board
 *
 * Copyright (C) 2013-2014 Renesas Solutions Corp.
 * Copyright (C) 2012 Renesas Electronics Europe Ltd.
 * Copyright (C) 2012 Phil Edworthy
 *
 * Modify : AlphaProject
 *
 * This file is released under the terms of GPL v2 and any later version.
 * See the file COPYING in the root directory of the source tree for details.
 */

#ifndef __APRZA0A_H
#define __APRZA0A_H

#undef DEBUG
#define CONFIG_ARMV7		1	/* This is an ARM V7 CPU core */
#define CONFIG_CPU_RZA1	1
#define CONFIG_BOARD_LATE_INIT	1
#define CONFIG_MACH_TYPE MACH_TYPE_RSKRZA1
#define CONFIG_BOARD_EARLY_INIT_F

#define CONFIG_SYS_NO_FLASH

#define CONFIG_CMD_NET
#define CONFIG_CMD_MII
#define CONFIG_CMD_PING
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_USB
#define CONFIG_CMD_EXT2
#define CONFIG_CMD_EXT4
#define CONFIG_CMD_FAT
/* #define CONFIG_CMD_SF */
#define CONFIG_CMD_I2C
#define CONFIG_CMD_EEPROM
#define CONFIG_CMD_DATE
#define CONFIG_DOS_PARTITION
#define CONFIG_MAC_PARTITION
#define CONFIG_USB_STORAGE
#define CONFIG_CMD_SNTP
#define CONFIG_BOOTP_NTPSERVER
#define CONFIG_BOOTP_TIMEOFFSET


#define CONFIG_OF_LIBFDT
#define CONFIG_CMDLINE_EDITING
#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_INITRD_TAG

#ifndef _CONFIG_CMD_DEFAULT_H
# include <config_cmd_default.h>
#endif

#define CONFIG_BAUDRATE		115200
#define CONFIG_BOOTARGS		"console=ttySC4,115200 root=/dev/sda1 rw rootdelay=3 ignore_loglevel earlyprintk=sh-sci.2,115200"
#define CONFIG_BOOTDELAY	3
#define CONFIG_SYS_BAUDRATE_TABLE	{ CONFIG_BAUDRATE }
#define CONFIG_BOOTCOMMAND		"usb reset ; ext2load usb 0 0c100000 uImage ; ext2load usb 0 0c000000 rza1-aprza0a.dtb ; bootm 0x0c100000 - 0x0c000000"

#define CONFIG_SYS_LONGHELP		/* undef to save memory	*/
#define CONFIG_SYS_PROMPT	"=> "	/* Monitor Command Prompt */
#define CONFIG_SYS_CBSIZE	512	/* Boot Argument Buffer Size */
#define CONFIG_SYS_PBSIZE	256	/* Print Buffer Size */
#define CONFIG_SYS_MAXARGS	16	/* max number of command args */

#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2      "> "

#define CONFIG_SYS_ARM_CACHE_WRITETHROUGH

/* Serial */
#define CONFIG_SCIF_CONSOLE
#define CONFIG_CONS_SCIF4
#define SCIF4_BASE			0xE8009000

/* Memory */
/* u-boot relocated to top 256KB of ram */
#define CONFIG_NR_DRAM_BANKS		1
#define CONFIG_SYS_TEXT_BASE		0x18000000
#define CONFIG_SYS_SDRAM_BASE		0x0C000000
#define CONFIG_SYS_SDRAM_SIZE		(32 * 1024 * 1024)

#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_SDRAM_BASE + 0x2000000)
#define CONFIG_SYS_MALLOC_LEN		(256 * 1024)
#define CONFIG_SYS_MONITOR_LEN		(128 * 1024)
#define CONFIG_SYS_LOAD_ADDR		(CONFIG_SYS_SDRAM_BASE + 4*1024*1024)
#define	CONFIG_LOADADDR			CONFIG_SYS_SDRAM_BASE
#define CONFIG_SYS_INIT_SP_ADDR         (0x0E000000)


/* #define CONFIG_ENV_IS_IN_SPI_FLASH */
#define CONFIG_ENV_IS_NOWHERE
#define CONFIG_ENV_OFFSET	0x80000
#define CONFIG_ENV_SECT_SIZE	0x40000

#define CONFIG_ENV_SIZE		CONFIG_ENV_SECT_SIZE
#define CONFIG_ENV_ADDR		(CONFIG_SYS_FLASH_BASE + CONFIG_ENV_OFFSET)
#define CONFIG_ENV_OVERWRITE	1

#define __io

/* Spi-Flash configuration */
/* #define CONFIG_RZ_SPI */
/* #define CONFIG_SPI_FLASH */
/* #define CONFIG_SPI_FLASH_STMICRO */
/* #define CONFIG_RZA1_BASE_QSPI0		0x3FEFA000 */

/* I2C configuration */
#define CONFIG_SH_RIIC
#define CONFIG_HARD_I2C
#define CONFIG_I2C_MULTI_BUS
#define CONFIG_SYS_MAX_I2C_BUS		4
#define CONFIG_SYS_I2C_SPEED		100000 /* 100 kHz */
#define CONFIG_SYS_I2C_EEPROM_ADDR	0x50
#define CONFIG_SYS_I2C_EEPROM_ADDR_LEN	1
#define CONFIG_SYS_I2C_MODULE		0
#define CONFIG_SH_I2C_BASE0		0xFCFEE000
#define CONFIG_SH_I2C_BASE1		0xFCFEE400
#define CONFIG_SH_I2C_BASE2		0xFCFEE800
#define CONFIG_SH_I2C_BASE3		0xFCFEEc00

/* RTC configuration */
#define CONFIG_RTC_RZA1
#define CONFIG_RTC_RZA1_BASE_ADDR	0xFCFF1000

/* Board Clock */
#define CONFIG_SYS_CLK_FREQ	64000000 /* P1 clock. */
#define CONFIG_SYS_HZ		1000

/* Network interface */
#define CONFIG_SH_ETHER
#define CONFIG_SH_ETHER_USE_PORT	0
#define CONFIG_SH_ETHER_PHY_ADDR	0
#define CONFIG_SH_ETHER_PHY_MODE PHY_INTERFACE_MODE_MII
#define CONFIG_SH_ETHER_EEPROM_ADDR	0 /* MAC address offset in EEPROM */
#define CONFIG_PHYLIB
#define CONFIG_BITBANGMII
#define CONFIG_BITBANGMII_MULTI

/* USB host controller */
#define CONFIG_USB_R8A66597_HCD
#define CONFIG_R8A66597_BASE_ADDR	0xE8010000
#define CONFIG_R8A66597_XTAL		0x0000	/* 48MHz */
#define CONFIG_R8A66597_ENDIAN		0x0000	/* little */

/*
 * Lowlevel configuration
 */
/* Disable WDT */
#define WTCSR_D		0xA518
#define WTCNT_D		0x5A00

/* Set clocks based on 13.3333MHz xtal */
#define FRQCR_D		0x1035	/* CPU= 300-400 MHz */
#define FRQCR2_D	0x0001

/* Enable all peripherals */
#define STBCR2_D	0x0000006A
#define STBCR3_D	0x00000000
#define STBCR4_D	0x00000000
#define STBCR5_D	0x00000000
#define STBCR6_D	0x00000000
#define STBCR7_D	0x00000024
#define STBCR8_D	0x00000005
#define STBCR9_D	0x00000000
#define STBCR10_D	0x00000000
#define STBCR11_D	0x0000000c
#define STBCR12_D	0x000000f0

/* Port Control register */
/* Port0 Control register Reset */
#define PIBC0_D		0x0000

/* Port0 Control register Set */
#define PMC0_S		0x0010
#define PIBC0_S		0x0000

/* Port1 Control register Reset */
#define PIBC1_D		0x0000
#define PBDC1_D		0x0000
#define PM1_D		0xFFFC
#define PMC1_D		0x0003
#define PIPC1_D		0x0000

/* Port1 Control register Set */
#define PBDC1_S		0x0003
#define PFC1_S		0x4000
#define PFCE1_S		0x4000
#define PFCAE1_S	0x0000
#define PIPC1_S		0xFFFF
#define PMC1_S		0x4003
#define P1_S		0x0000
#define PM1_S		0xFFFC
#define PIBC1_S		0x0003

/* Port2 Control register Reset */
#define PIBC2_D		0x0000
#define PBDC2_D		0x0000
#define PM2_D		0xFFFF
#define PMC2_D		0x0000
#define PIPC2_D		0x0000

/* Port2 Control register Set */
#define PBDC2_S		0x0000
#define PFC2_S		0x0FFF
#define PFCE2_S		0x0000
#define PFCAE2_S	0x0000
#define PIPC2_S		0xFFFF
#define PMC2_S		0x0FFF
#define P2_S		0x0000
#define PM2_S		0x0000
#define PIBC2_S		0x0000

/* Port3 Control register Reset */
#define PIBC3_D		0x0000
#define PBDC3_D		0x0000
#define PM3_D		0xFFFF
#define PMC3_D		0x0000
#define PIPC3_D		0x0000

/* Port3 Control register Set */
#define PBDC3_S		0x0000
#define PFC3_S		0x0078
#define PFCE3_S		0x0000
#define PFCAE3_S	0x0000
#define PIPC3_S		0xFFFF
#define PMC3_S		0x0078
#define P3_S		0x0000
#define PM3_S		0xFFFF
#define PIBC3_S		0x0000

/* Port4 Control register Reset */
#define PIBC4_D		0x0000
#define PBDC4_D		0x0000
#define PM4_D		0xFFFF
#define PMC4_D		0x0000
#define PIPC4_D		0x0000

/* Port4 Control register Set */
#define PBDC4_S		0x0000
#define PFC4_S		0x0000
#define PFCE4_S		0x0000
#define PFCAE4_S	0x0000
#define PIPC4_S		0xFFFF
#define PMC4_S		0x03FF
#define P4_S		0x0000
#define PM4_S		0x0000
#define PIBC4_S		0x0000

/* Port5 Control register Reset */
#define PIBC5_D		0x0000
#define PBDC5_D		0x0000
#define PM5_D		0xFFFF
#define PMC5_D		0x0000
#define PIPC5_D		0x0000

/* Port5 Control register Set */
#define PBDC5_S		0x0000
#define PFC5_S		0x0200
#define PFCE5_S		0x0000
#define PFCAE5_S	0x0003
#define PIPC5_S		0x07FF
#define PMC5_S		0x0203
#define P5_S		0x0000
#define PM5_S		0xF800
#define PIBC5_S		0x0002

/* Port6 Control register Reset */
#define PIBC6_D		0x0000
#define PBDC6_D		0x0000
#define PM6_D		0xFFFF
#define PMC6_D		0x0000
#define PIPC6_D		0x0000

/* Port6 Control register Set */
#define PBDC6_S		0x0000
#define PFC6_S		0x0000
#define PFCE6_S		0x0000
#define PFCAE6_S	0x0000
#define PIPC6_S		0xFFFF
#define PMC6_S		0xFFFF
#define P6_S		0x0000
#define PM6_S		0x0000
#define PIBC6_S		0x0000

/* Port7 Control register Reset */
#define PIBC7_D		0x0000
#define PBDC7_D		0x0000
#define PM7_D		0xFFFF
#define PMC7_D		0x0000
#define PIPC7_D		0x0000

/* Port7 Control register Set */
#define PBDC7_S		0x0000
#define PFC7_S		0x0000
#define PFCE7_S		0x0000
#define PFCAE7_S	0x0000
#define PIPC7_S		0xFFFF
#define PMC7_S		0xFEFE
#define P7_S		0x0000
#define PM7_S		0x0000
#define PIBC7_S		0x0000

/* Port8 Control register Reset */
#define PIBC8_D		0x0000
#define PBDC8_D		0x0000
#define PM8_D		0xFFFF
#define PMC8_D		0x0000
#define PIPC8_D		0x0000

/* Port8 Control register Set */
#define PBDC8_S		0x0000
#define PFC8_S		0x0000
#define PFCE8_S		0x0000
#define PFCAE8_S	0x0000
#define PIPC8_S		0xFFFF
#define PMC8_S		0x00FF
#define P8_S		0x0000
#define PM8_S		0x0000
#define PIBC8_S		0x0000

/* Configure SDRAM (CS3) */
#define CS3BCR_D	0x00004C00
#define CS3WCR_D	0x0000488A
#define SDCR_D		0x00000811
#define RTCOR_D		0xA55A000F
#define RTCSR_D		0xA55A0018

#endif	/* __APRZA0A_H */

