require "parsedate"
include ParseDate

module Template
  def make_line(line,local=nil)
  tmp = line.gsub(/\$[A-Za-z0-9_\.]+/){
    |m| 
    instance_eval m.sub(/\$/,"")
  }

  return tmp.gsub(/@@[A-Za-z0-9_\.]+\(\S*\)/){
    |m|
    instance_eval m.sub(/@@/,"")
  }
  end
  private :make_line
end

class BlogViewer
  include Template
  def initialize
    @request = {}
    @out = STDOUT
    @blog = nil
  end
  attr_accessor :out,:blog
  def setparam() end
  def view(path,option) end
  def make_request(path,option)
    req = Hash.new()
    req[BlogAPI::SEARCH_CATEGORY] = path
    req[BlogAPI::SEARCH_LAST] = 5
    if !option.nil? && (option.is_a? Hash )then
      if option.has_key? BlogAPI::SEARCH_LAST then
        req[BlogAPI::SEARCH_LAST] = option[BlogAPI::SEARCH_LAST]
      end
      if option.has_key?  BlogAPI::SEARCH_DATE then
        date = parsedate(option[BlogAPI::SEARCH_DATE])
        req[BlogAPI::SEARCH_DATE] = Time.mktime(date[0],date[1],date[2])
      end
    end
    @request = req
  end
end

class RSSViewer < BlogViewer

HEADER =<<EOS
<?xml version="1.0" encoding="$blog.encoding" ?>
<rdf:RDF 
xmlns="http://purl.org/rss/1.0/"
xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
xmlns:dc="http://purl.org/dc/elements/1.1/"
xmlns:sy="http://purl.org/rss/modules/syndication/"
xml:lang="ja">
<channel rdf:about="$blog.uri">
<title>$blog.title</title>
<link>$blog.uri</link>
<description>$blog.description</description>
<language>$blog.lang</language>
<dc:date>$Time.now.w3cdtf</dc:date>
<items>
<rdf:Seq>
EOS

RDFRESOURCE=<<EOS
<rdf:li rdf:resource="$local" />
EOS

ITEMSEND=<<EOS
</rdf:Seq>
</items>
</channel>
EOS
RSSEND=<<EOS
</rdf>
EOS

ONEITEM=<<EOS
<title>$local.title</title>
<link>$local.link</link>
<description>$local.summary</description>
<dc:date>$local.modified.w3cdtf</dc:date>
</item>
EOS
  def initlalize
  end
  def view(path,option)
    make_request(path,option)
    make_header
    make_channel
    make_itemlist
    make_rssend
  end
  def make_header
    out << make_line(HEADER)
  end
  def make_refresource(uri)
    out << make_line(RDFRESOURCE,uri)
  end
  def make_channel
    index = @blog.search_entry(@request)
    index.each do |h|
      make_refresource(h.link)
    end
    out << ITEMSEND
  end
  def make_item(entry)
    out << make_line(ONEITEM,entry)
  end
  def make_itemlist
    index = @blog.search_entry(@request)
    index.each do |h|
      entry = @blog.get_entry(h.id)
      make_item(entry)
    end
  end
  def make_rssend
    out << RSSEND
  end
end

class HTMLViewer < BlogViewer
  HTML_CONTENTTYPE = "Content-Type: text/html\n\n"
  HTML_HEADER = "<html>\n<head><title>$blog.title</title></head>\n<body>\n<h1>$blog.title</h1><hr /><h3>New Entry list  of this blog</h3> <h3>New Entry list of this category</h3> <hr />\n"
  HTML_ENTRY = "<h4>$local.title</h4>\n$local.modified\n$local.content<p />@@make_url(\"$local.link\") \n<hr />\n"
  HTML_FOOTER = "\n</body>\n</html>\n"
    
  def initlalize
  end
  def view(path,option)
    make_request(path,option)
    make_contentheader()
    make_header
    make_body
    make_footer
  end
  def make_contentheader()
    out << HTML_CONTENTTYPE
  end 
  def make_header
    out << make_line(HTML_HEADER)
  end
  def make_body
    index = @blog.search_entry(@request)
    index.each do |h|
      entry = @blog.get_entry(h.id)
      out << make_line(HTML_ENTRY,entry)
    end
  end
  def make_footer
    out << make_line(HTML_FOOTER)
  end
  def make_url(url)
    return  sprintf("<a href=\"%s\">%s</a>",url,url)
  end

end
