/*
 * Network Library
 *
 * $RCSfile$
 * $Revision$
 * $Date$
 */

#ifndef _LIBDGNETUTIL_H_
#define _LIBDGNETUTIL_H_

/*--- ¤ ---*/

/* ȥ꡼Хåե¤ */
struct streambuffer {
    int   srb_in;	/* ϤΤΥեǥץ */
    int   srb_out;	/* ϤΤΥեǥץ */
    int   srb_flag;     /* ե饰 */
    char *srb_buf;	/* ɤ߹Хåե */
    int   srb_len;	/* ɤ߹ХåեĹ */
    int   srb_errno;	/* 顼ʥСǼ */
};


/*--- ޥ ---*/

/* ȥ꡼Хåե¤ΤΥsrb_flagե饰 */
#define SRB_FLAG_EOF	 	0x01
#define SRB_FLAG_ERROR		0x10
#define SRB_FLAG_MEMERROR	0x20
#define SRB_FLAG_TIMEOUT	0x40

#define SRB_BUFSIZE 1024             // Хåե

/* ؿ֤ */
#define SRB_ERROR_TIMEOUT    -3      // ॢ
#define SRB_ERROR_MEM        -2      // ꥨ顼
#define SRB_ERROR_IO         -1      // IO顼
#define SRB_OK                0      // 


/*--- ؿޥ ---*/

#define SRB_FLAG_ERRORS		((SRB_FLAG_ERROR) | \
                                 (SRB_FLAG_MEMERROR) | \
                                 (SRB_FLAG_TIMEOUT))

/* ԤޤǤɤ߹ */
#define srb_read_line(x, y)	srb_read_tostr(x, y, "\r\n")


/*--- ץȥ ---*/

extern void  srb_init(struct streambuffer *, int, int);
extern void  srb_clean(struct streambuffer *);
extern char *srb_read_tostr(struct streambuffer *, int *, const char *);
extern char *srb_read(struct streambuffer *, int *);
extern char *srb_read_len(struct streambuffer *, int *, int);
extern int   srb_write(struct streambuffer *, char *, int);
extern int   srb_rollback(struct streambuffer *, char *, int);


#endif	/* _LIBDGNETUTIL_H_ */
