<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * 饤󥹥ȥ졼Ϣ
 *
 * $RCSfile: index.php,v $
 * $Revision: 5.00 $
 * $Date: 2021/05/26 10:10:10 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibldap");
include_once("lib/dglibsamma");

/********************************************************
ƥڡ
*********************************************************/

define("OPERATION", "饤󥹥ȥ졼Ϣ");
define("TMPLFILE", "samma/samma_admin_osuploader.tmpl");

/*********************************************************
 * check_tmpl
 *
 * ƥץ졼ȥեå
 *
 * []
 *       $filename      ƥץ졼ȥե
 *
 * [֤]
 *      TRUE            
 *      FALSE           ۾
 **********************************************************/
function check_tmpl($filename)
{
    global $err_msg;

    /* å*/
    $ret = check_file($filename);
    if ($ret === FAIL) {
        $err_msg = "ƥץ졼" . $err_msg;
        return FALSE;
    /* ե뤬ʤϺ */
    } elseif ($ret === FAIL_NO_EXIST) {
        /* ǥ쥯ȥ񤭹߸å */
        if (is_writable(dirname($filename)) !== TRUE) {
            $err_msg = "ǥ쥯ȥ˽߸ޤ(" . $filename . ")";
            return FALSE;
        }
    }

    return TRUE;
}

/***********************************************************
 * display_result()
 *
 * ֤ξ򥻥åȤ
 *
 * []
 *      $tag  ֤
 *
 * [֤]
 *       ʤ
 **********************************************************/
function display_result(&$tag) 
{
    global $sesskey;
    global $samma_conf;
    global $logfacility;
    global $web_conf; 

    /* NextCloudAPIΥȥåפURL */
    $nc_url = "";
    if (isset($samma_conf["nc_url"]) === TRUE && 
              $samma_conf["nc_url"] != "") {
        $nc_url = escape_html($samma_conf["nc_url"]);
    }
    $tag["<<NC_URL>>"] = $nc_url;

    /* NextCloudδԥ桼ID */
    $nc_admin = "";
    if (isset($samma_conf["nc_admin"]) === TRUE && 
              $samma_conf["nc_admin"] != "") {
        $nc_admin = escape_html($samma_conf["nc_admin"]);
    }
    $tag["<<NC_ADMIN>>"] = $nc_admin;

    /* NextCloudδԥѥ */
    $nc_adminpw = "";
    if (isset($samma_conf["nc_adminpw"]) === TRUE && 
              $samma_conf["nc_adminpw"] != "nc_adminpw") {
        $nc_adminpw = escape_html($samma_conf["nc_adminpw"]);
    }
    $tag["<<NC_ADMINPW>>"] = $nc_adminpw;

    /* NextCloudؤΥॢ */
    $nc_timeout = "";
    if (isset($samma_conf["nc_timeout"]) === TRUE && 
              $samma_conf["nc_timeout"] != "") {
        $nc_timeout = escape_html($samma_conf["nc_timeout"]);
    }
    $tag["<<NC_TIMEOUT>>"] = $nc_timeout;

    /* HTTPS */
    $https_cert = "";
    if (isset($samma_conf["https_cert"]) === TRUE && 
              $samma_conf["https_cert"] != "") {
        $https_cert = escape_html($samma_conf["https_cert"]);
    }
    $tag["<<HTTPS_CERT>>"] = $https_cert;

    /* ƥץ졼ȥե̾ */
    $template_file = "";
    if (isset($samma_conf["template_file"]) === TRUE && 
              $samma_conf["template_file"] != "") {
        $template_file = escape_html($samma_conf["template_file"]);
    }
    $tag["<<TEMPLATE_FILE>>"] = $template_file;

    /* StrCode */
    $str_code = "";
    if (isset($samma_conf["str_code"]) === TRUE && 
              $samma_conf["str_code"] != "") {
        $str_code = escape_html($samma_conf["str_code"]);
    }
    $tag["<<STR_CODE>>"] = $str_code;

    /* 1åNextCloud˥åץɥե */
    $concurrent = "";
    if (isset($samma_conf["concurrent"]) === TRUE &&
              $samma_conf["concurrent"] != "") {
        $concurrent = escape_html($samma_conf["concurrent"]);
    }
    $tag["<<CONCURRENT>>"] = $concurrent;

    /* NextCloudΤ줿ͭURLΥץȥŪhttpsѹե饰 */
    $flag_on = "";
    $flag_off = "checked";
    if (isset($samma_conf["force_https"]) === TRUE && 
              $samma_conf["force_https"] != "") {
        if (strtolower($samma_conf["force_https"]) === "true") {
            $flag_on = "checked";
            $flag_off = "";
        }
    }
    $tag["<<FORCE_HTTPS_ON>>"] = $flag_on;
    $tag["<<FORCE_HTTPS_OFF>>"] = $flag_off;

    return TRUE;
}

/*********************************************************
 * check_conf_data
 *
 * եǡå
 *
 * []
 *       $data		եǡ
 *
 * [֤]
 *	TRUE		
 *	FALSE		۾
 **********************************************************/
function check_conf_data(&$data)
{
    global $err_msg;
    global $logfacility;
    global $str_code;
    global $samma_conf;

    /*
     * ɬܹܤΥå
     */
    /* NextCloudAPIΥȥåפURL */
    if ($data["nc_url"] === "") {
        $err_msg = "NextCloudAPIΥȥåפURLϤƤޤ";
        return FALSE;
    }

    /* NextCloudδԥ桼ID */
    if ($data["nc_admin"] === "") {
        $err_msg = "NextCloudδԥ桼IDϤƤޤ";
        return FALSE;
    }
    /* NextCloudδԥѥ */
    if ($data["nc_adminpw"] === "") {
        $err_msg = "NextCloudδԥѥɤϤƤޤ";
        return FALSE;
    }

    /*
     * å
     */

    /* NextCloudؤΥॢ */
    if ($data["nc_timeout"] !== "") {
        if (check_integer($data["nc_timeout"]) === FALSE) {
            $err_msg = "NextCloudؤΥॢȤ1ʾꤷƤ";
            return FALSE;
        }
    }

    /* ƥץ졼ȥե̾ */
    if ($data["template_file"] !== "") {
        /* å(ʤк) */
        if (check_tmpl($data["template_file"]) === FALSE) {
            return FALSE;
        }
    }

    /* 1åNextCloud˥åץɥե */
    if ($data["concurrent"] !== "") {
        if (check_integer($data["concurrent"]) === FALSE) {
            $err_msg = "1åNextCloud˥åץɥե1ʾꤷƤ";
            return FALSE;
        }
    }

    return TRUE;
}

/*********************************************************
 * check_messagetmplpath
 *
 * ʸɵΥեѥͤå
 * ե¸ߤʤ硢ե
 * 
 * []
 *       $jp_path       ʸɵΥեѥ(ܸ)
 *       $en_path       ʸɵΥեѥ(Ѹ)
 *       $both_path     ʸɵΥեѥ(ξ)
 *       &$errormsg     顼å(ȥǡ)
 *
 * [֤]
 *      TRUE            
 *      FALSE           ۾
 **********************************************************/
function check_messagetmplpath($jp_path, $en_path, $both_path, &$errormsg)
{
    if (strlen($jp_path) > 256) {
        $errormsg = "ʸɵΥեѥ(ܸ)ĹǤ($jp_path)";
        return FALSE;
    }

    if (strlen($en_path) > 256) {
        $errormsg = "ʸɵΥեѥ(Ѹ)ĹǤ($en_path)";
        return FALSE;
    }

    if (strlen($both_path) > 256) {
        $errormsg = "ʸɵΥեѥ(ξ)ĹǤ($both_path)";
        return FALSE;
    }

    if ($jp_path !== "") {
        /* ե¸ߤå */
        if (!file_exists($jp_path)) {
            /* ե */
            if (touch($jp_path) === FALSE) { 
                $errormsg = "ʸɵΥե(ܸ)κ˼Ԥޤ($jp_path)";
                return FALSE;
            }
        }
       /* ̾ե뤫ɤĴ٤ */
       if(!is_file($jp_path)) {
            $errormsg = "ʸɵΥե(ܸ)̾եǤϤޤ($jp_path)";
            return FALSE;
       }
    }

    if ($en_path !== "") {
        /* ե¸ߤå */
        if (!file_exists($en_path)) {
            /* ե */
            if (!touch($en_path)) {
                $errormsg = "ʸɵΥե(Ѹ)κ˼Ԥޤ($en_path)";
                return FALSE;
            }
        }
       /* ̾ե뤫ɤĴ٤ */
       if(!is_file($en_path)) {
            $errormsg = "ʸɵΥե(ܸ)̾եǤϤޤ($en_path)";
            return FALSE;
       }
    }

    if ($both_path) {
        /* ե¸ߤå */
        if (!file_exists($both_path)) {
            /* ե */
            if (!touch($both_path)) {
                $errormsg = "ʸɵΥե(ξ)κ˼Ԥޤ($both_path)";
                return FALSE;
            }
        }
        /* ̾ե뤫ɤĴ٤ */
        if(!is_file($both_path)) {
            $errormsg = "ʸɵΥե(ܸ)̾եǤϤޤ($both_path)";
            return FALSE;
        }
    }

    return TRUE;
}

/*********************************************************
 * check_db
 *
 * ǡ١եå
 *
 * []
 *       $db_file	DBե
 *	 $db_type	DB
 *
 * [֤]
 *	TRUE		
 *	FALSE		۾
 **********************************************************/
function check_db($db_file, $db_type)
{
    global $err_msg;

    /* å*/
    $ret = check_file($db_file);
    if ($ret === FAIL) {
        $err_msg = "DB" . $err_msg;
        return FALSE;
    /* DBե뤬ʤϺ */
    } elseif ($ret === FAIL_NO_EXIST) {
        /* DB */
        $type = 0;
        if ($db_type == "btree") {
            $type = 1;
        }
        if (make_db($db_file, $type) === FALSE) {
            $err_msg = "DBѤ" . $err_msg;
            return FALSE;
        }
    /* åOKʾϷå */
    } else {
        $command = sprintf(CONFIRM_DB, $db_type, escapeshellcmd($db_file));
        $ret = system($command, $result);

        if ($result != 0) {
            $err_msg = "DBǤ";
            return FALSE;
        }
        if ($ret === FALSE){
            $err_msg = "DBγǧ˼Ԥޤ";
            return FALSE;
        }
    }
    return TRUE;

}

/*********************************************************
 * set_disp_data
 *
 * ͤɽ˥åȤޤ
 *
 * []
 *       $data		ǡ
 *	 $disp_data	ǡ
 *
 * [֤]
 *	ʤ
 **********************************************************/
function set_disp_data($data, &$disp_data)
{

    /* NextCloudAPIΥȥåפURL */
    if (isset($data["nc_url"]) === TRUE) {
        $disp_data["nc_url"] = $data["nc_url"];
    }

    /* NextCloudδԥ桼ID */
    if (isset($data["nc_admin"]) === TRUE) {
        $disp_data["nc_admin"] = $data["nc_admin"];
    }

    /* NextCloudδԥѥ */
    if (isset($data["nc_adminpw"]) === TRUE) {
        $disp_data["nc_adminpw"] = $data["nc_adminpw"];
    }

    /* NextCloudؤΥॢ */
    if (isset($data["nc_timeout"]) === TRUE) {
        $disp_data["nc_timeout"] = $data["nc_timeout"];
    }

    /* HTTPS */
    if (isset($data["https_cert"]) === TRUE) {
        $disp_data["https_cert"] = $data["https_cert"];
    }

    /* ƥץ졼ȥե̾ */
    if (isset($data["template_file"]) === TRUE) {
        $disp_data["template_file"] = $data["template_file"];
    }

    /* StrCode */
    if (isset($data["str_code"]) === TRUE) {
        $disp_data["str_code"] = $data["str_code"];
    }

    /* 1åNextCloud˥åץɥե */
    if (isset($data["concurrent"]) === TRUE) {
        $disp_data["concurrent"] = $data["concurrent"];
    }

    /* NextCloudΤ줿ͭURLΥץȥŪhttpsѹե饰 */
    if (isset($data["force_https"]) === TRUE) {
        if (strtolower($data["force_https"]) === "true") {
            $force_https = "True";
        } else {
            $force_https = "False";
        }

        $disp_data["force_https"] = $force_https;
    }

    return;
}

/***********************************************************
 * 
 **********************************************************/
/* ͤν */
$tag = array();

/* å󥭡ѿ */
if (isset ($_POST["sk"]) === TRUE) {
    $sesskey = $_POST["sk"];
}

/* ե륿ִեɹåΥå */
$ret = init();
if ($ret === FALSE) {
    syserr_display();
    exit (1);
}

/* SaMMAեɹ */
$ret = read_samma_conf($web_conf["postldapadmin"]["sammaosuploaderconf"]);
if ($ret === FALSE) {
    syserr_display();
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/
/* ʬ */

/*  */
if (isset($_POST["mod"]) === TRUE) {
    /* ݻѥǡ */
    set_disp_data($_POST, $samma_conf);
    /* ϥå */
    if (check_conf_data($samma_conf) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        /*  */
        if (mod_osuploader_conf($samma_conf) === FALSE) {
            result_log(OPERATION . ":NG:" . $err_msg);
        /*  */
        } else {
            $err_msg = "饤󥹥ȥ졼ե򹹿ޤ";
            result_log(OPERATION . ":OK:" . $err_msg);
           /* ˥塼̤ */
           dgp_location("../index.php", $err_msg);
           exit (0);
        }
    }

/* 󥻥 */
} elseif (isset($_POST["cancel"]) === TRUE) {
    /* ˥塼̤ */
    dgp_location("../index.php", $err_msg);
    exit (0);

}

/***********************************************************
 * ɽ
 **********************************************************/

/* ̤Υ */
set_tag_common($tag);

/* ̤֤ */
display_result($tag);

/* ڡν */
$ret = display(TMPLFILE, $tag, array(), "", "");
if ($ret === FALSE) {
    result_log($log_msg, LOG_ERR);
    syserr_display();
    exit(1);
}

?>
