/*
 * Created on 2004/06/15
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.*;
import java.awt.*;
import java.awt.geom.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SGSignificantDifferenceSymbol extends SGDrawingElement
	implements SGIDrawingElementJava2D
{

	/**
	 * 
	 */
	protected float mX = 0.0f;


	/**
	 * 
	 */
	protected float mY = 0.0f;


	/**
	 * 
	 */
	protected float mWidth = 0.0f;


	/**
	 * 
	 */
	protected float mLeftHeight = 0.0f;


	/**
	 * 
	 */
	protected float mRightHeight = 0.0f;


	/**
	 * 
	 */
	protected float mSpace = 0.0f;


	/**
	 * 
	 */
	protected SGDrawingElementString2D mStringElement = new SGDrawingElementString2D("*");


	/**
	 * 
	 */
	protected float mLineWidth = 3.0f;


	/**
	 * 
	 */
	protected float mMagnification = 1.0f;


	/**
	 * 
	 */
	protected SGDrawingElementLine2D mLineTop = new SGDrawingElementLine2D();


	/**
	 * 
	 */
	protected SGDrawingElementLine2D mLineLeft = new SGDrawingElementLine2D();


	/**
	 * 
	 */
	protected SGDrawingElementLine2D mLineRight = new SGDrawingElementLine2D();


	/**
	 * 
	 */
	protected boolean mVerticalFlag = true;


	/**
	 * 
	 */
	public static final int mMinWidth = 10;
	
	
	/**
	 * 
	 */
	public static final int mMinHeight = 10;



	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSignificantDifferenceSymbol(
		final float x,
		final float y,
		final float w,
		final float hl,
		final float hr )
	{
		super();
		this.setLocation(x,y);
		this.setSize(w,hl,hr);
	}



	/**
	 * 
	 */
	public boolean createDrawingElement()
	{

		final SGTuple2f leftTop = new SGTuple2f(
			this.getX(),
			this.getY() );

		final SGTuple2f rightTop = new SGTuple2f(
			this.getX() + this.getWidth(),
			this.getY() );

		final SGTuple2f leftBottom = new SGTuple2f(
			this.getX(),
			this.getY() + this.getLeftHeight() );

		final SGTuple2f rightBottom = new SGTuple2f(
			this.getX() + this.getWidth(),
			this.getY() + this.getRightHeight() );

		this.mLineTop.setTermPoints( leftTop, rightTop );
		this.mLineLeft.setTermPoints( leftTop, leftBottom );
		this.mLineRight.setTermPoints( rightTop, rightBottom );

		final Rectangle2D rect = this.mStringElement.getElementBounds();
		final float rectWidth = (float)rect.getWidth();
		final float rectHeight = (float)rect.getHeight();


		final float strX = this.getX() + this.getWidth()/2.0f - (rectWidth/2.0f);
		float strY;
		if( this.mVerticalFlag )
		{
			strY = this.getY() - this.mSpace*this.mMagnification - rectHeight;
		}
		else
		{
			strY = this.getY() + this.mSpace*this.mMagnification;
		}

		this.mStringElement.setLocation( strX, strY );


		return true;

	}



	/**
	 * 
	 */
	public ArrayList getDrawingElementList()
	{
		ArrayList list = new ArrayList();
		list.add(this.mLineTop);
		list.add(this.mLineLeft);
		list.add(this.mLineRight);
		return list;
	}


	/**
	 * 
	 */
	public float getX()
	{
		return this.mX*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mY*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getWidth()
	{
		return this.mWidth*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getLeftHeight()
	{
		return this.mLeftHeight*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getRightHeight()
	{
		return this.mRightHeight*this.mMagnification;
	}


	/**
	 * 
	 */
	public float getSpace()
	{
		return this.mSpace;
	}


	/**
	 * 
	 */
	public boolean getVerticalFlag()
	{
		return this.mVerticalFlag;
	}


	/**
	 * 
	 */
	public Point2D getLeftJoint()
	{
		final Point2D pos = new Point2D.Float( this.getX(), this.getY() );
		return pos;
	}


	/**
	 * 
	 */
	public Point2D getLeftTerm()
	{
		float d;
		if( this.mVerticalFlag )
		{
			d = this.getLeftHeight();
		}
		else
		{
			d = - this.getLeftHeight();
		}
		final Point2D pos = new Point2D.Float( this.getX(), this.getY() + d );
		return pos;
	}


	/**
	 * 
	 */
	public Point2D getRightJoint()
	{
		final Point2D pos = new Point2D.Float( this.getX() + this.getWidth(), this.getY() );
		return pos;
	}



	/**
	 * 
	 */
	public Point2D getRightTerm()
	{
		float d;
		if( this.mVerticalFlag )
		{
			d = this.getLeftHeight();
		}
		else
		{
			d = - this.getLeftHeight();
		}
		final Point2D pos = new Point2D.Float( this.getX() + this.getWidth(), this.getY() + d );
		return pos;
	}



	/**
	 * 
	 */
	public SGDrawingElementString2D getStringElement()
	{
		return this.mStringElement;
	}


	/**
	 * 
	 */
	public String getText()
	{
		return this.mStringElement.getString();
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.mStringElement.getFontSize();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.mStringElement.getFontStyle();
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return this.mStringElement.getFontFamilyName();
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.getColor(0);
	}


	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mX = x;
		this.mY = y;

		return true;
	}


	/**
	 * 
	 */
	public boolean setSize( final float w, final float hl, final float hr )
	{
		if( w<0 || hl<0 || hr<0 )
		{
			throw new IllegalArgumentException("w<0 || hl<0 || hr<0");
		}

		this.mWidth = w;
		this.mLeftHeight = hl;
		this.mRightHeight = hr;

		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		if( w<0 )
		{
			throw new IllegalArgumentException("w<0");
		}
		
		this.mWidth = w/this.mMagnification;

		return true;
	}


	/**
	 * 
	 */
	public boolean setLeftHeight( final float h )
	{
		if( h<0 )
		{
			throw new IllegalArgumentException("h<0");
		}
		
		this.mLeftHeight = h/this.mMagnification;

		return true;
	}


	/**
	 * 
	 */
	public boolean setRightHeight( final float h )
	{
		if( h<0 )
		{
			throw new IllegalArgumentException("h<0");
		}
		
		this.mRightHeight = h/this.mMagnification;

		return true;
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		if( space<0 )
		{
			throw new IllegalArgumentException("space<0");
		}

		this.mSpace = space;

		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		super.setMagnification(mag);

		ArrayList dList = this.getDrawingElementList();
		for( int ii=0; ii<dList.size(); ii++ )
		{
			SGDrawingElement el = (SGDrawingElement)dList.get(ii);
			el.setMagnification(mag);
		}

		this.mStringElement.setMagnification(mag);

		return true;
	}


	/**
	 * 
	 */
	public boolean setText( final String text )
	{
		this.mStringElement.setString( text );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		this.mLineWidth = lineWidth;
		return true;
	}



	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mStringElement.setFontSize(size);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		this.mStringElement.setFontStyle(style);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.mStringElement.setFontFamilyName(name);
		return true;
	}


	/**
	 * 
	 */
	public boolean setVerticalFlag( final boolean b )
	{
		this.mVerticalFlag = b;
		return true;
	}


	/**
	 * 
	 */
	public boolean contains( final int x, final int y )
	{
		ArrayList dList = this.getDrawingElementList();
		for( int ii=0; ii<dList.size(); ii++ )
		{
			SGDrawingElement el = (SGDrawingElement)dList.get(ii);
			if( el.contains(x,y) )
			{
				return true;
			}
		}

		return false;
	}


	/**
	 * 
	 */
	public ArrayList getShapeList()
	{
		ArrayList dList = this.getDrawingElementList();
		ArrayList list = new ArrayList();
		for( int ii=0; ii<dList.size(); ii++ )
		{
			SGDrawingElementLine2D el = (SGDrawingElementLine2D)dList.get(ii);
			list.add( el.getShape() );
		}

		return list;
	}



	/**
	 * 
	 */
	public Shape getConnectedShape()
	{
		GeneralPath gp = new GeneralPath();
		gp.append( this.mLineLeft.getShape(), true );
		gp.append( this.mLineTop.getShape(), true );
		gp.append( this.mLineRight.getShape(), true );

		return gp;
	}



	/**
	 * 
	 */
	public boolean zoom( final float mag )
	{
		this.mMagnification = mag;

		this.createDrawingElement();

		ArrayList dList = this.getDrawingElementList();
		for( int ii=0; ii<dList.size(); ii++ )
		{
			SGDrawingElement el = (SGDrawingElement)dList.get(ii);
			el.setMagnification(mag);
		}
		
		this.mStringElement.setMagnification(mag);

		this.createDrawingElement();

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public Rectangle2D getElementBounds()
	{
		ArrayList rectList = new ArrayList();
		rectList.add( this.getLineBounds() );
		rectList.add( this.getStringBounds() );
		Rectangle2D rect = SGUtility.createUnion(rectList);

		return rect;
	}


	/**
	 * 
	 */
	public Rectangle2D getLineBounds()
	{
		ArrayList rectList = new ArrayList();
		ArrayList dList = this.getDrawingElementList();
		for( int ii=0; ii<dList.size(); ii++ )
		{
			SGDrawingElementLine2D el = (SGDrawingElementLine2D)dList.get(ii);
			rectList.add( el.getShape().getBounds2D() );
		}

		Rectangle2D rect = SGUtility.createUnion(rectList);

		return rect;
	}


	/**
	 * 
	 */
	public Rectangle2D getStringBounds()
	{
		return this.mStringElement.getElementBounds();
	}


}
