/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement;

public class SGStringElementDialog
extends SGPropertyDialog {
    public static final String TITLE = "String Element Dialog";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mColorButton;
    private JPanel mCommonPanel;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mTextAngleLabel;
    private SGSpinner mTextAngleSpinner;
    private JLabel mTextColorLabel;
    private JPanel mTextPanel;
    private JLabel mXValueLabel;
    private JTextField mXValueTextField;
    private JLabel mYValueLabel;
    private JTextField mYValueTextField;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGStringElementDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTextPanel = new JPanel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mTextAngleSpinner = new SGSpinner();
        this.mTextColorLabel = new JLabel();
        this.mTextAngleLabel = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mColorButton = new JButton();
        this.mFontNameComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new JTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new JTextField();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mFontStyleLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGStringElementDialog.this.closeDialog(windowEvent);
            }
        });
        this.mTextPanel.setLayout(new GridBagLayout());
        this.mTextPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGStringElementDialog.this.mFontStyleComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mTextAngleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleSpinner, gridBagConstraints);
        this.mTextColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextColorLabel, gridBagConstraints);
        this.mTextAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleLabel, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.mTextPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTextPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 0, 0);
        this.mTextPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mXValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mYValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 4, 0, 0);
        this.mTextPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTextPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private void mFontStyleComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        Object object = SGUtility.getAvailableFontNames();
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.mFontNameComboBox.addItem(object[i]);
        }
        String[] stringArray = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray[i]);
        }
        this.pack();
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mLeftBottomRadioButton);
        ((ButtonGroup)object).add(this.mLeftTopRadioButton);
        ((ButtonGroup)object).add(this.mRightBottomRadioButton);
        ((ButtonGroup)object).add(this.mRightTopRadioButton);
        ((ButtonGroup)object).add(this.mNoAxisSelectionRadioButton);
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mTextAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0), "\u00b0");
        this.mColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        return true;
    }

    public String getXAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Top";
        }
        return string;
    }

    public String getYAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public ArrayList getTextColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColorButton.getBackground());
        return arrayList;
    }

    public Number getAngle() {
        return this.mTextAngleSpinner.getNumber();
    }

    public boolean setFontSize(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mFontSizeSpinner.setValue(f);
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mColorButton.setBackground(color);
        return true;
    }

    public boolean setAngle(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Float f = SGUtilityText.getFloat(string);
        if (f == null) {
            return false;
        }
        this.mTextAngleSpinner.setValue(f);
        return true;
    }

    public boolean setXValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mXValueTextField.setText(string);
        return true;
    }

    public boolean setYValue(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        this.mYValueTextField.setText(string);
        return true;
    }

    public boolean setAxisRadioButton(int n, int n2) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        this.mLeftBottomRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightBottomRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        this.mLeftTopRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightTopRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mTextAngleSpinner);
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.getColorSelectionComponentList().contains(object)) {
            JButton jButton;
            this.mFocusedColorSetButton = jButton = (JButton)object;
            this.setColorButtonBorder(true);
            this.mColorDialog.setVisible(true);
        }
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        this.mXValueTextField.addActionListener(actionListener);
        this.mYValueTextField.addActionListener(actionListener);
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
            this.mXValueTextField.removeActionListener(actionListenerArray[i]);
            this.mYValueTextField.removeActionListener(actionListenerArray[i]);
        }
        return true;
    }

    public SGStringElement.LabelProperties getProperties() {
        SGStringElement.LabelProperties labelProperties = new SGStringElement.LabelProperties();
        Number number = this.getFontSize();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        labelProperties.setFontSize(number.floatValue());
        labelProperties.setFontName(this.getFontName());
        labelProperties.setFontStyle(this.getFontStyle());
        Number number2 = this.getAngle();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        labelProperties.setAngle(number2.floatValue() * ((float)Math.PI / 180));
        labelProperties.setColorList(this.getTextColorList());
        return labelProperties;
    }
}

