/*
 * BadXMLException.java
 *
 * Created on February 14, 2001, 6:48 PM
 */

package org.freehep.xml.util;
import org.xml.sax.SAXException;
import org.freehep.util.NestedException;
import org.freehep.util.HasNestedException;
/**
 * A SAXException with an optional nested exception
 * @author  tonyj
 * @version $Id: BadXMLException.java,v 1.1.1.1 2004/05/31 05:08:49 kuromaru Exp $
 */

public class BadXMLException extends SAXException implements HasNestedException
{
    public BadXMLException(String message) 
    {
        super(message);
    }
    public BadXMLException(String message, Throwable detail) 
    { 
        super(message); 
        this.detail = detail; 
    }
    public Throwable getNestedException()
    {
        return detail;
    }
    public String getMessage()
    {
        return NestedException.formatNestedException(this);
    }
    public String getSimpleMessage()
    {
        return super.getMessage();
    }
    private Throwable detail;
    }
