
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import org.w3c.dom.Document;


/**
 * An interface for objects on a figure.
 */

public interface SGIGraphElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public boolean setAxisElement( SGIAxisElement aElement );


	/**
	 * 
	 */
	public String getDataName( SGData data );


	/**
	 * 
	 */
	public ArrayList getDrawingElementList( SGData data );


	/**
	 * 
	 */
	public boolean isDataVisible( SGData data );



	/**
	 * 
	 * @param document
	 * @return
	 */
	public boolean createElementOfData( Document document, ArrayList elList );

	
	
	/**
	 * 
	 * @return
	 */
	public int getVisibleDataNumber();


	/**
	 * 
	 */
	public int getSelectedDataNumber();


	/**
	 * 
	 */
	public boolean removeSelectedData();


	/**
	 * 
	 */
	public boolean hideSelectedData();


	/**
	 * 
	 */
	public boolean moveSelectedDataToFront();


	/**
	 * 
	 */
	public boolean moveSelectedDataToBack();



	/**
	 * 
	 */
	public boolean changeXAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeYAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeZAxis( SGData data );


	/**
	 * 
	 */
	public ArrayList getVisibleFlagList( SGData data );


	/**
	 * 
	 * @param data
	 * @return
	 */
	public boolean getVisibleInLegendFlag( SGData data );



	/**
	 * 
	 * @return
	 */
	public ArrayList getPropertySettingListerListOfDataElements();


	/**
	 * 
	 * @return
	 */
	public SGPropertyDialog getPropertyDialogForDataElements();




	public static final String TAG_NAME_GRAPH = "Graph";

	public static final String TAG_NAME_DATA = "Data";

	public static final String PF_SAMPLING_RATE = "SamplingRate";




}

