/*
 * SGWindowDialog.java
 *
 * Created on 2004/06/09, 16:23
 */

package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.SpinnerNumberModel;


/**
 *
 * @author  kuromaru
 */
public class SGWindowDialog  extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Window Dialog";


    
    /** Creates new form SGWindowDialog */
    public SGWindowDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mWindowPanel = new javax.swing.JPanel();
        mWidthLabel = new javax.swing.JLabel();
        mHeightLabel = new javax.swing.JLabel();
        mWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mHeightSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSizeLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mIntervalLabel = new javax.swing.JLabel();
        mGridLinesIntervalSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBottomLabel = new javax.swing.JLabel();
        mGridLinesWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mGridLabel = new javax.swing.JLabel();
        mGridLinesColorButton = new javax.swing.JButton();
        mBackgroundColorLabel1 = new javax.swing.JLabel();
        mGridLinesColorLabel = new javax.swing.JLabel();
        mBackgroundColorButton = new javax.swing.JButton();
        mSizeSeparator = new javax.swing.JSeparator();
        mGridSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mGridVisibleCheckBox = new javax.swing.JCheckBox();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mWindowPanel.setLayout(new java.awt.GridBagLayout());

        mWindowPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mWindowPanel.add(mWidthLabel, gridBagConstraints);

        mHeightLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightLabel.setText("Height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mWindowPanel.add(mHeightLabel, gridBagConstraints);

        mWidthSpinner.setFont(new java.awt.Font("Monospaced", 0, 12));
        mWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mWidthSpinner, gridBagConstraints);

        mHeightSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mHeightSpinner, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 0, 5);
        mWindowPanel.add(mSizeLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        mWindowPanel.add(mColorLabel, gridBagConstraints);

        mIntervalLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalLabel.setText("Interval");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mWindowPanel.add(mIntervalLabel, gridBagConstraints);

        mGridLinesIntervalSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridLinesIntervalSpinner, gridBagConstraints);

        mBottomLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBottomLabel.setText("Line width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mWindowPanel.add(mBottomLabel, gridBagConstraints);

        mGridLinesWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridLinesWidthSpinner, gridBagConstraints);

        mGridLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mGridLabel.setText("Grid");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        mWindowPanel.add(mGridLabel, gridBagConstraints);

        mGridLinesColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mWindowPanel.add(mGridLinesColorButton, gridBagConstraints);

        mBackgroundColorLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundColorLabel1.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mWindowPanel.add(mBackgroundColorLabel1, gridBagConstraints);

        mGridLinesColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridLinesColorLabel.setText("Grid");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mWindowPanel.add(mGridLinesColorLabel, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        mBackgroundColorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mBackgroundColorButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mWindowPanel.add(mBackgroundColorButton, gridBagConstraints);

        mSizeSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 35, 0, 0);
        mWindowPanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        mWindowPanel.add(mGridSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 42, 0, 0);
        mWindowPanel.add(mColorSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mWindowPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mWindowPanel.add(mRightSpaceLabel, gridBagConstraints);

        mGridVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mWindowPanel.add(mGridVisibleCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mWindowPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mBackgroundColorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mBackgroundColorButtonActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mBackgroundColorButtonActionPerformed

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel1;
    private javax.swing.JLabel mBottomLabel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JLabel mGridLabel;
    private javax.swing.JButton mGridLinesColorButton;
    private javax.swing.JLabel mGridLinesColorLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mGridLinesIntervalSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mGridLinesWidthSpinner;
    private javax.swing.JSeparator mGridSeparator;
    private javax.swing.JCheckBox mGridVisibleCheckBox;
    private javax.swing.JLabel mHeightLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mHeightSpinner;
    private javax.swing.JLabel mIntervalLabel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JLabel mWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mWidthSpinner;
    private javax.swing.JPanel mWindowPanel;
    // ϐ錾̏I//GEN-END:variables




    /**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGWindowDialog.TITLE );


		//
		// spinner
		//

		this.mWidthSpinner.setDigitForRoundingOut(-2);
		this.mWidthSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.PAPER_WIDTH_MIN_VALUE,
				SGDrawingWindow.PAPER_WIDTH_MIN_VALUE,
				SGDrawingWindow.PAPER_WIDTH_MAX_VALUE,
				SGDrawingWindow.PAPER_STEP_SIZE ),
			SGSpinner.SPINNER_UNIT_CM
		);
		this.mWidthSpinner.setMinimumFractionDigits(1);
		this.mWidthSpinner.setMaximumFractionDigits(1);

		this.mHeightSpinner.setDigitForRoundingOut(-2);
		this.mHeightSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.PAPER_HEIGHT_MIN_VALUE,
				SGDrawingWindow.PAPER_HEIGHT_MIN_VALUE,
				SGDrawingWindow.PAPER_HEIGHT_MAX_VALUE,
				SGDrawingWindow.PAPER_STEP_SIZE ),
				SGSpinner.SPINNER_UNIT_CM
		);
		this.mHeightSpinner.setMinimumFractionDigits(1);
		this.mHeightSpinner.setMaximumFractionDigits(1);

		this.mGridLinesIntervalSpinner.initProperties(
			new SpinnerNumberModel(
				SGDrawingWindow.GRID_INTERVAL_MIN_VALUE,
				SGDrawingWindow.GRID_INTERVAL_MIN_VALUE,
				SGDrawingWindow.GRID_INTERVAL_MAX_VALUE,
				SGDrawingWindow.GRID_INTERVAL_STEP_SIZE ),
			SGSpinner.SPINNER_UNIT_CM
		);
		this.mGridLinesWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT	);


		//
		// add action listeners
		//

{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}

		this.mGridVisibleCheckBox.addActionListener(this);
		this.mBackgroundColorButton.addActionListener(this);
		this.mGridLinesColorButton.addActionListener(this);


		// add as an action listener to spinners
		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( this );
		}


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mBackgroundColorButton;


		return true;
	}



	/**
	 * 
	 */
	public Number getWindowWidth()
	{
		return this.mWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getWindowHeight()
	{
		return this.mHeightSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getWindowBackgroundColor()
	{
		return this.mBackgroundColorButton.getBackground();
	}

	/**
	 * 
	 */    
	public Color getWindowGridLinesColor()
	{
		return this.mGridLinesColorButton.getBackground();
	}

	/**
	 * 
	 * @return
	 */
	public boolean getWindowGridVisible()
	{
		return this.mGridVisibleCheckBox.isSelected();
	}

	/**
	 * 
	 */
	public Number getWindowGridLinesInterval()
	{
		return this.mGridLinesIntervalSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getWindowGridLinesWidth()
	{
		return this.mGridLinesWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public boolean setWindowWidth( final float w )
	{
		this.mWidthSpinner.setValue( new Double( w ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setWindowHeight( final float h )
	{
		this.mHeightSpinner.setValue( new Double( h ) );
		return true;
	}

	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setWindowGridVisible( final boolean b )
	{
		this.mGridVisibleCheckBox.setSelected(b);
		this.setGridComponentEnabled(b);
		return true;
	}

	/**
	 * 
	 */
	public boolean setWindowGridLinesInterval( final float interval )
	{
		this.mGridLinesIntervalSpinner.setValue( new Double( interval ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setWindowGridLinesWidth( final float width )
	{
		this.mGridLinesWidthSpinner.setValue( new Double( width ) );
		return true;
	}

	/**
	 * 
	 */
	public boolean setWindowBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setBackground( cl );
		return true;
	}

	/**
	 * 
	 */
	public boolean setWindowGridLinesColor( final Color cl )
	{
		this.mGridLinesColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mBackgroundColorButton);
		list.add(this.mGridLinesColorButton);
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mWidthSpinner );
		list.add( this.mHeightSpinner );
		list.add( this.mGridLinesIntervalSpinner );
		list.add( this.mGridLinesWidthSpinner );

		return list;
	}



	/**
	 * 
	 */
	public SGDrawingWindow.WindowProperties getProperties()
	{

		SGDrawingWindow.WindowProperties p
			= new SGDrawingWindow.WindowProperties();


		// paper width
		final Number width = this.getWindowWidth();
		if( width==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setPaperWidth( width.floatValue()/SGIConstants.CM_POINT_RATIO );
		}


		// paper height
		final Number height = this.getWindowHeight();
		if( height==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setPaperHeight( height.floatValue()/SGIConstants.CM_POINT_RATIO );
		}


		// grid visible
		final boolean visible = this.getWindowGridVisible();
		p.setGridVisible( visible );


		// grind line interval
		final Number gridLineInterval = this.getWindowGridLinesInterval();
		if( gridLineInterval==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setGridInterval( gridLineInterval.floatValue()/SGIConstants.CM_POINT_RATIO );
		}


		// grid line width
		final Number gridLineWidth = this.getWindowGridLinesWidth();
		if( gridLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setGridLineWidth( gridLineWidth.floatValue() );
		}


		// grid line color
		Color gridLineColor = this.getWindowGridLinesColor();
		p.setGridColor( gridLineColor );


		//
		Color bgColor = this.getWindowBackgroundColor();
		p.setBackGroundColor( bgColor );


		return p;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();

		if( source.equals( this.mGridVisibleCheckBox ) )
		{
			final boolean b = this.getWindowGridVisible();
			this.setGridComponentEnabled(b);
		}
		
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setGridComponentEnabled( final boolean b )
	{
		this.mIntervalLabel.setEnabled(b);
		this.mGridLinesIntervalSpinner.setEnabled(b);
		this.mBottomLabel.setEnabled(b);
		this.mGridLinesWidthSpinner.setEnabled(b);
		this.mGridLinesColorLabel.setEnabled(b);
		this.mGridLinesColorButton.setEnabled(b);

		if( this.mGridLinesColorButton.equals( this.mFocusedColorSetButton ) )
		{
			this.mFocusedColorSetButton = this.mBackgroundColorButton;
			this.setColorButtonBorder( true );
		}

		return true;
	}

}
