/*
 * SGStringElementDialog.java
 *
 * Created on 2004/06/09, 15:05
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/**
 *
 * @author  kuromaru
 */
public class SGStringElementDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "String Element Dialog";


    /** Creates new form SGStringElementDialog */
    public SGStringElementDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTextPanel = new javax.swing.JPanel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mTextAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTextColorLabel = new javax.swing.JLabel();
        mTextAngleLabel = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorButton = new javax.swing.JButton();
        mFontNameComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new javax.swing.JTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new javax.swing.JTextField();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mFontStyleLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mTextPanel.setLayout(new java.awt.GridBagLayout());

        mTextPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mFontStyleComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mTextPanel.add(mFontSizeLabel, gridBagConstraints);

        mTextAngleSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mTextAngleSpinner, gridBagConstraints);

        mTextColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextColorLabel, gridBagConstraints);

        mTextAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextAngleLabel, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mFontSizeSpinner, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mColorButton, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mFontNameComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        mTextPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTextPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 0, 0);
        mTextPanel.add(mStringSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTextPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTextPanel.add(mYValueTextField, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 0, 0);
        mTextPanel.add(mLocationSeparator, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mTextPanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTextPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mFontStyleComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mFontStyleComboBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mFontStyleComboBoxActionPerformed

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mColorButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JLabel mTextAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mTextAngleSpinner;
    private javax.swing.JLabel mTextColorLabel;
    private javax.swing.JPanel mTextPanel;
    private javax.swing.JLabel mXValueLabel;
    private javax.swing.JTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private javax.swing.JTextField mYValueTextField;
    // ϐ錾̏I//GEN-END:variables

    
    
	/**
	 * 
	 */
	private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGStringElementDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontNameComboBox.addItem( fontArray[ii] );
			}

			final String[] styleNameArray = {
				SGIConstants.FONT_PLAIN,
				SGIConstants.FONT_ITALIC,
				SGIConstants.FONT_BOLD,
				SGIConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}

		}

		this.pack();


		
		//
		// create a radio-button-group
		//
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mLeftBottomRadioButton );
			group.add( this.mLeftTopRadioButton );
			group.add( this.mRightBottomRadioButton );
			group.add( this.mRightTopRadioButton );
			group.add( this.mNoAxisSelectionRadioButton );
		}

		
		
		//
		// spinner model
		//

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// angle
		this.mTextAngleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -180.0, 180.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_DEGREE );


		// add action listeners
//		this.mXValueTextField.addActionListener(this);
//		this.mYValueTextField.addActionListener(this);
		
		
		// FύX{^ɃANVXiǉ
		this.mColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;


		return true;
	}


	
	
	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}



	
	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}

	
	
   	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public ArrayList getTextColorList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mColorButton.getBackground() );
		return list;
	}


	/**
	 * 
	 */
	public Number getAngle()
	{
		return this.mTextAngleSpinner.getNumber();
	}


	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setFontSize( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mFontSizeSpinner.setValue( num );
		return true;
	}


	
	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTextColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setAngle( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mTextAngleSpinner.setValue( num );
		return true;
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Double d = SGUtilityText.getDouble(str);
		if( d==null )
		{
			return false;
		}
		this.mXValueTextField.setText( str );
		return true;
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getDouble(str);
		if( num==null )
		{
			return false;
		}
		this.mYValueTextField.setText( str );
		return true;
	}

	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}

	

	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mTextAngleSpinner );
		return list;
	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{

		Object source = e.getSource();
		
if( this.getColorSelectionComponentList().contains(source) )
{
	JButton btn = (JButton)source;

	// ɐݒ
	this.mFocusedColorSetButton = btn;

	// {^ɑ{
	this.setColorButtonBorder( true );

	// FI_CAOo
	this.mColorDialog.setVisible(true);
}
		
	}
	
	
	
	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		// OK,Cancel,Preview
		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		this.mXValueTextField.addActionListener( listener );
		this.mYValueTextField.addActionListener( listener );
		
		return true;
	}

	
	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}

			this.mXValueTextField.removeActionListener( array[ii] );
			this.mYValueTextField.removeActionListener( array[ii] );
		}

		return true;
	}



	/**
	 * 
	 */
	public SGStringElement.LabelProperties getProperties()
	{

		SGStringElement.LabelProperties p
			= new SGStringElement.LabelProperties();

		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setFontSize( fontSize.floatValue() );
		}

		p.setFontName( this.getFontName() );
		p.setFontStyle( this.getFontStyle() );

		Number angle = this.getAngle();
		if( angle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setAngle( angle.floatValue()*RADIAN_DEGREE_RATIO );
		}

		p.setColorList( this.getTextColorList() );

		return p;

	}




}
