
package jp.riken.brain.ni.samuraigraph.base;

/**
 * The base class of all data classes.
 */

public abstract class SGData implements SGICopiable
{

	/**
	 * The name of this data.
	 */
	protected String mName;


	/**
	 * Default constructor.
	 *
	 */
	public SGData()
	{
		super();
	}


	/**
	 * Initializes a newly created SGData object with a given name.
	 * @param name - a string set to the name of this data
	 */
	public SGData( final String name )
	{
		super();
	}


	/**
	 * Set values in given data.
	 * @param data
	 * @return
	 */
	public abstract boolean setData( final SGData data );


	/**
	 * Returns the number of data points.
	 * @return
	 */
	public abstract int getPointsNumber();


	/**
	 * 
	 * @param array
	 * @return
	 */
	protected String toDoubleArrayString( double[] array )
	{
		if( array==null )
		{
			return "null";
		}

		String str = "{";
		for( int ii=0; ii<array.length; ii++ )
		{
			str += Double.toString( array[ii] );
			if( ii==array.length-1 )
			{
				break;
			}
			str += ",";
		}
		str += "}";
		return str;
	}


}
