/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFImageDelayQueue {
    private int currentNumber = 0;
    private List imageList;
    private PDFWriter pdf;

    public PDFImageDelayQueue(PDFWriter pdf) {
        this.pdf = pdf;
        this.imageList = new LinkedList();
    }

    public PDFName delayImage(RenderedImage image, Color bkg, String writeAs) {
        Entry e = new Entry(image, bkg, writeAs);
        this.imageList.add(e);
        return this.pdf.name(e.name);
    }

    public void processAll() throws IOException {
        ListIterator i = this.imageList.listIterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (e.written) continue;
            e.written = true;
            String[] encode = e.writeAs.equals("ZLIB") || e.maskName != null ? new String[]{"Flate", "ASCII85"} : (e.writeAs.equals("JPG") ? new String[]{"DCT", "ASCII85"} : new String[]{null, "ASCII85"});
            PDFStream img = this.pdf.openStream(e.name);
            img.entry("Subtype", this.pdf.name("Image"));
            if (e.maskName != null) {
                img.entry("SMask", this.pdf.ref(e.maskName));
            }
            img.image(e.image, e.bkg, encode);
            this.pdf.close(img);
            if (e.maskName == null) continue;
            PDFStream mask = this.pdf.openStream(e.maskName);
            mask.entry("Subtype", this.pdf.name("Image"));
            mask.imageMask(e.image, encode);
            this.pdf.close(mask);
        }
    }

    public int addXObjects() throws IOException {
        if (this.imageList.size() > 0) {
            PDFDictionary xobj = this.pdf.openDictionary("XObjects");
            ListIterator i = this.imageList.listIterator();
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                xobj.entry(e.name, this.pdf.ref(e.name));
                if (e.maskName == null) continue;
                xobj.entry(e.maskName, this.pdf.ref(e.maskName));
            }
            this.pdf.close(xobj);
        }
        return this.imageList.size();
    }

    private class Entry {
        private RenderedImage image;
        private String name;
        private String maskName;
        private Color bkg;
        private String writeAs;
        private boolean written;

        private Entry(RenderedImage image, Color bkg, String writeAs) {
            this.image = image;
            this.bkg = bkg;
            this.writeAs = writeAs;
            this.name = "Img" + PDFImageDelayQueue.this.currentNumber++;
            this.maskName = image.getColorModel().hasAlpha() && bkg == null ? this.name + "Mask" : null;
            this.written = false;
        }
    }
}

