/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupBar
extends SGElementGroupRectangle
implements SGIBarConstants,
SGIElementGroupConstants {
    protected double mBaselineValue;

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            float f = this.mMagnification * this.mEdgeLineWidth;
            ArrayList arrayList = this.mColorList;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                Object object;
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                if (!sGDrawingElementBar2D.isVisible()) continue;
                float f2 = sGDrawingElementBar2D.getX();
                float f3 = sGDrawingElementBar2D.getY();
                float f4 = sGDrawingElementBar2D.getRectangleWidth();
                float f5 = sGDrawingElementBar2D.getRectangleHeight();
                Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
                BasicStroke basicStroke = new BasicStroke(f, 0, 0);
                int n = arrayList.size();
                if (n > 1) {
                    int n2;
                    float f6 = f2 + 0.5f * f4;
                    float f7 = f5 / (float)n;
                    object = new Rectangle2D[n + 1];
                    object[0] = new Rectangle2D.Float(f2, f3, f4, 0.5f * f7);
                    object[((Object)object).length - 1] = new Rectangle2D.Float(f2, f3 + f5 - 0.5f * f7, f4, 0.5f * f7);
                    for (int j = 1; j < ((Object)object).length - 1; ++j) {
                        float f8 = f3 + 0.5f * f7 + (float)(j - 1) * f7;
                        object[j] = new Rectangle2D.Float(f2, f8, f4, f7);
                    }
                    float[] fArray = new float[n - 1];
                    for (n2 = 0; n2 < fArray.length; ++n2) {
                        fArray[n2] = f3 + (float)(n2 + 1) * f7;
                    }
                    graphics2D.setPaint((Color)arrayList.get(0));
                    graphics2D.fill((Shape)object[0]);
                    for (n2 = 0; n2 < fArray.length; ++n2) {
                        Color color = (Color)this.mColorList.get(n2);
                        Color color2 = (Color)this.mColorList.get(n2 + 1);
                        float f9 = fArray[n2] - 5.0f;
                        float f10 = fArray[n2] + 5.0f;
                        GradientPaint gradientPaint = new GradientPaint(f6, f9, color, f6, f10, color2);
                        graphics2D.setPaint(gradientPaint);
                        graphics2D.fill((Shape)object[n2 + 1]);
                    }
                    graphics2D.setPaint((Color)this.getColorList().get(n - 1));
                    graphics2D.fill((Shape)object[((Object)object).length - 1]);
                    continue;
                }
                if (rectangle2D == null) {
                    graphics2D.setPaint(this.getColor(0));
                    graphics2D.fill(float_);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setPaint(this.mEdgeLineColor);
                    graphics2D.draw(float_);
                    continue;
                }
                Area area = new Area(rectangle2D);
                Shape shape = basicStroke.createStrokedShape(float_);
                Area area2 = new Area(shape);
                object = new Area(float_);
                area2.intersect(area);
                ((Area)object).intersect(area);
                graphics2D.setPaint(this.getColor(0));
                graphics2D.fill((Shape)object);
                graphics2D.setStroke(basicStroke);
                graphics2D.setPaint(this.mEdgeLineColor);
                graphics2D.fill(area2);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementBar2D sGDrawingElementBar2D = new SGDrawingElementBar2D();
        sGDrawingElementBar2D.setVisible(this.mVisibleFlag);
        sGDrawingElementBar2D.setWidth(this.mRectangleWidth);
        sGDrawingElementBar2D.setHeight(this.mRectangleHeight);
        sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
        sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        sGDrawingElementBar2D.setColor(this.mColorList);
        sGDrawingElementBar2D.setBaselineValue(this.mBaselineValue);
        return sGDrawingElementBar2D;
    }

    public String getTagName() {
        return "Bar";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("Width", Float.toString(this.mRectangleWidth * 0.035277776f) + "cm");
        element.setAttribute("EdgeLineWidth", Float.toString(this.mEdgeLineWidth) + "pt");
        element.setAttribute("BaselineValue", Double.toString(this.mBaselineValue));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        return true;
    }

    public SGProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        BarProperties barProperties = new BarProperties();
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        barProperties.setVisible(bl);
        string = element.getAttribute("Width");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "cm");
        if (number == null) {
            return null;
        }
        barProperties.setBarWidth(number.floatValue() / 0.035277776f);
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return null;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return null;
        }
        barProperties.setColorList(arrayList);
        string = element.getAttribute("EdgeLineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        barProperties.setEdgeLineWidth(number.floatValue());
        string = element.getAttribute("BaselineValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        barProperties.setBaselineValue(number.doubleValue());
        string = element.getAttribute("EdgeLineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        barProperties.setEdgeLineColor(color);
        return barProperties;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementBar2D[] sGDrawingElementBar2DArray = new SGDrawingElementBar2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementBar2DArray[i] = new SGDrawingElementBar2D();
        }
        this.mDrawingElementArray = sGDrawingElementBar2DArray;
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        SGDrawingElementBar2D[] sGDrawingElementBar2DArray = new SGDrawingElementBar2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementBar2DArray[i] = new SGDrawingElementBar2D();
            sGDrawingElementBar2DArray[i].setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
        }
        this.mDrawingElementArray = sGDrawingElementBar2DArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementBar2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementBar2D.setBounds(sGTuple2fArray[i].x, sGTuple2fArray[i].y, this.mRectangleWidth, this.mRectangleHeight);
            sGDrawingElementBar2D.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
            sGDrawingElementBar2D.setMagnification(this.mMagnification);
            sGDrawingElementBar2D.setColor(this.mColorList);
            sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
            sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        }
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        Float f = barProperties.getBarWidth();
        if (f == null) {
            return false;
        }
        this.setRectangleWidth(f.floatValue());
        Float f2 = barProperties.getEdgeLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setEdgeLineWidth(f2.floatValue());
        Color color = barProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Double d = barProperties.getBaselineValue();
        if (d == null) {
            return false;
        }
        this.setBaselineValue(d);
        return true;
    }

    public static class BarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementBar.BarProperties mBarProperties = new SGDrawingElementBar.BarProperties();

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            return this.mBarProperties.equals(barProperties.mBarProperties);
        }

        public Float getBarWidth() {
            return this.mBarProperties.getBarWidth();
        }

        public Float getEdgeLineWidth() {
            return this.mBarProperties.getEdgeLineWidth();
        }

        public Color getEdgeLineColor() {
            return this.mBarProperties.getEdgeLineColor();
        }

        public Double getBaselineValue() {
            return this.mBarProperties.getBaselineValue();
        }

        public void setBarWidth(float f) {
            this.mBarProperties.setBarWidth(f);
        }

        public void setBaselineValue(double d) {
            this.mBarProperties.setBaselineValue(d);
        }

        public void setEdgeLineWidth(float f) {
            this.mBarProperties.setEdgeLineWidth(f);
        }

        public void setEdgeLineColor(Color color) {
            this.mBarProperties.setEdgeLineColor(color);
        }
    }
}

