/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.InflaterInputStream;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefineBitsJPEG2;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsJPEG3
extends DefineBitsJPEG2 {
    private byte[] imageBytes;
    private int imageLength;

    public DefineBitsJPEG3(int id, Image image, Properties options, Color bkg, ImageObserver observer) {
        this(id, ImageUtilities.createRenderedImage((Image)image, (ImageObserver)observer, (Color)bkg), bkg, options);
    }

    public DefineBitsJPEG3(int id, RenderedImage image, Color bkg, Properties options) {
        this();
        this.character = id;
        this.image = image;
        this.options = options;
    }

    public DefineBitsJPEG3() {
        super(35, 3);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineBitsJPEG3 tag = new DefineBitsJPEG3();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        int jpegLen = (int)swf.readUnsignedInt();
        byte[] data = swf.readByte(jpegLen);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage bi = ImageGraphics2D.readImage((String)"jpg", (InputStream)bais);
        if (bais.available() > 0) {
            System.err.println("DefineBitsJPEG3: not all bytes read: " + bais.available());
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        InflaterInputStream zip = new InflaterInputStream((InputStream)((Object)swf));
        byte[] alpha = new byte[width * height];
        zip.read(alpha);
        WritableRaster raster = bi.getAlphaRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster.setPixel(x, y, new int[]{alpha[y * width + x]});
            }
        }
        tag.image = bi;
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedInt(this.imageLength);
        swf.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 2;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageGraphics2D.writeImage((RenderedImage)this.image, (String)"jpg", (Properties)this.options, (OutputStream)baos);
            this.imageLength = baos.size();
            FlateOutputStream flate = new FlateOutputStream((OutputStream)baos);
            UserProperties props = new UserProperties();
            props.setProperty(RawImageWriteParam.BACKGROUND, Color.BLACK);
            props.setProperty(RawImageWriteParam.CODE, "A");
            props.setProperty(RawImageWriteParam.PAD, 1);
            ImageGraphics2D.writeImage((RenderedImage)this.image, (String)"raw", (Properties)props, (OutputStream)flate);
            flate.finish();
            baos.close();
            this.imageBytes = baos.toByteArray();
        }
        return this.imageBytes;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:   " + this.character + "\n");
        s.append("  image:      " + this.image + "\n");
        return s.toString();
    }
}

