
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;


/**
 *
 */
public abstract class SGDrawingElementBar extends SGDrawingElementRectangle
	implements SGIBarConstants, SGIDrawingElementConstants
{

	/**
	 * 
	 */
	protected double mBaselineValue;


	/**
	 * 
	 */
	public SGDrawingElementBar()
	{
		super();
	}


	/**
	 * 
	 */
	public double getBaselineValue()
	{
		return this.mBaselineValue;
	}


	/**
	 * 
	 */
	public boolean setBaselineValue( final double value )
	{
		this.mBaselineValue = value;
		return true;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementBar) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementBar bar = (SGDrawingElementBar)element;
		this.setBaselineValue( bar.getBaselineValue() );

		return true;
	}




	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		BarProperties p = new BarProperties();
		this.getProperties(p);
		return p;
	}




	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof BarProperties ) == false ) return false;

		super.getProperties(p);

		BarProperties bp = (BarProperties)p;
		bp.setBarWidth( this.getRectangleWidth() );
		bp.setEdgeLineWidth( this.getEdgeLineWidth() );
		bp.setEdgeLineColor( this.getEdgeLineColor() );
		bp.setBaselineValue( this.getBaselineValue() );

		return true;
	}



	/**
	 * 
	 */
	public static class BarProperties extends DrawingElementProperties
	{

//		public static final String[] keys = {
//			KEY_BAR_WIDTH, KEY_EDGE_LINE_WIDTH, KEY_EDGE_LINE_COLOR, KEY_BASELINE_VALUE
//		};

		private float mWidth = 0.0f;
		private float mEdgeLineWidth = 0.0f;
		private Color mEdgeLineColor = null;
		private double mBaselineValue = 0.0;


		/**
		 * 
		 */
		public BarProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof BarProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			BarProperties p = (BarProperties)obj;
			if( this.mWidth!=p.mWidth ) return false;
			if( this.mEdgeLineWidth!=p.mEdgeLineWidth ) return false;
			if( this.mEdgeLineColor.equals(p.mEdgeLineColor) == false ) return false;
			if( this.mBaselineValue!=p.mBaselineValue ) return false;

//			for( int ii=0; ii<keys.length; ii++ )
//			{
//				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
//				{
//					return false;
//				}
//			}

			return true;
		}



		public Float getBarWidth()
		{
//			final String value = this.getProperty(KEY_BAR_WIDTH);
//			return SGUtilityText.getFloat(value);
			return new Float( this.mWidth );
		}

		public Float getEdgeLineWidth()
		{
//			final String value = this.getProperty(KEY_EDGE_LINE_WIDTH);
//			return SGUtilityText.getFloat(value);
			return new Float( this.mEdgeLineWidth );
		}

		public Color getEdgeLineColor()
		{
//			final String value = this.getProperty(KEY_EDGE_LINE_COLOR);
//			return SGUtilityText.getColorFromString(value);
			return this.mEdgeLineColor;
		}

		public Double getBaselineValue()
		{
//			final String value = this.getProperty(KEY_BASELINE_VALUE);
//			return SGUtilityText.getDouble(value);
			return new Double( this.mBaselineValue );
		}


		public boolean setBarWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.mWidth = width;
//			this.setProperty( KEY_BAR_WIDTH, new Float(width).toString() );
			return true;
		}


		public boolean setBaselineValue( final double value )
		{
			this.mBaselineValue = value;
//			this.setProperty( KEY_BASELINE_VALUE, new Double(value).toString() );
			return true;
		}


		public boolean setEdgeLineWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.mEdgeLineWidth = width;
//			this.setProperty( KEY_EDGE_LINE_WIDTH, new Float(width).toString() );
			return true;
		}

		public boolean setEdgeLineColor( final Color cl )
		{
			if( cl==null )
			{
				return false;
			}
			this.mEdgeLineColor = cl;
//			String str = SGUtilityText.getColorString(cl);
//			if( str==null )
//			{
//				return false;
//			}
//			this.setProperty( KEY_EDGE_LINE_COLOR, str );
			return true;
		}



	}



}
