

package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;


/**
 * 
 */
public abstract class SGDrawingElementRectangle extends SGDrawingElement
{

	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();


	/**
	 * 
	 */
	protected float mRectangleWidth;

	/**
	 * 
	 */
	protected float mRectangleHeight;


	/**
	 * 
	 */
	protected float mEdgeLineWidth;

	/**
	 * 
	 */
	protected Color mEdgeLineColor;



	/**
	 * 
	 */
	public SGDrawingElementRectangle()
	{
		super();
	}



	/**
	 * 
	 */
	public float getX()
	{
		return this.mLocation.x;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mLocation.y;
	}


	/**
	 * 
	 */
	public float getRectangleWidth()
	{
		return this.mRectangleWidth;
	}


	/**
	 * 
	 */
	public float getRectangleHeight()
	{
		return this.mRectangleHeight;
	}


	/**
	 * 
	 */
	public float getEdgeLineWidth()
	{
		return this.mEdgeLineWidth;
	}


	/**
	 * 
	 */
	public Color getEdgeLineColor()
	{
		return this.mEdgeLineColor;
	}


	/**
	 * 
	 */
	public boolean setEdgeLineWidth( final float width )
	{
		this.mEdgeLineWidth = width;
		return true;
	}

	/**
	 * 
	 */
	public boolean setEdgeLineColor( final Color color )
	{
		this.mEdgeLineColor = color;
		return true;
	}


	/**
	 * 
	 */
	public boolean setX( final float x )
	{
		this.mLocation.x = x;
		return true;
	}


	/**
	 * 
	 */
	public boolean setY( final float y )
	{
		this.mLocation.y = y;
		return true;
	}


	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}


	/**
	 * 
	 * @param point
	 * @return
	 */
	public boolean setLocation( final SGTuple2f point )
	{
		this.mLocation = point;
		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		this.mRectangleWidth = w;
		return true;
	}

	/**
	 * 
	 */
	public boolean setHeight( final float h )
	{
		this.mRectangleHeight = h;
		return true;
	}


	/**
	 * 
	 * @param w
	 * @param h
	 * @return
	 */
	public boolean setSize( final float w, final float h )
	{
		this.setWidth(w);
		this.setHeight(h);
		return true;
	}


	/**
	 * 
	 */
	public boolean setBounds(
		final float x,
		final float y,
		final float w,
		final float h )
	{
		this.setLocation(x,y);
		this.setSize(w,h);		
		return true;		
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementRectangle) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementRectangle rect = (SGDrawingElementRectangle)element;
		this.setWidth( rect.getRectangleWidth() );
		this.setHeight( rect.getRectangleHeight() );
		this.setEdgeLineWidth( rect.getEdgeLineWidth() );
		this.setEdgeLineColor( rect.getEdgeLineColor() );

		return true;
	}


}
