
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 *
 *
 */
interface SGILegendDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{


	/**
	 * 
	 * @return
	 */
	public double getXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getYValue();



	/**
	 * 
	 * @return
	 */
	public String getFontName();



	/**
	 *
	 */
	public float getFontSize();



	/**
	 *
	 */
	public int getFontStyle();



	/**
	 * 
	 * @return
	 */
	public Color getStringColor();


	/**
	 * 
	 * @return
	 */
	public boolean isFrameLineVisible();


	/**
	 * 
	 * @return
	 */
	public float getFrameLineWidth();


	/**
	 * 
	 * @return
	 */
	public Color getFrameLineColor();


	/**
	 * 
	 * @return
	 */
	public boolean isLegendVisible();


	/**
	 * 
	 * @return
	 */
	public boolean isBackgroundTransparent();


	/**
	 * 
	 * @return
	 */
	public Color getBackgroundColor();



	/**
	 * 
	 * @param value
	 */
	public void setXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setYValue( final double value );


	/**
	 * 
	 * @param b
	 */
	public boolean setLegendVisible( final boolean b );


	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean setFontName( final String name );


	/**
	 * 
	 * @param style
	 * @return
	 */
	public boolean setFontStyle( final int style );


	/**
	 * 
	 * @param size
	 * @return
	 */
	public boolean setFontSize( final float size );


	/**
	 * 
	 * @param cl
	 */
	public void setStringColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public boolean setFrameVisible( final boolean b );


	/**
	 * 
	 * @param width
	 */
	public void setFrameLineWidth( final float width );


	/**
	 * 
	 * @param cl
	 */
	public void setFrameLineColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public void setBackgroundTransparent( final boolean b );


	/**
	 * 
	 * @param cl
	 */
	public void setBackgroundColor( Color cl );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidXAxisValue( final int config, final Number value );

	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidYAxisValue( final int config, final Number value );


}

