/*
 * SGLegendDialog.java
 *
 * Created on 2004/06/09, 14:49
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JRadioButton;

import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesRadioButtonManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;


/**
 *
 * @author  kuromaru
 */
public class SGLegendDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Legend Properties";


    /** Creates new form SGLegendDialog */
    public SGLegendDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mLabelSpace1 = new javax.swing.JLabel();
        mLegendPanel = new javax.swing.JPanel();
        mLegendVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFrameVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFrameLabel = new javax.swing.JLabel();
        mFrameLineWidthLabel = new javax.swing.JLabel();
        mFrameLineColorLabel = new javax.swing.JLabel();
        mBackgroundColorLabel = new javax.swing.JLabel();
        mFrameLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFrameLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFrameSeparator = new javax.swing.JSeparator();
        mBackgroundColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontSizeLabel = new javax.swing.JLabel();
        mStringColorLabel = new javax.swing.JLabel();
        mFontNameComboBox = new javax.swing.JComboBox();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mStringColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBackgroundLabel = new javax.swing.JLabel();
        mBackgroundTransparentCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mLocationLabel = new javax.swing.JLabel();
        mBackgroundSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mFontStyleLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mlButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();

        mLabelSpace1.setText("  ");

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mLegendPanel.setLayout(new java.awt.GridBagLayout());

        mLegendPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mLegendPanel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 70, 5, 5);
        mLegendPanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mFrameVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        mLegendPanel.add(mFrameVisibleCheckBox, gridBagConstraints);

        mFrameLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFrameLabel.setText("Frame");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFrameLabel, gridBagConstraints);

        mFrameLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mLegendPanel.add(mFrameLineWidthLabel, gridBagConstraints);

        mFrameLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mFrameLineColorLabel, gridBagConstraints);

        mBackgroundColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mBackgroundColorLabel, gridBagConstraints);

        mFrameLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineWidthSpinner, gridBagConstraints);

        mFrameLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineColorButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mLegendPanel.add(mFrameSeparator, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mBackgroundColorButton, gridBagConstraints);

        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontSizeLabel, gridBagConstraints);

        mStringColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStringColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mLegendPanel.add(mStringColorLabel, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontNameComboBox, gridBagConstraints);

        mFontSizeSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeSpinner.setMinimumSize(new java.awt.Dimension(25, 20));
        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontStyleComboBox, gridBagConstraints);

        mStringColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringColorButton, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 5, 5);
        mLegendPanel.add(mStringSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mRightSpaceLabel, gridBagConstraints);

        mBackgroundLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBackgroundLabel.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mBackgroundLabel, gridBagConstraints);

        mBackgroundTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mLegendPanel.add(mBackgroundTransparentCheckBox, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mLegendPanel.add(mBackgroundSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mYValueTextField, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        mLegendPanel.add(mLocationSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mLegendPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mlButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mlButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mlButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mlButtonPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel;
    private javax.swing.JLabel mBackgroundLabel;
    private javax.swing.JSeparator mBackgroundSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mBackgroundTransparentCheckBox;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JLabel mFrameLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mFrameLineColorButton;
    private javax.swing.JLabel mFrameLineColorLabel;
    private javax.swing.JLabel mFrameLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFrameLineWidthSpinner;
    private javax.swing.JSeparator mFrameSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mFrameVisibleCheckBox;
    private javax.swing.JLabel mLabelSpace1;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JPanel mLegendPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mLegendVisibleCheckBox;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mStringColorButton;
    private javax.swing.JLabel mStringColorLabel;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JLabel mXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mYValueTextField;
    private javax.swing.JPanel mlButtonPanel;
    // ϐ錾̏I//GEN-END:variables
    

    /**
     * 
     */
//    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

	private SGTwoAxesRadioButtonManager mAxesButtonGroup = null;
    
    
	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGLegendDialog.TITLE );


		// font name
		String fontArray[] = SGUtility.getAvailableFontNames();
		for(int ii=0 ; ii<fontArray.length ; ii++)
		{
			this.mFontNameComboBox.addItem( fontArray[ii] );
		}


		// font style
		String[] styleNameArray = {
			SGIConstants.FONT_PLAIN,
			SGIConstants.FONT_ITALIC,
			SGIConstants.FONT_BOLD,
			SGIConstants.FONT_BOLD_ITALIC
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mFontStyleComboBox.addItem( styleNameArray[ii] );
		}


		this.pack();


		//
		// create a radio-button-group
		//

		this.mAxesButtonGroup = new SGTwoAxesRadioButtonManager(
			this.mLeftBottomRadioButton, this.mLeftTopRadioButton,
			this.mRightBottomRadioButton, this.mRightTopRadioButton,
			new JRadioButton() );


		//
		// Xsi[f̐ݒ
		//

		// axis line width
		this.mFrameLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		//
		// add an action-listener
		//

		this.mLegendVisibleCheckBox.addActionListener(this);
		this.mFrameVisibleCheckBox.addActionListener(this);
		this.mBackgroundTransparentCheckBox.addActionListener(this);

		{
			this.mOKButton.addActionListener(this);
			this.mCancelButton.addActionListener(this);
			this.mPreviewButton.addActionListener(this);
		}


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mFrameLineColorButton;



		SGComponentGroupElement[] frameComponents = {
			new SGComponentGroupElement( this.mFrameLineWidthLabel ),
			new SGComponentGroupElement( this.mFrameLineWidthSpinner ),
			new SGComponentGroupElement( this.mFrameLineColorLabel ),
			new SGComponentGroupElement( this.mFrameLineColorButton )
		};

		SGComponentGroupElement[] backgroundComponents = {
			new SGComponentGroupElement( this.mBackgroundColorLabel ),
			new SGComponentGroupElement( this.mBackgroundColorButton )
		};


		SGComponentGroupElement[] allComponents = {

			// Axes
			new SGComponentGroupElement( this.mScaleReferenceLabel1 ),
			new SGComponentGroupElement( this.mScaleReferenceLabel2 ),
			new SGComponentGroupElement( this.mLeftBottomRadioButton ),
			new SGComponentGroupElement( this.mLeftTopRadioButton ),
			new SGComponentGroupElement( this.mRightBottomRadioButton ),
			new SGComponentGroupElement( this.mRightTopRadioButton ),

			// Location
			new SGComponentGroupElement( this.mLocationLabel ),
			new SGComponentGroupElement( this.mXValueLabel ),
			new SGComponentGroupElement( this.mXValueTextField ),
			new SGComponentGroupElement( this.mYValueLabel ),
			new SGComponentGroupElement( this.mYValueTextField ),
		
			// String
			new SGComponentGroupElement( this.mStringLabel ),

			new SGComponentGroupElement( this.mFontFamilyLabel ),
			new SGComponentGroupElement( this.mFontStyleLabel ),
			new SGComponentGroupElement( this.mFontNameComboBox ),
			new SGComponentGroupElement( this.mFontStyleComboBox ),
			new SGComponentGroupElement( this.mFontSizeLabel ),
			new SGComponentGroupElement( this.mFontSizeSpinner ),
			new SGComponentGroupElement( this.mStringColorLabel ),
			new SGComponentGroupElement( this.mStringColorButton ),

			// Frame
			new SGComponentGroupElement( this.mFrameLabel ),
			new SGComponentGroupElement( this.mFrameVisibleCheckBox ),

			frameComponents[0],
			frameComponents[1],
			frameComponents[2],
			frameComponents[3],

			// Background
			new SGComponentGroupElement( this.mBackgroundLabel ),
			new SGComponentGroupElement( this.mBackgroundTransparentCheckBox ),

			backgroundComponents[0],
			backgroundComponents[1]
		};
		
		
		this.mVisibleComponentGroup.addElement( allComponents );
		this.mFrameVisibleComponentGroup.addElement( frameComponents );
		this.mBackgroundComponentGroup.addElement( backgroundComponents );


		return true;

	}



	/**
	 * 
	 */
	private SGComponentGroup mVisibleComponentGroup = new SGComponentGroup();


	/**
	 * 
	 */
	private SGComponentGroup mFrameVisibleComponentGroup = new SGComponentGroup();


	/**
	 * 
	 */
	private SGComponentGroup mBackgroundComponentGroup = new SGComponentGroup();



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);
		Object source = e.getSource();

		if( source.equals( this.mLegendVisibleCheckBox ) )
		{
//			this.mVisibleComponentGroup.setEnabled( this.mLegendVisibleCheckBox.isSelected() );
			this.setLegendVisible( this.mLegendVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mFrameVisibleCheckBox ) )
		{
//			this.mFrameVisibleComponentGroup.setEnabled( this.mFrameVisibleCheckBox.isSelected() );
			this.setFrameComponentsEnabled( this.mFrameVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mBackgroundTransparentCheckBox ) )
		{
//			this.mBackgroundComponentGroup.setEnabled( !this.mBackgroundTransparentCheckBox.isSelected() );
			this.setBackgroundComponentsEnabled( this.mBackgroundTransparentCheckBox.getSelected() );
		}
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setAllLegendComponentsEnabled( final Boolean flag )
	{
		boolean b = true;
		if( flag!=null )
		{
			b = flag.booleanValue();
		}
		
//		// Axes
//		this.mScaleReferenceLabel1.setEnabled(b);
//		this.mScaleReferenceLabel2.setEnabled(b);
//		this.mLeftBottomRadioButton.setEnabled(b);
//		this.mLeftTopRadioButton.setEnabled(b);
//		this.mRightBottomRadioButton.setEnabled(b);
//		this.mRightTopRadioButton.setEnabled(b);
//
//		// Location
//		this.mLocationLabel.setEnabled(b);
//		this.mXValueLabel.setEnabled(b);
//		this.mXValueTextField.setEnabled(b);
//		this.mYValueLabel.setEnabled(b);
//		this.mYValueTextField.setEnabled(b);
//		
//		// String
//		this.mStringLabel.setEnabled(b);
//		this.setStringComponentsEnabled(b);
//
//		// Frame
//		this.mFrameLabel.setEnabled(b);
//		this.mFrameVisibleCheckBox.setEnabled(b);
//		final Boolean frameVisible = this.mFrameVisibleCheckBox.getSelected();
//		this.setFrameVisible( frameVisible );
//
//
//		// Background
//		this.mBackgroundLabel.setEnabled(b);
//		this.mBackgroundTransparentCheckBox.setEnabled(b);
//		final Boolean transparent = this.mBackgroundTransparentCheckBox.getSelected();
//		this.setBackgroundComponentsEnabled( transparent );

		this.mVisibleComponentGroup.setEnabled(b);

		return true;
	}



//	/**
//	 * 
//	 * @param b
//	 * @return
//	 */
//	private boolean setStringComponentsEnabled( final boolean b )
//	{
//		this.mFontFamilyLabel.setEnabled(b);
//		this.mFontStyleLabel.setEnabled(b);
//		this.mFontNameComboBox.setEnabled(b);
//		this.mFontStyleComboBox.setEnabled(b);
//		this.mFontSizeLabel.setEnabled(b);
//		this.mFontSizeSpinner.setEnabled(b);
//		this.mStringColorLabel.setEnabled(b);
//		this.mStringColorButton.setEnabled(b);
//
//		return true;
//	}




	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setFrameComponentsEnabled( final Boolean frameVisible )
	{
//		boolean b;
//		if( frameVisible==null )
//		{
//			b = false;
//		}
//		else
//		{
//			final boolean fVisible = frameVisible.booleanValue();
//
//			Boolean legendVisible = this.getLegendVisible();
//			boolean lVisible;
//			if( legendVisible==null )
//			{
//				lVisible = false;
//			}
//			else
//			{
//				lVisible = legendVisible.booleanValue();
//			}
//
//			b = fVisible & lVisible;
//		}

		boolean b = true;
		if( frameVisible!=null )
		{
			b = frameVisible.booleanValue();
		}

		this.setFrameComponentsEnabled(b);

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setFrameComponentsEnabled( final boolean b )
	{
		this.mFrameVisibleComponentGroup.setEnabled(b);
//		this.mFrameLineWidthLabel.setEnabled(b);
//		this.mFrameLineWidthSpinner.setEnabled(b);
//		this.mFrameLineColorLabel.setEnabled(b);
//		this.mFrameLineColorButton.setEnabled(b);
		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setBackgroundComponentsEnabled( final Boolean transparent )
	{
//		boolean b;
//		if( transparent==null )
//		{
//			b = true;
//		}
//		else
//		{
//			final boolean transparentFlag = transparent.booleanValue();
//
//			Boolean legendVisible = this.getLegendVisible();
//			boolean lVisible;
//			if( legendVisible==null )
//			{
//				lVisible = false;
//			}
//			else
//			{
//				lVisible = legendVisible.booleanValue();
//			}
//
//			b = !transparentFlag & lVisible;
//		}

		boolean b = true;
		if( transparent!=null )
		{
			b = !transparent.booleanValue();
		}

		this.setBackgroundComponentsEnabled(b);

		return true;
	}


	/**
	 * 
	 */
	private boolean setBackgroundComponentsEnabled( final boolean b )
	{
		this.mBackgroundComponentGroup.setEnabled(b);
//		this.mBackgroundColorLabel.setEnabled(b);
//		this.mBackgroundColorButton.setEnabled(b);

		return true;
	}


	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		this.mXValueTextField.addActionListener(listener);
		this.mYValueTextField.addActionListener(listener);
		
		return true;
	}


	
	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}




	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}


	/**
	 * 
	 */
	public Boolean getLegendVisible()
	{
		return this.mLegendVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Boolean getFrameVisible()
	{
		return this.mFrameVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public Number getFrameLineWidth()
	{
		return this.mFrameLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Color getFrameLineColor()
	{
		return this.mFrameLineColorButton.getColor();
	}


	/**
	 * 
	 */
	public Color getBackgroundColor()
	{
		return this.mBackgroundColorButton.getColor();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public Color getTextColor()
	{
		return this.mStringColorButton.getColor();
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public Boolean isLegendTransparent()
	{
		return this.mBackgroundTransparentCheckBox.getSelected();
	}



	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		return this.setValue( this.mXValueTextField, obj );
	}

	
	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		return this.setValue( this.mYValueTextField, obj );
	}
	

	
	/**
	 * 
	 */
	public void setLegendVisible( final Boolean b )
	{
		this.mLegendVisibleCheckBox.setSelected( b );
		this.setAllLegendComponentsEnabled( b );
	}


	/**
	 * 
	 */
	public void setFrameVisible( final Boolean b )
	{
		this.mFrameVisibleCheckBox.setSelected( b );
		this.setFrameComponentsEnabled( b );
	}


	/**
	 * 
	 */
	public boolean setFrameLineWidth( final Object value )
	{
		return this.setValue( this.mFrameLineWidthSpinner, value );
	}


	/**
	 * 
	 */
	public void setFrameLineColor( final Color cl )
	{
		this.mFrameLineColorButton.setColor(cl);
	}


	/**
	 * 
	 */
	public void setBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setColor(cl);
	}


	/**
	 * 
	 */
	public boolean setFontSize( final Object value )
	{
		return this.setValue( this.mFontSizeSpinner, value );
	}


	/**
	 * 
	 */
	public void setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final Integer style )
	{
		String styleName = null;
		if( style!=null )
		{
			styleName = SGUtilityText.getFontStyleName( style.intValue() );
		}
		this.mFontStyleComboBox.setSelectedItem( styleName );

		return true;
	}


	/**
	 * 
	 */
	public void setTextColor( final Color cl )
	{
		this.mStringColorButton.setColor(cl);
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public void setLegendTransparent( final Boolean b )
	{
		this.mBackgroundTransparentCheckBox.setSelected(b);
		this.setBackgroundComponentsEnabled( b );
	}


	
	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}


	
	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mBackgroundColorButton );
		list.add( this.mFrameLineColorButton );
		list.add( this.mStringColorButton );

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mFrameLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public boolean setDialogProperty()
	{
		SGLegendDialog dg = this;
		ArrayList list = this.mPropertyDialogObserverList;
		if( this.mAxesButtonGroup.setRadioButton( list ) == false )
		{
			return false;
		}

		SGILegendDialogObserver legend0
			= (SGILegendDialogObserver)list.get(0);

		final double xValue0 = legend0.getXValue();
		final double yValue0 = legend0.getYValue();
		final String fontName0 = legend0.getFontName();
		final float fontSize0 = legend0.getFontSize();
		final int fontStyle0 = legend0.getFontStyle();
		final Color stringColor0 = legend0.getStringColor();
		final float frameLineWidth0 = legend0.getFrameLineWidth();
		final Color frameLineColor0 = legend0.getFrameLineColor();
		final Color bgColor0 = legend0.getBackgroundColor();
		final boolean legendVisible0 = legend0.isLegendVisible();
		final boolean frameLineVisible0 = legend0.isFrameLineVisible();
		final boolean transparent0 = legend0.isBackgroundTransparent();

		Double xValue = new Double( xValue0 );
		Double yValue = new Double( yValue0 );
		String fontName = new String( fontName0 );
		Float fontSize = new Float( fontSize0 );
		Integer fontStyle = new Integer( fontStyle0 );
		Color stringColor = stringColor0;
		Float frameLineWidth = new Float( frameLineWidth0 );
		Color frameLineColor = frameLineColor0;
		Color bgColor = bgColor0;
		Boolean legendVisible = Boolean.valueOf( legendVisible0 );
		Boolean frameLineVisible = Boolean.valueOf( frameLineVisible0 );
		Boolean transparent = Boolean.valueOf( transparent0 );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final double xValue1 = legend1.getXValue();
				if( xValue0!=xValue1 )
				{
					xValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final double yValue1 = legend1.getYValue();
				if( yValue0!=yValue1 )
				{
					yValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final String fontName1 = legend1.getFontName();
				if( fontName0.equals(fontName1) == false )
				{
					fontName = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final float fontSize1 = legend1.getFontSize();
				if( fontSize0!=fontSize1 )
				{
					fontSize = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final int fontStyle1 = legend1.getFontStyle();
				if( fontStyle0!=fontStyle1 )
				{
					fontStyle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final Color stringColor1 = legend1.getStringColor();
				if( stringColor.equals(stringColor1) == false )
				{
					stringColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final float frameLineWidth1 = legend1.getFrameLineWidth();
				if( frameLineWidth0!=frameLineWidth1 )
				{
					frameLineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final Color frameLineColor1 = legend1.getFrameLineColor();
				if( frameLineColor.equals(frameLineColor1) == false )
				{
					frameLineColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final Color bgColor1 = legend1.getBackgroundColor();
				if( bgColor.equals(bgColor1) == false )
				{
					bgColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final boolean legendVisible1 = legend1.isLegendVisible();
				if( legendVisible0!=legendVisible1 )
				{
					legendVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final boolean frameLineVisible1 = legend1.isFrameLineVisible();
				if( frameLineVisible0!=frameLineVisible1 )
				{
					frameLineVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGILegendDialogObserver legend1
					= (SGILegendDialogObserver)list.get(ii);

				final boolean transparent1 = legend1.isBackgroundTransparent();
				if( transparent0!=transparent1 )
				{
					transparent = null;
					break;
				}
			}

		}


		
		// location
		dg.setXValue( xValue );
		dg.setYValue( yValue );

		
		//
		dg.setFrameVisible( frameLineVisible );
		dg.setFrameLineWidth( frameLineWidth );
		dg.setFrameLineColor( frameLineColor );


		//
		dg.setFontName( fontName );
		dg.setFontSize( fontSize );
		dg.setFontStyle( fontStyle );
		dg.setTextColor( stringColor );


		//
		dg.setBackgroundColor( bgColor );
		dg.setLegendTransparent( transparent );


		//
		dg.setLegendVisible( legendVisible );


		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{

		SGILegendDialogObserver legend = (SGILegendDialogObserver)l;


		// get values
		final int xConfig = this.mAxesButtonGroup.getXAxisConfiguration();
		final int yConfig = this.mAxesButtonGroup.getYAxisConfiguration();
		final Number xValue = this.getXValue();
		final Number yValue = this.getYValue();
		final Boolean visible = this.getLegendVisible();
		final Boolean frameVisible = this.getFrameVisible();
		final Number frameLineWidth = this.getFrameLineWidth();
		final Color frameLineColor = this.getFrameLineColor();
		final Color bgColor = this.getBackgroundColor();
		final Boolean transparent = this.isLegendTransparent();
		final String fontName = this.getFontName();
		final Number fontSize = this.getFontSize();
		final int fontStyle = this.getFontStyle();
		final Color textColor = this.getTextColor();


		// check values
		if( legend.hasValidXAxisValue( xConfig, xValue ) == false )
		{
			return false;
		}

		if( legend.hasValidYAxisValue( yConfig, yValue ) == false )
		{
			return false;
		}


		// set the related axes
		if( xConfig!=-1 & yConfig!=-1 )
		{
			legend.setAxisConfiguration( xConfig, yConfig );
		}


		// x value
		if( xValue!=null )
		{
			legend.setXValue( xValue.doubleValue() );
		}
		
		// y value
		if( yValue!=null )
		{
			legend.setYValue( yValue.doubleValue() );
		}


		// visible
		if( visible!=null )
		{
			legend.setLegendVisible( visible.booleanValue() );
		}


		// frame
		if( frameVisible!=null )
		{
			legend.setFrameVisible( frameVisible.booleanValue() );
		}

		if( frameLineWidth!=null )
		{
			legend.setFrameLineWidth( frameLineWidth.floatValue() );
		}

		if( frameLineColor!=null )
		{
			legend.setFrameLineColor( frameLineColor );
		}

		if( bgColor!=null )
		{
			legend.setBackgroundColor( bgColor );
		}

		if( transparent!=null )
		{
			legend.setBackgroundTransparent( transparent.booleanValue() );
		}


		// font
		if( fontName!=null )
		{
			legend.setFontName( fontName );
		}

		if( fontSize!=null )
		{
			legend.setFontSize( fontSize.floatValue() );
		}

		if( fontStyle!=-1 )
		{
			legend.setFontStyle( fontStyle );
		}

		if( textColor!=null )
		{
			legend.setStringColor( textColor );
		}

		return true;

	}

    
}

