/*
 * TLDialog.java
 *
 * Created on 2005/05/09, 16:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;

import javax.swing.JRadioButton;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSingleAxisRadioButtonManager;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;

/**
 *
 * @author  kuromaru
 */
public class SGTimingLineDialog extends SGPropertyDialog
{
    
	/**
	 * 
	 */
	public static final String TITLE = "Timing Line Properties";


    /** Creates new form SGTimingLineDialog */
    public SGTimingLineDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mCommonPanel = new javax.swing.JPanel();
        mLeftRadioButton = new javax.swing.JRadioButton();
        mBottomRadioButton = new javax.swing.JRadioButton();
        mTopRadioButton = new javax.swing.JRadioButton();
        mRightRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();
        mCenterLabel = new javax.swing.JLabel();
        mTimingLinePanel = new javax.swing.JPanel();
        mTimingValueLabel = new javax.swing.JLabel();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mTimingValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftRadioButton.setText("Left");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mCommonPanel.add(mLeftRadioButton, gridBagConstraints);

        mBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mBottomRadioButton.setText("Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        mCommonPanel.add(mBottomRadioButton, gridBagConstraints);

        mTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mTopRadioButton.setText("Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        mCommonPanel.add(mTopRadioButton, gridBagConstraints);

        mRightRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightRadioButton.setText("Right");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        mCenterLabel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mCenterLabel.setText("        ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        mCommonPanel.add(mCenterLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        mTimingLinePanel.setLayout(new java.awt.GridBagLayout());

        mTimingLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mTimingLinePanel.setFont(new java.awt.Font("MS Sans Serif", 0, 10));
        mTimingValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTimingValueLabel.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mTimingValueLabel, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mLineTypeLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mLineWidthLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mColorLabel, gridBagConstraints);

        mTimingValueTextField.setColumns(6);
        mTimingValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mTimingValueTextField, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mLineColorButton, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mTimingLinePanel.add(mLineTypeComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mLeftSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTimingLinePanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
   
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JRadioButton mBottomRadioButton;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mCenterLabel;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JRadioButton mLeftRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JPanel mTimingLinePanel;
    private javax.swing.JLabel mTimingValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTimingValueTextField;
    private javax.swing.JRadioButton mTopRadioButton;
    // ϐ錾̏I//GEN-END:variables
 
    
    

	private SGSingleAxisRadioButtonManager mAxisButtonGroup = null;

	
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGTimingLineDialog.TITLE );


		//
		{
			final String typeArray[] = {
				SGDrawingElementLine.LINE_NAME_SOLID,
				SGDrawingElementLine.LINE_NAME_BROKEN,
				SGDrawingElementLine.LINE_NAME_DOT,
				SGDrawingElementLine.LINE_NAME_DASHED,
				SGDrawingElementLine.LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		this.pack();

		
		// create a button group
		this.mAxisButtonGroup
			= new SGSingleAxisRadioButtonManager(
			this.mTopRadioButton,
			this.mBottomRadioButton,
			this.mLeftRadioButton,
			this.mRightRadioButton,
			new JRadioButton()
//			this.mNoAxisSelectionRadioButton
		);



		//
		// Xsi[f̓Kp
		//

		// line
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


//		// FύX{^ɃANVXiǉ
//		this.mLineColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}


		return true;
	}

	
	


	/**
	 * 
	 */
	public String getTimingValueString()
	{
		return this.mTimingValueTextField.getText();
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getTimingValue()
	{
		String str = this.getTimingValueString();
		if( str==null )
		{
			return null;
		}

		Number num = SGUtilityText.getDouble(str);		
		
		return num;
	}
	

	/**
	 * 
	 */
	public boolean setValue( final Object obj )
	{
		return this.setValue( this.mTimingValueTextField, obj );
	}


	/**
	 * 
	 */
	public boolean setLineType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
			this.mLineTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mLineTypeComboBox.setSelectedItem( null );
		}

		return true;
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return -1;
		}
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		this.mLineColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.mLineColorButton.getColor();
	}


	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int config )
	{
		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				this.mBottomRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				this.mTopRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				this.mLeftRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				this.mRightRadioButton.setSelected(true);
				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}


	
	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mLineColorButton);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mTimingValueTextField);
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * Set properties to all listeners.
	 * @param l
	 * @return
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGITimingLineDialogObserver line
			= (SGITimingLineDialogObserver)l;

		// get values
		final int config = this.mAxisButtonGroup.getAxisConfiguration();
		final Number value = this.getTimingValue();
		final int type = this.getLineType();
		final Number lineWidth = this.getLineWidth();
		final Color cl = this.getColor();


		// check values
		if( line.hasValidValue( config, value ) == false )
		{
			return false;
		}


		// set the related axes
		if( config!=-1 )
		{
			line.setAxisConfiguration( config );
		}

		// value
		if( value!=null )
		{
			line.setValue( value.doubleValue() );
		}

		// line type
		if( type!=-1 )
		{
			line.setLineType( type );
		}

		// line width
		if( lineWidth!=null )
		{
			line.setLineWidth( lineWidth.floatValue() );
		}

		// color
		if( cl!=null )
		{
			line.setColor( cl );
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
		final SGTimingLineDialog dg = this;

		ArrayList list = this.mPropertyDialogObserverList;

		if( this.mAxisButtonGroup.setRadioButton( list ) == false )
		{
			return false;
		}

//		final int len = list.size();
//
//		ArrayList axisList = new ArrayList( len );
//		
//		for( int ii=0; ii<len; ii++ )
//		{
//			SGITimingLineDialogObserver l
//				= (SGITimingLineDialogObserver)list.get(ii);
//			axisList.add( new Integer( l.getAxisConfiguration() ) );
//		}
//
//		if( this.mAxisButtonGroup.setAxes( axisList ) == false )
//		{
//			return false;
//		}


		SGITimingLineDialogObserver line0
			= (SGITimingLineDialogObserver)list.get(0);

		final double value0 = line0.getValue();
		final float lineWidth0 = line0.getLineWidth();
		final int lineType0 = line0.getLineType();
		final Color color0 = line0.getColor();

		Double value = new Double( value0 );
		Float lineWidth = new Float( lineWidth0 );
		Integer lineType = new Integer( lineType0 );
		Color color = color0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final double xValue1 = line1.getValue();
				if( value0!=xValue1 )
				{
					value = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final float fontSize1 = line1.getLineWidth();
				if( lineWidth0!=fontSize1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final int fontStyle1 = line1.getLineType();
				if( lineType0!=fontStyle1 )
				{
					lineType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final Color color1 = line1.getColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}
		}


		//
		this.setValue( value );

		this.setLineWidth( lineWidth );
		this.setLineType( lineType );
		this.setColor( color );


		this.setColorButtonBorder(true);

		return true;
	}

}

