/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.print.attribute.standard.MediaSize;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.application.SGAboutDialog;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileExtractor;
import jp.riken.brain.ni.samuraigraph.application.SGChangeLogDialog;
import jp.riken.brain.ni.samuraigraph.application.SGCloseWindowConfirmPanel;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIUpgradeConstants;
import jp.riken.brain.ni.samuraigraph.application.SGImageExportManager;
import jp.riken.brain.ni.samuraigraph.application.SGMultiDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGProgressMonitorDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGProxySettingDialog;
import jp.riken.brain.ni.samuraigraph.application.SGScrollPaneDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeConfirmDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGXYDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISXYGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIVXYGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigure;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SGDrawingServer
implements SGIApplicationTextConstants {
    public static String LOOK_AND_FEEL = null;
    public static int PORT_NUMBER = 5555;
    public static String PROPERTY_FILE_NAME = null;
    public static String ARCHIVE_FILE_NAME = null;
    public static boolean INPUT_FLAG = false;
    private static final int SUCCEEDED = 0;
    private static final int FAILED = -1;
    private static final int NOT_FOUND = 1;
    private static final int PROPERTY_FILE = 0;
    private static final int ARCHIVE_FILE = 1;
    private static Main mAppMain = null;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGVXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData;

    public static void main(String[] stringArray) {
        SGDrawingServer.interpretCommands(stringArray);
        if (!ApplicationProperties.loadProperties()) {
            System.exit(1);
        }
        if (!SGDrawingServer.setLookAndFeel()) {
            System.exit(1);
        }
        Main main = null;
        main = PROPERTY_FILE_NAME != null ? new Main(PROPERTY_FILE_NAME, 0) : (ARCHIVE_FILE_NAME != null ? new Main(ARCHIVE_FILE_NAME, 1) : new Main());
        try {
            main.join();
            mAppMain = main;
            SGDrawingServer.MacOSXRegistration();
            if (INPUT_FLAG) {
                ServerSocket serverSocket = null;
                Connect connect = new Connect(main, serverSocket);
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(null, "Failed to start up Samurai Graph.", "Error", -1, 2, null, null, null);
        }
    }

    private static void interpretCommands(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equals("-p")) {
                if (i + 1 >= stringArray.length || (object = SGUtilityText.getInteger(stringArray[i + 1])) == null) continue;
                PORT_NUMBER = (Integer)object;
                continue;
            }
            if (stringArray[i].equals("-prop")) {
                if (i + 1 >= stringArray.length) continue;
                PROPERTY_FILE_NAME = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-dataset")) {
                if (i + 1 >= stringArray.length) continue;
                ARCHIVE_FILE_NAME = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-i")) {
                INPUT_FLAG = true;
                continue;
            }
            object = SGDrawingServer.getLookAndFeelClassName(stringArray[i].toLowerCase());
            if (object == null) continue;
            LOOK_AND_FEEL = object;
        }
    }

    private static String getLookAndFeelClassName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name==null");
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string2 = lookAndFeelInfoArray[i].getName().toLowerCase();
            if (!string2.equals(string.toLowerCase())) continue;
            LOOK_AND_FEEL = lookAndFeelInfoArray[i].getClassName();
        }
        return null;
    }

    private static boolean setLookAndFeel() {
        try {
            if (LOOK_AND_FEEL == null) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(LOOK_AND_FEEL);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void MacOSXRegistration() {
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (bl) {
            try {
                Class<?> clazz = Class.forName("jp.riken.brain.ni.samuraigraph.platform.macosx.SGMacOSXAdapter");
                Method method = clazz.getMethod("registerMacOSXApplication", null);
                if (method != null) {
                    method.invoke(clazz, null);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean quitHandler() {
        if (mAppMain == null) {
            return false;
        }
        mAppMain.exit();
        return true;
    }

    public static boolean aboutHandler() {
        if (mAppMain == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList(mAppMain.mWndMap.values());
        if (arrayList.size() == 0) {
            return false;
        }
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)arrayList.get(0);
        SGDrawingServer.mAppMain.showAboutDialog(sGDrawingWindow);
        return true;
    }

    public static boolean openFileHandler(String string) {
        if (mAppMain == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList(mAppMain.mWndMap.values());
        if (arrayList.size() == 0) {
            return false;
        }
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)arrayList.get(0);
        return mAppMain.openFile(sGDrawingWindow, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Main
    extends Thread
    implements ActionListener,
    WindowListener,
    DropTargetListener,
    PropertyChangeListener,
    SGIConstants,
    SGIUpgradeConstants,
    SGIApplicationCommandConstants,
    SGIApplicationConstants,
    SGIPropertyFileConstants,
    SGIPreferencesConstants,
    SGIApplicationTextConstants,
    SGIRootObjectConstants,
    SGIImageConstants,
    SGIArchiveFileConstants {
        private Class mClassOfAxisElement = null;
        private Class mClassOfSXYGraphElement = null;
        private Class mClassOfVXYGraphElement = null;
        private Class mClassOfLegendElement = null;
        private Class mClassOfStringElement = null;
        private Class mClassOfAxisBreakElement = null;
        private Class mClassOfSignificantDifferenceElement = null;
        private Class mClassOfTimingLineElement = null;
        private Class mClassOfGridElement = null;
        private Class mClassOfShapeElement = null;
        private TreeMap mWndMap = new TreeMap();
        private SGImageExportManager mImageFileCreator;
        private SGPropertyFileCreator mPropertyFileCreator;
        private SGArchiveFileCreator mArchiveFileCreator;
        private SGArchiveFileExtractor mArchiveFileExtractor;
        private ProxyManager mProxyManager;
        private UpgradeManager mUpgradeManager;
        private SGDataCreator mDataCreator;
        private SGDrawingWindow mActiveWindow = null;
        private SGFigure mActiveFigure = null;
        private String mPropertyFileName;
        private String mArchiveFileName;
        private static final String PREF_KEY_MAJOR_VERSION_NUMBER = "Major Version";
        private static final String PREF_KEY_MINOR_VERSION_NUMBER = "Minor Version";
        private static final String PREF_KEY_MICRO_VERSION_NUMBER = "Micro Version";
        public static final int LAYER_GRID = 10;
        public static final int LAYER_TIMING_LINE = 20;
        public static final int LAYER_GRAPH = 30;
        public static final int LAYER_SIGNIFICANT_DIFFERENCE = 40;
        public static final int LAYER_AXIS = 50;
        public static final int LAYER_SHAPE = 60;
        public static final int LAYER_AXIS_BREAK = 70;
        public static final int LAYER_LEGEND = 80;
        public static final int LAYER_STRING = 90;
        private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
        private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialog = null;
        private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialogFromCLorDD = null;
        private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
        private String mCurrentDataFileName = null;
        private String mCurrentPropertyFileName = null;
        private String mCurrentImageFileName = null;
        private String mCurrentArchiveFileName = null;
        public static final String WINDOW_TITLE_PREFIX = "Samurai Graph - Window : ";
        private static final String DATASET_TEMPDIR_NAME = "SamuraiGraphArcvhive";
        private static final String DATASET_PROPERTY_FILENAME = "property.sgp";
        private static final String MSG_SAVE_DATASET_FAILED = "Failed save dataset";
        private static final String MSG_LOAD_DATASET_FAILED = "Failed load dataset";
        public static final String TAG_NAME_FOCUSED_FIGURES = "FocusedFigures";
        private ArrayList mCopiedObjectsBuffer = new ArrayList();
        private ArrayList mCopiedDataObjectBuffer = new ArrayList();
        private ArrayList mCopiedDataNameBuffer = new ArrayList();
        private ArrayList mCopiedDataPropertiesBuffer = new ArrayList();
        private ArrayList mCopiedDataPropertiesForLegendBuffer = new ArrayList();
        private WindowInfo mWindowInfo;
        public static final int FILE_TYPE_DATA = 0;
        public static final int FILE_TYPE_PROPERTY = 1;
        public static final int FILE_TYPE_IMAGE = 2;
        public static final int FILE_TYPE_DATASET = 3;
        private Document mPropertyFileDocument = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialogDD = null;

        public Main() {
            this.start();
        }

        public Main(String string, int n) {
            if (n == 0) {
                this.mPropertyFileName = string;
            } else if (n == 1) {
                this.mArchiveFileName = string;
            }
            this.start();
        }

        public void run() {
            SGDrawingWindow sGDrawingWindow;
            this.removeTemporaryFiles();
            SGSplashWindow sGSplashWindow = this.createSplashWindow();
            if (sGSplashWindow == null) {
                this.exitApplication(1);
            }
            sGSplashWindow.setProgressValue(0.0f);
            sGSplashWindow.setVisible(true);
            this.mDataCreator = new SGDataCreator();
            sGSplashWindow.setProgressValue(0.25f);
            this.mPropertyFileCreator = new SGPropertyFileCreator();
            sGSplashWindow.setProgressValue(0.4f);
            this.mArchiveFileCreator = new SGArchiveFileCreator();
            sGSplashWindow.setProgressValue(0.45f);
            this.mArchiveFileExtractor = new SGArchiveFileExtractor();
            sGSplashWindow.setProgressValue(0.5f);
            this.mImageFileCreator = new SGImageExportManager();
            sGSplashWindow.setProgressValue(0.6f);
            this.mProxyManager = new ProxyManager();
            sGSplashWindow.setProgressValue(0.7f);
            this.mUpgradeManager = new UpgradeManager(this.mProxyManager);
            sGSplashWindow.setProgressValue(0.85f);
            boolean bl = true;
            try {
                if (!this.loadFigureElementClass()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                this.exitApplication(1);
            }
            sGSplashWindow.setProgressValue(1.0f);
            this.mActiveWindow = sGDrawingWindow = this.createNewWindow();
            sGDrawingWindow.setVisible(true);
            boolean bl2 = false;
            if (this.mPropertyFileName != null) {
                int n;
                sGSplashWindow.setVisible(false);
                File file = new File(this.mPropertyFileName);
                if (!this.showMultiDataFileChooserDialog(file, new ArrayList(), sGDrawingWindow)) {
                    this.exitApplication(1);
                }
                if ((n = this.mMultiDataFileChooserWizardDialogDD.getCloseOption()) == 1) {
                    this.exitApplication(0);
                }
            } else if (this.mArchiveFileName != null) {
                sGSplashWindow.setVisible(false);
                File file = new File(this.mArchiveFileName);
                if (this.loadDataSet(sGDrawingWindow, file) == -1) {
                    this.exitApplication(0);
                }
            }
            sGSplashWindow.setVisible(false);
            this.updatePreferences();
            if (this.checkDate()) {
                this.mUpgradeManager.upgradeOnStartup(sGDrawingWindow);
            }
        }

        private void removeTemporaryFiles() {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + "SamuraiGraphTemp");
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return;
            }
            if (file.exists()) {
                SGApplicationUtility.deleteRecursively(file);
            }
        }

        private void updatePreferences() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", -1);
            if (n == -1) {
                preferences.putInt("Upgrade Cycle", 3);
            }
            String string = preferences.get("Date", null);
            preferences.putLong("Date", System.currentTimeMillis());
            preferences.remove(PREF_KEY_MAJOR_VERSION_NUMBER);
            preferences.remove(PREF_KEY_MINOR_VERSION_NUMBER);
            preferences.remove(PREF_KEY_MICRO_VERSION_NUMBER);
        }

        private boolean checkDate() {
            boolean bl;
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            long l = preferences.getLong("Date", 0L);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            int n = preferences.getInt("Upgrade Cycle", 1);
            switch (n) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = l3 > 86400000L;
                    break;
                }
                case 3: {
                    bl = l3 > 604800000L;
                    break;
                }
                case 4: {
                    bl = l3 > 2592000000L;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadFigureElementClass() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(new File("ListOfFigureElement.txt"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.mClassOfAxisElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement");
                    this.mClassOfSXYGraphElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGSXYGraphElement");
                    this.mClassOfVXYGraphElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGVXYGraphElement");
                    this.mClassOfStringElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement");
                    this.mClassOfLegendElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendElement");
                    this.mClassOfAxisBreakElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakElement");
                    this.mClassOfSignificantDifferenceElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceElement");
                    this.mClassOfTimingLineElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGTimingLineElement");
                    this.mClassOfGridElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGGridElement");
                    this.mClassOfShapeElement = Class.forName("jp.riken.brain.ni.samuraigraph.figure.java2d.SGShapeElement");
                    boolean bl = true;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    return bl;
                }
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Class clazz = null;
                clazz = this.getClassObject(properties, "SGAxisElement", class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfAxisElement = clazz;
                clazz = this.getClassObject(properties, "SGSXYGraphElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfSXYGraphElement = clazz;
                clazz = this.getClassObject(properties, "SGVXYGraphElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfVXYGraphElement = clazz;
                clazz = this.getClassObject(properties, "SGLegendElement", class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGILegendElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfLegendElement = clazz;
                clazz = this.getClassObject(properties, "SGStringElement", class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfStringElement = clazz;
                clazz = this.getClassObject(properties, "SGAxisBreakElement", class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfAxisBreakElement = clazz;
                clazz = this.getClassObject(properties, "SGSignificantDifferenceElement", class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfSignificantDifferenceElement = clazz;
                clazz = this.getClassObject(properties, "SGTimingLineElement", class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfTimingLineElement = clazz;
                clazz = this.getClassObject(properties, "SGGridElement", class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGridElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfGridElement = clazz;
                clazz = this.getClassObject(properties, "SGShapeElement", class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIShapeElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement);
                if (clazz == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mClassOfShapeElement = clazz;
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            return true;
        }

        private Class getClassObject(Properties properties, String string, Class clazz) throws ClassNotFoundException {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                return null;
            }
            Class<?> clazz2 = Class.forName(string2);
            if (!clazz.isAssignableFrom(clazz2)) {
                return null;
            }
            return clazz2;
        }

        private String getBooleanString(String string) {
            String string2 = Boolean.TRUE.toString();
            String string3 = Boolean.FALSE.toString();
            Integer n = SGUtilityText.getInteger(string);
            String string4 = null;
            if (n != null) {
                string4 = string.equals("0") ? string2 : string3;
            } else {
                String string5 = string.toLowerCase();
                if (string5.equals(string2)) {
                    string4 = string2;
                } else if (string5.equals(string3)) {
                    string4 = string3;
                }
            }
            return string4;
        }

        public int exec(String string) {
            SGDrawingWindow sGDrawingWindow = this.mActiveWindow;
            SGFigure sGFigure = this.mActiveFigure;
            ArrayList arrayList = new ArrayList();
            String string2 = this.parseCommand(string, arrayList);
            if (string2 == null) {
                return -1;
            }
            int n = arrayList.size();
            int n2 = this.execBasicCommand(string2, arrayList);
            if (n2 != 1) {
                return n2;
            }
            n2 = this.execMenuBarCommand(string2, arrayList);
            if (n2 != 1) {
                return n2;
            }
            n2 = this.setWindowProperties(string2, sGDrawingWindow, arrayList);
            if (n2 != 1) {
                return n2;
            }
            n2 = this.setFigureProperties(string2, sGFigure, arrayList);
            if (n2 != 1) {
                return n2;
            }
            n2 = this.setFigureElementProperties(string2, sGFigure, arrayList);
            if (n2 != 1) {
                return n2;
            }
            return 1;
        }

        private int execBasicCommand(String string, ArrayList arrayList) {
            int n = arrayList.size();
            SGDrawingWindow sGDrawingWindow = this.mActiveWindow;
            if (string.equals("chwin")) {
                if (n < 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                Integer n2 = SGUtilityText.getInteger(string2);
                if (n2 == null) {
                    return -1;
                }
                int n3 = n2;
                SGDrawingWindow sGDrawingWindow2 = this.getWindow(n3);
                if (sGDrawingWindow2 == null) {
                    return -1;
                }
                this.mActiveWindow = sGDrawingWindow2;
                return 0;
            }
            if (string.equals("chfig")) {
                if (n != 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                Integer n4 = SGUtilityText.getInteger(string3);
                if (n4 == null) {
                    return -1;
                }
                int n5 = n4;
                SGFigure sGFigure = sGDrawingWindow.getFigure(n5);
                if (sGFigure == null) {
                    return -1;
                }
                this.mActiveFigure = sGFigure;
                return 0;
            }
            if (string.equals("selectFigure")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                int[] nArray = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string4 = (String)arrayList.get(i);
                    Integer n6 = SGUtilityText.getInteger(string4);
                    if (n6 == null) {
                        return -1;
                    }
                    nArray[i] = n6;
                }
                sGDrawingWindow.setSelectedFigure(nArray);
                return 0;
            }
            if (string.equals("tree")) {
                if (sGDrawingWindow == null) {
                    return -1;
                }
                StringBuffer stringBuffer = new StringBuffer();
                sGDrawingWindow.createTree(stringBuffer);
                System.out.println(stringBuffer);
                return 0;
            }
            if (string.equals("zoom")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string5 = (String)arrayList.get(0);
                Double d = SGUtilityText.getDouble(string5);
                if (d == null) {
                    return -1;
                }
                if (!sGDrawingWindow.setZoomValue(d)) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }

        private int execMenuBarCommand(String string, ArrayList arrayList) {
            int n = this.execMenuBarCommandFile(string, arrayList);
            if (n != 1) {
                return n;
            }
            n = this.execMenuBarCommandEdit(string, arrayList);
            if (n != 1) {
                return n;
            }
            n = this.execMenuBarCommandInsert(string, arrayList);
            if (n != 1) {
                return n;
            }
            n = this.execMenuBarCommandLayout(string, arrayList);
            if (n != 1) {
                return n;
            }
            return 1;
        }

        private int execMenuBarCommandFile(String string, ArrayList arrayList) {
            int n = arrayList.size();
            SGDrawingWindow sGDrawingWindow = this.mActiveWindow;
            if (string.equals("wopen")) {
                SGDrawingWindow sGDrawingWindow2 = this.createNewWindow();
                if (sGDrawingWindow2 == null) {
                    return -1;
                }
                sGDrawingWindow2.setVisible(true);
                return 0;
            }
            if (string.equals("wclose")) {
                if (n == 0) {
                    if (sGDrawingWindow != null) {
                        this.closeWindow(sGDrawingWindow);
                    }
                } else if (n == 1) {
                    String string2 = (String)arrayList.get(0);
                    Integer n2 = SGUtilityText.getInteger(string2);
                    if (n2 == null) {
                        return -1;
                    }
                    int n3 = n2;
                    this.closeWindow(n3);
                } else {
                    return -1;
                }
                return 0;
            }
            if (string.equals("drawGraph")) {
                if (n < 3) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                String string4 = (String)arrayList.get(1);
                String string5 = (String)arrayList.get(2);
                Integer n4 = SGUtilityText.getInteger(string3);
                if (n4 == null) {
                    return -1;
                }
                int n5 = n4;
                String string6 = string4;
                File file = new File(string6);
                if (!file.exists()) {
                    return -1;
                }
                String string7 = string5;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(string7);
                if (string7.equals("SXY_SAMPLING")) {
                    if (arrayList.size() < 4) {
                        return -1;
                    }
                    String string8 = (String)arrayList.get(3);
                    Double d = SGUtilityText.getDouble(string8);
                    if (d == null) {
                        return -1;
                    }
                    arrayList2.add(d);
                }
                if (!this.drawGraph(sGDrawingWindow, n5, arrayList2, string6, false)) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("loadProperty")) {
                Object object;
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string9 = (String)arrayList.get(0);
                File file = new File(string9);
                if (!file.exists()) {
                    return -1;
                }
                String string10 = SGUtility.getCanonicalPath(file.getPath());
                if (string10 == null) {
                    return -1;
                }
                URL uRL = null;
                try {
                    uRL = file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return -1;
                }
                Document document = SGUtilityText.getDocument(uRL);
                if (document == null) {
                    return -1;
                }
                Element element = this.getWindowElement(document);
                NodeList nodeList = element.getElementsByTagName("Figure");
                int n6 = nodeList.getLength();
                int n7 = 0;
                int[] nArray = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    object = nodeList.item(i);
                    if (!(object instanceof Element)) {
                        return -1;
                    }
                    Element element2 = (Element)object;
                    NodeList nodeList2 = element2.getElementsByTagName("Data");
                    nArray[i] = nodeList2.getLength();
                    n7 += nArray[i];
                }
                if (n7 != n - 1) {
                    return -1;
                }
                ArrayList arrayList3 = new ArrayList(arrayList.subList(1, n));
                object = new TreeMap();
                n7 = 0;
                for (int i = 0; i < n6; ++i) {
                    int n8 = nArray[i];
                    ArrayList arrayList4 = new ArrayList();
                    for (int j = 0; j < n8; ++j) {
                        arrayList4.add(arrayList3.get(n7 + j));
                    }
                    object.put(new Integer(i), arrayList4);
                    n7 += n8;
                }
                if (!this.setPropertyFile(sGDrawingWindow, document, (Map)object)) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("saveProperty")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                    return -1;
                }
                String string11 = (String)arrayList.get(0);
                int n9 = this.saveProperties(sGDrawingWindow, string11);
                sGDrawingWindow.setSaved(n9 == 0);
                return 0;
            }
            if (string.equals("loadDataSet")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string12 = (String)arrayList.get(0);
                File file = new File(string12);
                if (!file.exists()) {
                    return -1;
                }
                if (this.loadDataSet(sGDrawingWindow, file) == -1) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("saveDataSet")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                    return -1;
                }
                String string13 = (String)arrayList.get(0);
                int n10 = this.saveDataSet(sGDrawingWindow, string13);
                sGDrawingWindow.setSaved(n10 == 0);
                return 0;
            }
            if (string.equals("loadBackgroundImage")) {
                if (n < 1) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string14 = (String)arrayList.get(0);
                if (!this.setImage(string14, sGDrawingWindow)) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("exportAsImage")) {
                if (n < 2) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                String string15 = (String)arrayList.get(0);
                String string16 = (String)arrayList.get(1);
                Properties properties = new Properties();
                for (int i = 2; i < n; ++i) {
                    String string17 = (String)arrayList.get(i);
                    if (this.getProperties(string17, properties)) continue;
                    return -1;
                }
                sGDrawingWindow.startExport();
                Component component = sGDrawingWindow.getExportTarget();
                if (!this.mImageFileCreator.export(component, component.getWidth(), component.getHeight(), string15, string16, properties)) {
                    sGDrawingWindow.endExport();
                    return -1;
                }
                sGDrawingWindow.endExport();
                return 0;
            }
            if (string.equals("print")) {
                if (n != 0) {
                    return -1;
                }
                if (sGDrawingWindow == null) {
                    return -1;
                }
                if (!sGDrawingWindow.printImage(true)) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("exit")) {
                if (n != 0) {
                    return -1;
                }
                this.exit();
                return 0;
            }
            return 1;
        }

        private boolean getProperties(String string, Properties properties) {
            int n = string.indexOf("=");
            if (n == -1 | n == 0 | n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            properties.setProperty(string2, string3);
            return true;
        }

        private int execMenuBarCommandEdit(String string, ArrayList arrayList) {
            int n = arrayList.size();
            SGDrawingWindow sGDrawingWindow = this.mActiveWindow;
            if (string.equals("undo")) {
                if (sGDrawingWindow == null) {
                    return -1;
                }
                sGDrawingWindow.undo();
                sGDrawingWindow.repaintContentPane();
                return 0;
            }
            if (string.equals("redo")) {
                if (sGDrawingWindow == null) {
                    return -1;
                }
                sGDrawingWindow.redo();
                sGDrawingWindow.repaintContentPane();
                return 0;
            }
            if (string.equals("clearUndoBuffer")) {
                sGDrawingWindow.clearUndoBuffer();
                return 0;
            }
            if (string.equals("cut")) {
                sGDrawingWindow.doCut();
                return 0;
            }
            if (string.equals("copy")) {
                sGDrawingWindow.doCopy();
                return 0;
            }
            if (string.equals("paste")) {
                sGDrawingWindow.doPaste();
                return 0;
            }
            if (string.equals("delete")) {
                sGDrawingWindow.doDelete();
                return 0;
            }
            if (string.equals("duplicate")) {
                sGDrawingWindow.doDuplicate();
                return 0;
            }
            if (string.equals("deleteBackgroundImage")) {
                if (!sGDrawingWindow.deleteImage()) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }

        private Number getNumber(String string, StringBuffer stringBuffer) {
            return SGUtilityText.getNumber(string, stringBuffer);
        }

        private int execMenuBarCommandInsert(String string, ArrayList arrayList) {
            SGFigure sGFigure = this.mActiveFigure;
            if (sGFigure == null) {
                return 1;
            }
            int n = arrayList.size();
            if (string.equals("insertLabel")) {
                if (n == 1) {
                    String string2 = (String)arrayList.get(0);
                    if (string2.length() == 0) {
                        return -1;
                    }
                    sGFigure.addString(0, 0, string2);
                } else if (n == 3) {
                    String string3 = (String)arrayList.get(0);
                    String string4 = (String)arrayList.get(1);
                    String string5 = (String)arrayList.get(2);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    Number number2 = this.getNumber(string4, stringBuffer2);
                    if (number2 == null) {
                        return -1;
                    }
                    double d = SGUtilityText.convertToPoint(number.doubleValue(), stringBuffer.toString());
                    double d2 = SGUtilityText.convertToPoint(number2.doubleValue(), stringBuffer2.toString());
                    double d3 = (double)sGFigure.getFigureX() + d;
                    double d4 = (double)sGFigure.getFigureY() + d2;
                    sGFigure.addString((int)d3, (int)d4, string5);
                } else {
                    return -1;
                }
                return 0;
            }
            if (string.equals("insertAxisBreak") | string.equals("insertSignificantDifference") | string.equals("insertRectangle") | string.equals("insertEllipse") | string.equals("insertArrow") | string.equals("insertLine") | string.equals("insertTimingLine")) {
                if (n == 2) {
                    String string6 = (String)arrayList.get(0);
                    String string7 = (String)arrayList.get(1);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer3 = new StringBuffer();
                    Number number = this.getNumber(string6, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    Number number3 = this.getNumber(string7, stringBuffer3);
                    if (number3 == null) {
                        return -1;
                    }
                    double d = SGUtilityText.convertToPoint(number.doubleValue(), stringBuffer.toString());
                    double d5 = SGUtilityText.convertToPoint(number3.doubleValue(), stringBuffer3.toString());
                    float f = sGFigure.getMagnification();
                    int n2 = (int)((double)sGFigure.getGraphRectX() + (double)f * d);
                    int n3 = (int)((double)sGFigure.getGraphRectY() + (double)f * d5);
                    if (string.equals("insertAxisBreak")) {
                        sGFigure.addAxisBreakSymbol(n2, n3);
                    } else if (string.equals("insertSignificantDifference")) {
                        sGFigure.addSignificantDifferenceSymbol(n2, n3);
                    } else if (string.equals("insertTimingLine")) {
                        sGFigure.addTimingLine(n2, n3);
                    } else if (string.equals("insertRectangle")) {
                        sGFigure.addShape(0, n2, n3);
                    } else if (string.equals("insertEllipse")) {
                        sGFigure.addShape(1, n2, n3);
                    } else if (string.equals("insertArrow")) {
                        sGFigure.addShape(2, n2, n3);
                    } else if (string.equals("insertLine")) {
                        sGFigure.addShape(3, n2, n3);
                    }
                } else {
                    return -1;
                }
                sGFigure.repaint();
                return 0;
            }
            return 1;
        }

        private int execMenuBarCommandLayout(String string, ArrayList arrayList) {
            int n = arrayList.size();
            SGDrawingWindow sGDrawingWindow = this.mActiveWindow;
            if (sGDrawingWindow == null) {
                return -1;
            }
            if (string.equals("paperAlignment")) {
                return 0;
            }
            if (string.equals("boundingBox")) {
                if (!sGDrawingWindow.setBoundingBox()) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("autoArrangement")) {
                if (!sGDrawingWindow.alignFigures()) {
                    return -1;
                }
                return 0;
            }
            if (string.equals("autoZoom")) {
                if (n < 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string2));
                if (bl == null) {
                    return -1;
                }
                sGDrawingWindow.setAutoZoom(bl);
                return 0;
            }
            if (string.equals("lock")) {
                if (n < 1) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                sGDrawingWindow.setLocked(bl);
                return 0;
            }
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setWindowProperties(String string, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            String[] stringArray = new String[]{"paperWidth", "paperHeight", "paperSize", "paperGridInterval", "paperGridLineWidth", "paperGridVisible", "paperGridColor", "paperBackgroundColor", "imageLocationX", "imageLocationY", "imageScalingFactor", "cutFigure", "copyFigure", "pasteFigure", "deleteFigure", "duplicateFigure", "moveToFrontFigure", "moveToBackFigure"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            int n = arrayList.size();
            if (string.equals("paperWidth")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                Number number = this.getNumber(string2, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperHeight")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                Number number = this.getNumber(string3, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperHeightDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperSize")) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2;
                if (n == 1) {
                    String string4 = (String)arrayList.get(0);
                    MediaSize mediaSize = SGUtilityText.getMediaSize(string4);
                    if (mediaSize == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setPaperSizeDirectly(mediaSize)) return 0;
                    return -1;
                }
                if (n != 2) return 0;
                String string5 = (String)arrayList.get(0);
                Number number = this.getNumber(string5, stringBuffer2 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                String string6 = (String)arrayList.get(1);
                Number number2 = this.getNumber(string6, stringBuffer = new StringBuffer());
                if (number2 == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperSizeDirectly(number.floatValue(), stringBuffer2.toString(), number2.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridInterval")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string7 = (String)arrayList.get(0);
                Number number = this.getNumber(string7, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineIntervalDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridLineWidth")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string8 = (String)arrayList.get(0);
                Number number = this.getNumber(string8, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridVisible")) {
                if (n != 1) {
                    return -1;
                }
                String string9 = (String)arrayList.get(0);
                String string10 = this.getBooleanString(string9);
                if (string10 == null) {
                    return -1;
                }
                Boolean bl = Boolean.valueOf(string10);
                if (sGDrawingWindow.setGridLineVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("paperGridColor")) {
                String string11;
                String string12;
                if (n == 1) {
                    String string13 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string13);
                    if (color == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setGridLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (n != 3) return -1;
                String string14 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string14, string12 = (String)arrayList.get(1), string11 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("paperBackgroundColor")) {
                String string15;
                String string16;
                if (n == 1) {
                    String string17 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string17);
                    if (color == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setPaperColorDirectly(color)) return 0;
                    return -1;
                }
                if (n != 3) return -1;
                String string18 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string18, string16 = (String)arrayList.get(1), string15 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("imageLocationX")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string19 = (String)arrayList.get(0);
                Number number = this.getNumber(string19, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageLocationXDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("imageLocationY")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string20 = (String)arrayList.get(0);
                Number number = this.getNumber(string20, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageLocationYDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("imageScalingFactor")) {
                if (n != 1) {
                    return -1;
                }
                String string21 = (String)arrayList.get(0);
                Float f = SGUtilityText.getFloat(string21);
                if (f == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageScalingFactorDirectly(((Number)f).floatValue())) return 0;
                return -1;
            }
            if (string.equals("deleteFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string22 = (String)arrayList.get(0);
                Integer n2 = SGUtilityText.getInteger(string22);
                if (n2 == null) {
                    return -1;
                }
                if (sGDrawingWindow.hideFigure(n2)) return 0;
                return -1;
            }
            if (string.equals("duplicateFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string23 = (String)arrayList.get(0);
                Integer n3 = SGUtilityText.getInteger(string23);
                if (n3 == null) {
                    return -1;
                }
                if (sGDrawingWindow.hideFigure(n3)) return 0;
                return -1;
            }
            if (string.equals("moveToFrontFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string24 = (String)arrayList.get(0);
                Integer n4 = SGUtilityText.getInteger(string24);
                if (n4 == null) {
                    return -1;
                }
                if (sGDrawingWindow.moveFigure(n4, true)) return 0;
                return -1;
            }
            if (!string.equals("moveToBackFigure")) return 0;
            if (n != 1) {
                return -1;
            }
            String string25 = (String)arrayList.get(0);
            Integer n5 = SGUtilityText.getInteger(string25);
            if (n5 == null) {
                return -1;
            }
            if (sGDrawingWindow.moveFigure(n5, false)) return 0;
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setFigureProperties(String string, SGFigure sGFigure, ArrayList arrayList) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (sGFigure == null) {
                return -1;
            }
            String[] stringArray = new String[]{"figureLocationX", "figureLocationY", "figureWidth", "figureHeight", "figureSpaceToScale", "figureSpaceToTitle", "figureBackgroundColor", "figureBackgroundTransparent", "figureGridAxisX", "figureGridAxisY", "figureGridVisible", "figureGridAuto", "figureGridStepX", "figureGridStepY", "figureGridBaseX", "figureGridBaseY", "figureGridLineWidth", "figureGridLineType", "figureGridColor"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (n < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            if (string.equals("figureLocationX")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureXDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureLocationY")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureYDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureWidth")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureWidthDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureHeight")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureHeightDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureSpaceToScale")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setSpaceAxisLineAndNumberDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureSpaceToTitle")) {
                object4 = new StringBuffer();
                object3 = this.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setSpaceNumberAndTitleDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureBackgroundColor")) {
                if (n == 1) {
                    object4 = SGUtilityText.getColor(string2);
                    if (object4 == null) {
                        return -1;
                    }
                    if (!sGFigure.setBackgroundColorDirectly((Color)object4)) {
                        return -1;
                    }
                } else {
                    if (n != 3) return -1;
                    object4 = string2;
                    object3 = (String)arrayList.get(1);
                    object = SGUtilityText.getColor((String)object4, (String)object3, (String)(object2 = (String)arrayList.get(2)));
                    if (object == null) {
                        return -1;
                    }
                    if (!sGFigure.setBackgroundColorDirectly((Color)object)) {
                        return -1;
                    }
                }
            } else if (string.equals("figureBackgroundTransparent") && !sGFigure.setTransparentDirectly((Boolean)(object4 = SGUtilityText.getBoolean(this.getBooleanString(string2))))) {
                return -1;
            }
            if (!(sGFigure instanceof SGXYFigure)) return 0;
            object4 = (SGXYFigure)sGFigure;
            if (string.equals("figureGridAxisX")) {
                int n2 = this.getAxisLocation(string2);
                if (n2 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setXAxisLocationDirectly(n2)) return 0;
                return -1;
            }
            if (string.equals("figureGridAxisY")) {
                int n3 = this.getAxisLocation(string2);
                if (n3 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setYAxisLocationDirectly(n3)) return 0;
                return -1;
            }
            if (string.equals("figureGridVisible")) {
                object3 = SGUtilityText.getBoolean(this.getBooleanString(string2));
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridVisibleDirectly((Boolean)object3)) return 0;
                return -1;
            }
            if (string.equals("figureGridAuto")) {
                object3 = SGUtilityText.getBoolean(this.getBooleanString(string2));
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setAutoCalculateRangeDirectly((Boolean)object3)) return 0;
                return -1;
            }
            if (string.equals("figureGridStepX")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridStepValueXDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridStepY")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridStepValueYDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridBaseX")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridBaselineValueXDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridBaseY")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridBaselineValueYDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridLineWidth")) {
                object3 = new StringBuffer();
                object2 = this.getNumber(string2, (StringBuffer)object3);
                if (object2 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridLineWidthDirectly(((Number)object2).floatValue(), ((StringBuffer)object3).toString())) return 0;
                return -1;
            }
            if (string.equals("figureGridLineType")) {
                int n4 = this.getLineType(string2);
                if (n4 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridLineTypeDirectly(n4)) return 0;
                return -1;
            }
            if (!string.equals("figureGridColor")) return 0;
            object3 = null;
            if (n == 1) {
                object3 = SGUtilityText.getColor(string2);
            } else {
                if (n != 3) return -1;
                object2 = (String)arrayList.get(0);
                object = (String)arrayList.get(1);
                String string3 = (String)arrayList.get(2);
                object3 = SGUtilityText.getColor((String)object2, (String)object, string3);
            }
            if (object3 == null) {
                return -1;
            }
            if (((SGXYFigure)object4).setGridLineColorDirectly((Color)object3)) return 0;
            return -1;
        }

        private int setFigureElementProperties(String string, SGFigure sGFigure, ArrayList arrayList) {
            int n;
            if (sGFigure == null) {
                return 1;
            }
            SGIGraphElement sGIGraphElement = (SGIGraphElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
            if (sGIGraphElement != null && (n = this.setDataProperties(string, sGIGraphElement, arrayList)) != 1) {
                return n;
            }
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement);
            if (sGIAxisElement != null && (n = this.setAxisProperties(string, sGIAxisElement, arrayList)) != 1) {
                return n;
            }
            SGILegendElement sGILegendElement = (SGILegendElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGILegendElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement);
            if (sGILegendElement != null && (n = this.setLegendProperties(string, sGILegendElement, arrayList)) != 1) {
                return n;
            }
            SGIStringElement sGIStringElement = (SGIStringElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
            if (sGIStringElement != null && (n = this.setLabelProperties(string, sGIStringElement, arrayList)) != 1) {
                return n;
            }
            SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement);
            if (sGISignificantDifferenceElement != null && (n = this.setSigDiffProperties(string, sGISignificantDifferenceElement, arrayList)) != 1) {
                return n;
            }
            SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement);
            if (sGIAxisBreakElement != null && (n = this.setAxisBreakProperties(string, sGIAxisBreakElement, arrayList)) != 1) {
                return n;
            }
            SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement);
            if (sGITimingLineElement != null && (n = this.setTimingLineProperties(string, sGITimingLineElement, arrayList)) != 1) {
                return n;
            }
            SGIShapeElement sGIShapeElement = (SGIShapeElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIShapeElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement);
            if (sGIShapeElement != null && (n = this.setShapeProperties(string, sGIShapeElement, arrayList)) != 1) {
                return n;
            }
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setAxisProperties(String string, SGIAxisElement sGIAxisElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"axisFont", "axisFontName", "axisFontStyle", "axisFontSize", "axisFontColor", "axisFrame", "axisFrameVisible", "axisFrameLineWidth", "axisFrameColor", "axisLineWidth", "tickMarkWidth", "tickMarkLength", "axisLineColor", "axisVisible", "axisTitleVisible", "axisTitleLabel", "axisScaleMin", "axisScaleMax", "axisScaleType", "axisTickMarkVisible", "axisTickMarkAuto", "axisTickMarkStep", "axisTickMarkBase", "axisTickMarkInner", "axisFormatVisible", "axisFormatInteger", "axisFormatExponentVisible", "axisFormatExponentValue"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (string.equals("axisFontName")) {
                String string2 = (String)arrayList.get(0);
                sGIAxisElement.setFontNameDirectly(string2);
                return 0;
            } else {
                if (string.equals("axisFontStyle")) {
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string3 = (String)arrayList.get(0);
                    int n2 = this.getFontStyle(string3);
                    if (n2 == -1) {
                        return -1;
                    }
                    if (sGIAxisElement.setFontStyleDirectly(n2)) return 0;
                    return -1;
                }
                if (string.equals("axisFontSize")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string4 = (String)arrayList.get(0);
                    Number number = this.getNumber(string4, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFontSizeDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisFontColor")) {
                    String string5;
                    String string6;
                    if (arrayList.size() == 1) {
                        String string7 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string7);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIAxisElement.setFontColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string8 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string8, string6 = (String)arrayList.get(1), string5 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFontColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisFrameVisible")) {
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string9 = (String)arrayList.get(0);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string9));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFrameVisibleDirectly(bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFrameLineWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string10 = (String)arrayList.get(0);
                    Number number = this.getNumber(string10, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFrameLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisFrameColor")) {
                    String string11;
                    String string12;
                    if (arrayList.size() == 1) {
                        String string13 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string13);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIAxisElement.setFrameLineColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string14 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string14, string12 = (String)arrayList.get(1), string11 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFrameLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisLineWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string15 = (String)arrayList.get(0);
                    Number number = this.getNumber(string15, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setAxisLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("tickMarkWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string16 = (String)arrayList.get(0);
                    Number number = this.getNumber(string16, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("tickMarkLength")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string17 = (String)arrayList.get(0);
                    Number number = this.getNumber(string17, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkLengthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisLineColor")) {
                    String string18;
                    String string19;
                    if (arrayList.size() == 1) {
                        String string20 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string20);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIAxisElement.setLineColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string21 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string21, string19 = (String)arrayList.get(1), string18 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string22 = (String)arrayList.get(0);
                    String string23 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string23));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setAxisVisibleDirectly(string22, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTitleVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string24 = (String)arrayList.get(0);
                    String string25 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string25));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTitleVisibleDirectly(string24, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTitleLabel")) {
                    String string26;
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string27 = (String)arrayList.get(0);
                    if (sGIAxisElement.setTitleDirectly(string27, string26 = (String)arrayList.get(1))) return 0;
                    return -1;
                }
                if (string.equals("axisScaleMin")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string28 = (String)arrayList.get(0);
                    String string29 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string29);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setMinValueDirectly(string28, d)) return 0;
                    return -1;
                }
                if (string.equals("axisScaleMax")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string30 = (String)arrayList.get(0);
                    String string31 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string31);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setMaxValueDirectly(string30, d)) return 0;
                    return -1;
                }
                if (string.equals("axisScaleType")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string32 = (String)arrayList.get(0);
                    String string33 = (String)arrayList.get(1);
                    int n3 = this.getScaleType(string33);
                    if (n3 == -1) {
                        return -1;
                    }
                    if (sGIAxisElement.setScaleTypeDirectly(string32, n3)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string34 = (String)arrayList.get(0);
                    String string35 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string35));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkVisibleDirectly(string34, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkAuto")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string36 = (String)arrayList.get(0);
                    String string37 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string37));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkAutoDirectly(string36, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkStep")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string38 = (String)arrayList.get(0);
                    String string39 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string39);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkStepDirectly(string38, d)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkBase")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string40 = (String)arrayList.get(0);
                    String string41 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string41);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkBaseDirectly(string40, d)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkInner")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string42 = (String)arrayList.get(0);
                    String string43 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string43));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setTickMarkInnerDirectly(string42, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string44 = (String)arrayList.get(0);
                    String string45 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string45));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFormatVisibleDirectly(string44, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatInteger")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string46 = (String)arrayList.get(0);
                    String string47 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string47));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFormatIntegerDirectly(string46, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatExponentVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string48 = (String)arrayList.get(0);
                    String string49 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string49));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIAxisElement.setFormatExponentVisibleDirectly(string48, bl)) return 0;
                    return -1;
                }
                if (!string.equals("axisFormatExponentValue")) return 0;
                if (arrayList.size() < 2) {
                    return -1;
                }
                String string50 = (String)arrayList.get(0);
                String string51 = (String)arrayList.get(1);
                Integer n4 = SGUtilityText.getInteger(string51);
                if (n4 == null) {
                    return -1;
                }
                if (sGIAxisElement.setFormatExponentValueDirectly(string50, n4)) return 0;
                return -1;
            }
        }

        private int getAxisLocation(String string) {
            String string2 = string.toLowerCase();
            int n = -1;
            if ("Bottom".toLowerCase().equals(string2)) {
                n = 0;
            } else if ("Top".toLowerCase().equals(string2)) {
                n = 1;
            } else if ("Left".toLowerCase().equals(string2)) {
                n = 2;
            } else if ("Right".toLowerCase().equals(string2)) {
                n = 3;
            }
            return n;
        }

        private int getLineType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementLine.getLineTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementLine.getLineTypeFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        private int getSymbolType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementSymbol.getSymbolTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementSymbol.getSymbolTypeFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        private int getFontStyle(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGUtilityText.getFontStyleName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = SGUtilityText.getFontStyle(string2);
            return n3;
        }

        private int getScaleType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGUtilityText.getScaleTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = SGUtilityText.getScaleType(string2);
            return n3;
        }

        private int getErrorBarStyle(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementErrorBar.getErrorBarStyleName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementErrorBar.getErrorBarStyleFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setLegendProperties(String string, SGILegendElement sGILegendElement, ArrayList arrayList) {
            StringBuffer stringBuffer;
            String[] stringArray = new String[]{"legendAxisX", "legendAxisY", "legendLocationX", "legendLocationY", "legendVisible", "legendFontName", "legendFontStyle", "legendFontSize", "legendFontColor", "legendFrameVisible", "legendFrameLineWidth", "legendFrameColor", "legendBackgroundTransparent", "legendBackgroundColor", "legendSymbolSpan"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (string.equals("legendAxisX")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                int n2 = this.getAxisLocation(string2);
                if (n2 == -1) {
                    return -1;
                }
                if (sGILegendElement.setAxisXDirectly(n2)) return 0;
                return -1;
            }
            if (string.equals("legendAxisY")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (sGILegendElement.setAxisYDirectly(n3)) return 0;
                return -1;
            }
            if (string.equals("legendLocationX")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string4 = (String)arrayList.get(0);
                Double d = SGUtilityText.getDouble(string4);
                if (d == null) {
                    return -1;
                }
                if (sGILegendElement.setXValueDirectly(d)) return 0;
                return -1;
            }
            if (string.equals("legendLocationY")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string5 = (String)arrayList.get(0);
                Double d = SGUtilityText.getDouble(string5);
                if (d == null) {
                    return -1;
                }
                if (sGILegendElement.setYValueDirectly(d)) return 0;
                return -1;
            }
            if (string.equals("legendVisible")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string6 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string6));
                if (bl == null) {
                    return -1;
                }
                if (sGILegendElement.setLegendVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendFontName")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string7 = (String)arrayList.get(0);
                if (sGILegendElement.setFontNameDirectly(string7)) return 0;
                return -1;
            }
            if (string.equals("legendFontStyle")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string8 = (String)arrayList.get(0);
                int n4 = this.getFontStyle(string8);
                if (n4 == -1) {
                    return -1;
                }
                if (sGILegendElement.setFontStyleDirectly(n4)) return 0;
                return -1;
            }
            if (string.equals("legendFontSize")) {
                StringBuffer stringBuffer2;
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string9 = (String)arrayList.get(0);
                Number number = this.getNumber(string9, stringBuffer2 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGILegendElement.setFontSizeDirectly(number.floatValue(), stringBuffer2.toString())) return 0;
                return -1;
            }
            if (string.equals("legendFontColor")) {
                String string10;
                String string11;
                if (arrayList.size() == 1) {
                    String string12 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string12);
                    if (color == null) {
                        return -1;
                    }
                    if (sGILegendElement.setFontColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string13 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string13, string11 = (String)arrayList.get(1), string10 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGILegendElement.setFontColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("legendFrameVisible")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string14 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string14));
                if (bl == null) {
                    return -1;
                }
                if (sGILegendElement.setFrameVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendFrameLineWidth")) {
                StringBuffer stringBuffer3;
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string15 = (String)arrayList.get(0);
                Number number = this.getNumber(string15, stringBuffer3 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGILegendElement.setFrameLineWidthDirectly(number.floatValue(), stringBuffer3.toString())) return 0;
                return -1;
            }
            if (string.equals("legendFrameColor")) {
                String string16;
                String string17;
                if (arrayList.size() == 1) {
                    String string18 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string18);
                    if (color == null) {
                        return -1;
                    }
                    if (sGILegendElement.setFrameColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string19 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string19, string17 = (String)arrayList.get(1), string16 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGILegendElement.setFrameColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("legendBackgroundTransparent")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string20 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string20));
                if (bl == null) {
                    return -1;
                }
                if (sGILegendElement.setBackgroundTransparentDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendBackgroundColor")) {
                String string21;
                String string22;
                if (arrayList.size() == 1) {
                    String string23 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string23);
                    if (color == null) {
                        return -1;
                    }
                    if (sGILegendElement.setBackgroundColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string24 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string24, string22 = (String)arrayList.get(1), string21 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGILegendElement.setBackgroundColorDirectly(color)) return 0;
                return -1;
            }
            if (!string.equals("legendSymbolSpan")) return 0;
            if (arrayList.size() < 1) {
                return -1;
            }
            String string25 = (String)arrayList.get(0);
            Number number = this.getNumber(string25, stringBuffer = new StringBuffer());
            if (number == null) {
                return -1;
            }
            if (sGILegendElement.setSymbolSpanDirectly(number.floatValue(), stringBuffer.toString())) return 0;
            return -1;
        }

        private int setLabelProperties(String string, SGIStringElement sGIStringElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"labelAxisX", "labelAxisY", "labelText", "labelLocationX", "labelLocationY", "labelFontName", "labelFontStyle", "labelFontSize", "labelFontColor", "labelAngle", "deleteLabel", "moveToFrontLabel", "moveToBackLabel"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteLabel") ? !sGIStringElement.hideChildObject(n2) : (string.equals("moveToFrontLabel") ? !sGIStringElement.moveChildObject(n2, true) : string.equals("moveToBackLabel") && !sGIStringElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("labelAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIStringElement.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("labelAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIStringElement.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("labelText")) {
                if (!sGIStringElement.setTextDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("labelLocationX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIStringElement.setLocationXDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("labelLocationY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIStringElement.setLocationYDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("labelFontName")) {
                if (!sGIStringElement.setFontNameDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("labelFontStyle")) {
                int n5 = this.getFontStyle(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGIStringElement.setFontStyleDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("labelFontSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIStringElement.setFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("labelFontColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIStringElement.setFontColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("labelAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIStringElement.setAngleDirectly(n2, f)) {
                    return -1;
                }
            }
            return 0;
        }

        private int setSigDiffProperties(String string, SGISignificantDifferenceElement sGISignificantDifferenceElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"sigdiffAxisX", "sigdiffAxisY", "sigdiffHorizontalY", "sigdiffLeftX", "sigdiffLeftY", "sigdiffRightX", "sigdiffRightY", "sigdiffLineVisible", "sigdiffSpace", "sigdiffLineWidth", "sigdiffText", "sigdiffFontName", "sigdiffFontStyle", "sigdiffFontSize", "sigdiffColor", "deleteSigdiff", "moveToFrontSigdiff", "moveToBackSigdiff"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteSigdiff") ? !sGISignificantDifferenceElement.hideChildObject(n2) : (string.equals("moveToFrontSigdiff") ? !sGISignificantDifferenceElement.moveChildObject(n2, true) : string.equals("moveToBackSigdiff") && !sGISignificantDifferenceElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("sigdiffAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("labelText")) {
                if (!sGISignificantDifferenceElement.setTextDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffHorizontalY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLocationHorizontalYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLeftX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLocationLeftXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLeftY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLocationLeftYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffRightX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLocationRightXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffRightY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLocationRightYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontName")) {
                if (!sGISignificantDifferenceElement.setFontNameDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontStyle")) {
                int n5 = this.getFontStyle(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setFontStyleDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setFontColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLineVisible")) {
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLineVisibleDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("sigdiffSpace")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setSpaceDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGISignificantDifferenceElement.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffText") && !sGISignificantDifferenceElement.setTextDirectly(n2, string3)) {
                return -1;
            }
            return 0;
        }

        private int setAxisBreakProperties(String string, SGIAxisBreakElement sGIAxisBreakElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"breakAxisX", "breakAxisY", "breakLocationX", "breakLocationY", "breakLength", "breakInterval", "breakDistortion", "breakAngle", "breakLineWidth", "breakAlignment", "breakLineColor", "breakInnerColor", "deleteBreak", "moveToFrontBreak", "moveToBackBreak"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteBreak") ? !sGIAxisBreakElement.hideChildObject(n2) : (string.equals("moveToFrontBreak") ? !sGIAxisBreakElement.moveChildObject(n2, true) : string.equals("moveToBackBreak") && !sGIAxisBreakElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("breakAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("breakAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("breakLocationX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setLocationXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("breakLocationY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setLocationYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("breakLength")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setLengthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakInterval")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setIntervalDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakDistortion")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setDistortionDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("breakAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIAxisBreakElement.setAngleDirectly(n2, f)) {
                    return -1;
                }
            } else if (string.equals("breakLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakAlignment")) {
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setAlignmentDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("breakLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setLineColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("breakInnerColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string6 = (String)arrayList.get(2);
                    String string7 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string6, string7);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIAxisBreakElement.setInnerColorDirectly(n2, color)) {
                    return -1;
                }
            }
            return 0;
        }

        private int setTimingLineProperties(String string, SGITimingLineElement sGITimingLineElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"timingLineAxis", "timingLineWidth", "timingLineType", "timingLineColor", "deleteTimingLine", "moveToFrontTimingLine", "moveToBackTimingLine"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteTimingLine") ? !sGITimingLineElement.hideChildObject(n2) : (string.equals("moveToFrontTimingLine") ? !sGITimingLineElement.moveChildObject(n2, true) : string.equals("moveToBackTimingLine") && !sGITimingLineElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("timingLineAxis")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGITimingLineElement.setAxisDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("timingLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGITimingLineElement.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("timingLineType")) {
                int n4 = this.getLineType(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGITimingLineElement.setLineTypeDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("timingLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGITimingLineElement.setColorDirectly(n2, color)) {
                    return -1;
                }
            }
            return 0;
        }

        private int setShapeProperties(String string, SGIShapeElement sGIShapeElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"shapeAxisX", "shapeAxisY", "rectangleLeftX", "rectangleRightX", "rectangleTopY", "rectangleBottomY", "rectangleEdgeLineWidth", "rectangleEdgeLineType", "rectangleEdgeLineColor", "rectangleBackgroundTransparent", "rectangleBackgroundColor", "arrowStartX", "arrowStartY", "arrowEndX", "arrowEndY", "arrowLineWidth", "arrowLineType", "arrowHeadSize", "arrowColor", "arrowStartType", "arrowEndType", "arrowOpenAngle", "arrowCloseAngle", "deleteShape", "moveToFrontShape", "moveToBackShape"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteShape") ? !sGIShapeElement.hideChildObject(n2) : (string.equals("moveToFrontShape") ? !sGIShapeElement.moveChildObject(n2, true) : string.equals("moveToBackShape") && !sGIShapeElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("shapeAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIShapeElement.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("shapeAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIShapeElement.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("rectangleLeftX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleLeftXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleRightX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleRightXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleTopY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleTopYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleBottomY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleBottomYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleEdgeLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineType")) {
                int n5 = this.getLineType(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleEdgeLineTypeDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleEdgeLineColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("rectangleBackgroundTransparent")) {
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleBackgroundTransparentDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("rectangleBackgroundColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string6 = (String)arrayList.get(2);
                    String string7 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string6, string7);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIShapeElement.setRectangleBackgroundColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("arrowStartX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowStartXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowStartY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowStartYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowEndX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowEndXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowEndY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowEndYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("arrowLineType")) {
                int n6 = this.getLineType(string3);
                if (n6 == -1) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowLineTypeDirectly(n2, n6)) {
                    return -1;
                }
            } else if (string.equals("arrowHeadSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = this.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowHeadSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("arrowColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string8 = (String)arrayList.get(2);
                    String string9 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string8, string9);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("arrowStartType")) {
                Integer n7 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                if (n7 == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowStartTypeDirectly(n2, n7)) {
                    return -1;
                }
            } else if (string.equals("arrowEndType")) {
                Integer n8 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                if (n8 == null) {
                    return -1;
                }
                if (!sGIShapeElement.setArrowEndTypeDirectly(n2, n8)) {
                    return -1;
                }
            } else if (string.equals("arrowOpenAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIShapeElement.setArrowOpenAngleDirectly(n2, f)) {
                    return -1;
                }
            } else if (string.equals("arrowCloseAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIShapeElement.setArrowCloseAngleDirectly(n2, f)) {
                    return -1;
                }
            }
            return 0;
        }

        private boolean contains(String[] stringArray, String string) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            return arrayList.contains(string);
        }

        private int setDataProperties(String string, SGIGraphElement sGIGraphElement, ArrayList arrayList) {
            String[] stringArray = new String[]{"dataAxisX", "dataAxisY", "dataVisibleInLegend", "dataName", "dataLineVisible", "dataLineWidth", "dataLineType", "dataLineColor", "dataSymbolVisible", "dataSymbolType", "dataSymbolSize", "dataSymbolBodyColor", "dataSymbolLineWidth", "dataSymbolLineColor", "dataBarVisible", "dataBarBaseline", "dataBarBodyWidth", "dataBarBodyColor", "dataBarEdgeLineWidth", "dataBarLineColor", "dataErrorBarVisible", "dataErrorBarSymbolType", "dataErrorBarSymbolSize", "dataErrorBarColor", "dataErrorBarLineWidth", "dataErrorBarStyle", "dataTickLabelVisible", "dataTickLabelFontName", "dataTickLabelFontStyle", "dataTickLabelFontSize", "dataTickLabelFontColor", "dataTickLabelHorizontal", "dataArrowMagnitudePerCM", "dataArrowDirectionInvariant", "dataArrowLineWidth", "dataArrowLineType", "dataArrowHeadSize", "dataArrowColor", "dataArrowStartType", "dataArrowEndType", "dataArrowOpenAngle", "dataArrowCloseAngle", "deleteData", "moveToFrontData", "moveToBackData"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteData") ? !sGIGraphElement.hideChildObject(n2) : (string.equals("moveToFrontData") ? !sGIGraphElement.moveChildObject(n2, true) : string.equals("moveToBackData") && !sGIGraphElement.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("dataAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIGraphElement.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("dataAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIGraphElement.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("dataVisibleInLegend")) {
                Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIGraphElement.setVisibleInLegendDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("dataName") && !sGIGraphElement.setNameDirectly(n2, string3)) {
                return -1;
            }
            if (sGIGraphElement instanceof SGISXYGraphElement) {
                SGISXYGraphElement sGISXYGraphElement = (SGISXYGraphElement)sGIGraphElement;
                if (string.equals("dataLineVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setLineVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataLineType")) {
                    int n5 = this.getLineType(string3);
                    if (n5 == -1) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setLineTypeDirectly(n2, n5)) {
                        return -1;
                    }
                } else if (string.equals("dataLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string4 = (String)arrayList.get(2);
                        String string5 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string4, string5);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolType")) {
                    int n6 = this.getSymbolType(string3);
                    if (n6 == -1) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolTypeDirectly(n2, n6)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolBodyColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string6 = (String)arrayList.get(2);
                        String string7 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string6, string7);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolInnerColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string8 = (String)arrayList.get(2);
                        String string9 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string8, string9);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setSymbolLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataBarVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataBarBaseline")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarBaselineDirectly(n2, ((Number)d).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataBarBodyWidth")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarWidthDirectly(n2, ((Number)d).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataBarEdgeLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarEdgeLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataBarBodyColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string10 = (String)arrayList.get(2);
                        String string11 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string10, string11);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarInnerColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataBarLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string12 = (String)arrayList.get(2);
                        String string13 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string12, string13);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setBarLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarSymbolType")) {
                    Integer n7 = SGDrawingElementErrorBar.getHeadTypeFromName(string3);
                    if (n7 == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarSymbolTypeDirectly(n2, n7)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarSymbolSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarSymbolSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string14 = (String)arrayList.get(2);
                        String string15 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string14, string15);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarStyle")) {
                    int n8 = this.getErrorBarStyle(string3);
                    if (n8 == -1) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setErrorBarStyleDirectly(n2, n8)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setTickLabelVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontName")) {
                    if (!sGISXYGraphElement.setTickLabelFontNameDirectly(n2, string3)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontStyle")) {
                    int n9 = this.getFontStyle(string3);
                    if (n9 == -1) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setTickLabelFontStyleDirectly(n2, n9)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setTickLabelFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string16 = (String)arrayList.get(2);
                        String string17 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string16, string17);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setTickLabelFontColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelHorizontal")) {
                    Boolean bl = SGUtilityText.getBoolean(this.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGISXYGraphElement.setTickLabelAngleDirectly(n2, bl)) {
                        return -1;
                    }
                }
            } else if (sGIGraphElement instanceof SGIVXYGraphElement) {
                SGIVXYGraphElement sGIVXYGraphElement = (SGIVXYGraphElement)sGIGraphElement;
                if (string.equals("dataArrowMagnitudePerCM")) {
                    Float f = SGUtilityText.getFloat(string3);
                    if (f == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setMagnitudePerCMDirectly(n2, ((Number)f).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowDirectionInvariant")) {
                    Boolean bl = SGUtilityText.getBoolean(string3);
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setDirectionInvariantDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowLineType")) {
                    int n10 = this.getLineType(string3);
                    if (n10 == -1) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setLineTypeDirectly(n2, n10)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowHeadSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = this.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setHeadSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string18 = (String)arrayList.get(2);
                        String string19 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string18, string19);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowStartType")) {
                    Integer n11 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                    if (n11 == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setStartTypeDirectly(n2, n11)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowEndType")) {
                    Integer n12 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                    if (n12 == null) {
                        return -1;
                    }
                    if (!sGIVXYGraphElement.setEndTypeDirectly(n2, n12)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowOpenAngle")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                    if (!sGIVXYGraphElement.setOpenAngleDirectly(n2, f)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowCloseAngle")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                    if (!sGIVXYGraphElement.setCloseAngleDirectly(n2, f)) {
                        return -1;
                    }
                }
            }
            return 0;
        }

        private String parseCommand(String string, ArrayList arrayList) {
            int n;
            int n2 = string.indexOf(40);
            if (n2 == -1 | (n = string.indexOf(41)) == -1) {
                return string;
            }
            if (n2 > n) {
                return string;
            }
            if (n2 == 0) {
                return string;
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            if (!SGUtilityText.tokenize(string3, arrayList, false)) {
                return string;
            }
            return string2;
        }

        private String getSimpleFileName(String string) {
            String string2 = SGIConstants.FILE_SEPARATOR;
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3 == null) {
                throw new Error();
            }
            String string4 = null;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, Character.toString('.'));
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (string4 == null) {
                string4 = string3;
            }
            return string4;
        }

        private String getNewDataName(SGFigure sGFigure, String string) {
            String string2 = this.getSimpleFileName(string);
            if (string2 == null) {
                return null;
            }
            List list = sGFigure.getVisibleDataList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                SGData sGData = (SGData)list.get(i);
                String string3 = sGFigure.getDataName(sGData);
                arrayList.add(string3);
            }
            string2 = SGUtilityText.getSerialName(arrayList, string2);
            return string2;
        }

        private boolean setWindowLocation(SGDrawingWindow sGDrawingWindow) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)(dimension.getWidth() - (double)sGDrawingWindow.getWidth()) / 2;
            int n2 = (int)(dimension.getHeight() - (double)sGDrawingWindow.getHeight()) / 2;
            sGDrawingWindow.setLocation(n, n2);
            return true;
        }

        public SGDrawingWindow getWindow(int n) {
            return (SGDrawingWindow)this.mWndMap.get(new Integer(n));
        }

        public int getWindowNumber() {
            return this.mWndMap.size();
        }

        private SGFigure createFigure(int n, SGDrawingWindow sGDrawingWindow, SGData sGData) {
            float f;
            float f2;
            SGXYFigure sGXYFigure = null;
            if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
                sGXYFigure = new SGSXYFigure(sGDrawingWindow);
                f2 = 15.0f;
                f = 9.0f;
            } else if (sGData instanceof SGVXYData) {
                sGXYFigure = new SGVXYFigure(sGDrawingWindow);
                f2 = 9.0f;
                f = 9.0f;
            } else {
                return null;
            }
            sGXYFigure.setVisible(false);
            sGXYFigure.setID(n);
            if (!this.createFigureElements(sGXYFigure, sGData)) {
                return null;
            }
            sGXYFigure.setFigureWidth(f2, "cm");
            sGXYFigure.setFigureHeight(f, "cm");
            return sGXYFigure;
        }

        private boolean createFigureElements(SGFigure sGFigure, SGData sGData) {
            try {
                SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                SGIAxisElement sGIAxisElement = (SGIAxisElement)this.setIElement(this.mClassOfAxisElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.15f);
                Class clazz = null;
                if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
                    clazz = this.mClassOfSXYGraphElement;
                } else if (sGData instanceof SGVXYData) {
                    clazz = this.mClassOfVXYGraphElement;
                } else {
                    return false;
                }
                SGIGraphElement sGIGraphElement = (SGIGraphElement)this.setIElement(clazz, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.2f);
                SGILegendElement sGILegendElement = (SGILegendElement)this.setIElement(this.mClassOfLegendElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.25f);
                SGIStringElement sGIStringElement = (SGIStringElement)this.setIElement(this.mClassOfStringElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.3f);
                SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)this.setIElement(this.mClassOfAxisBreakElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.35f);
                SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)this.setIElement(this.mClassOfSignificantDifferenceElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.4f);
                SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)this.setIElement(this.mClassOfTimingLineElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.45f);
                SGIGridElement sGIGridElement = (SGIGridElement)this.setIElement(this.mClassOfGridElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.5f);
                SGIShapeElement sGIShapeElement = (SGIShapeElement)this.setIElement(this.mClassOfShapeElement, sGFigure, sGDrawingWindow);
                sGDrawingWindow.setProgressValue(0.55f);
                sGFigure.setIFigureElement(10, sGIGridElement);
                sGFigure.setIFigureElement(20, sGITimingLineElement);
                sGFigure.setIFigureElement(30, sGIGraphElement);
                sGFigure.setIFigureElement(40, sGISignificantDifferenceElement);
                sGFigure.setIFigureElement(50, sGIAxisElement);
                sGFigure.setIFigureElement(60, sGIShapeElement);
                sGFigure.setIFigureElement(70, sGIAxisBreakElement);
                sGFigure.setIFigureElement(80, sGILegendElement);
                sGFigure.setIFigureElement(90, sGIStringElement);
                this.setRelationOfFigureElements(sGFigure);
                sGDrawingWindow.setProgressValue(0.6f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }

        private void setRelationOfFigureElements(SGFigure sGFigure) {
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement);
            SGIGraphElement sGIGraphElement = (SGIGraphElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
            SGILegendElement sGILegendElement = (SGILegendElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGILegendElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement);
            SGIStringElement sGIStringElement = (SGIStringElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
            SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement);
            SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement);
            SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement);
            SGIGridElement sGIGridElement = (SGIGridElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIGridElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGridElement);
            SGIShapeElement sGIShapeElement = (SGIShapeElement)sGFigure.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement = SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.base.SGIShapeElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement);
            sGIGraphElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setAxisElement(sGIAxisElement);
            sGILegendElement.setGraphElement(sGIGraphElement);
            sGIAxisBreakElement.setAxisElement(sGIAxisElement);
            sGISignificantDifferenceElement.setAxisElement(sGIAxisElement);
            sGITimingLineElement.setAxisElement(sGIAxisElement);
            sGIGridElement.setAxisElement(sGIAxisElement);
            sGIStringElement.setAxisElement(sGIAxisElement);
            sGIShapeElement.setAxisElement(sGIAxisElement);
        }

        private SGIFigureElement setIElement(Class clazz, SGFigure sGFigure, Frame frame) {
            Object var4_4 = null;
            try {
                var4_4 = clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            SGIFigureElement sGIFigureElement = var4_4;
            sGIFigureElement.setComponent(sGFigure.getComponent());
            sGIFigureElement.addActionListener(sGFigure);
            sGIFigureElement.setDialogOwner(frame);
            return sGIFigureElement;
        }

        private int createDataFromFile(String string, ArrayList arrayList, SGDrawingWindow sGDrawingWindow) throws FileNotFoundException {
            ArrayList arrayList2 = new ArrayList();
            int n = this.readFile(string, arrayList2);
            if (n != 0) {
                return n;
            }
            SGData sGData = this.mDataCreator.create(string, arrayList2);
            if (sGData == null) {
                return -1;
            }
            arrayList.add(sGData);
            return 0;
        }

        private boolean createAllWizardDialogsForDataAdditionFromToolBar(SGDrawingWindow sGDrawingWindow) {
            this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mFigureIDSelectionWizardDialog.getOKButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.getPreviousButton().setVisible(false);
            this.mFigureIDSelectionWizardDialog.pack();
            this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mSingleDataFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mSingleDataFileChooserWizardDilaog.pack();
            String string = this.getCurrentFileDirectory();
            this.mSingleDataFileChooserWizardDilaog.setFile(string, this.mCurrentDataFileName);
            this.mXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialog.getNextButton().setVisible(false);
            this.mXYDataTypeSelectionWizardDialog.pack();
            this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
            this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
            this.mSingleDataFileChooserWizardDilaog.setNext(this.mXYDataTypeSelectionWizardDialog);
            this.mXYDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
            this.mFigureIDSelectionWizardDialog.addActionListener(this);
            this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialog.addActionListener(this);
            return true;
        }

        private String getCurrentFileDirectory() {
            Object object;
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            Object object2 = preferences.get("Current Directory", null);
            boolean bl = false;
            if (object2 == null) {
                bl = true;
            } else {
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    bl = true;
                }
            }
            if (bl) {
                object = SGIConstants.USER_HOME;
                if (SGUtility.identifyOS("windows")) {
                    object = (String)object + SGIConstants.FILE_SEPARATOR + "My Documents";
                }
                this.setCurrentFileDirectory((String)object);
                object2 = object;
            }
            return object2;
        }

        private void setCurrentFileDirectory(String string) {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            preferences.put("Current Directory", string);
        }

        private boolean createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
            this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mPropertyFileChooserWizardDilaog.getPreviousButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.pack();
            this.mMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            this.mMultiDataFileChooserWizardDialog.pack();
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription("Samurai Graph Property File");
            sGExtensionFileFilter.addExtension("sgp");
            this.mPropertyFileChooserWizardDilaog.setFileFilter(sGExtensionFileFilter);
            String string = this.getCurrentFileDirectory();
            this.mPropertyFileChooserWizardDilaog.setFile(string, this.mCurrentPropertyFileName);
            this.mMultiDataFileChooserWizardDialog.setFile(string, this.mCurrentDataFileName);
            this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
            this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
            this.mPropertyFileChooserWizardDilaog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialog.addActionListener(this);
            return true;
        }

        private int readFile(String string, ArrayList arrayList) {
            Window window = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getOwner();
            ArrayList arrayList2 = new ArrayList();
            try {
                if (!this.mDataCreator.getFileTypeCandidateList(string, arrayList2)) {
                    return -1;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return -1;
            }
            if (arrayList2.size() == 0) {
                return -1;
            }
            String string2 = null;
            if (!this.mXYDataTypeSelectionWizardDialogFromCLorDD.setEffectiveDataType(arrayList2)) {
                return -1;
            }
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setCenter(window);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.setVisible(true);
            int n = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getCloseOption();
            if (n == 1) {
                return 1;
            }
            string2 = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSelectedDataType();
            if (string2 == null) {
                return -1;
            }
            arrayList.add(string2);
            if (string2.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSamplingRate();
                if (d == null) {
                    return -1;
                }
                arrayList.add(d);
            } else if (string2.equals("VXY")) {
                boolean bl = this.mXYDataTypeSelectionWizardDialogFromCLorDD.isPolarSelected();
                arrayList.add(bl);
            }
            return 0;
        }

        public SGDrawingWindow createNewWindow() {
            SGDrawingWindow sGDrawingWindow = this.createWindow();
            if (sGDrawingWindow == null) {
                return null;
            }
            sGDrawingWindow.initPropertiesHistory();
            return sGDrawingWindow;
        }

        private SGDrawingWindow createWindow() {
            int n = this.getCurrentWindowID();
            SGDrawingWindow sGDrawingWindow = this.createWindow(n);
            return sGDrawingWindow;
        }

        private SGDrawingWindow createWindow(int n) {
            String[] stringArray;
            SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
            sGDrawingWindow.setID(n);
            this.mWndMap.put(new Integer(n), sGDrawingWindow);
            sGDrawingWindow.setDefaultCloseOperation(0);
            String string = WINDOW_TITLE_PREFIX + sGDrawingWindow.getID();
            sGDrawingWindow.setTitle(string);
            sGDrawingWindow.addActionListener(this);
            sGDrawingWindow.addWindowListener(this);
            sGDrawingWindow.addPropertyChangeListener(this);
            DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
            sGDrawingWindow.setDropTarget(dropTarget);
            sGDrawingWindow.setImageFileCreator(this.mImageFileCreator);
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            String string2 = preferences.get("Tool Bar Pattern", null);
            if (string2 != null) {
                ArrayList arrayList = new ArrayList();
                if (SGUtilityText.tokenize(string2, arrayList, false)) {
                    int n2;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        String string3 = (String)arrayList.get(n2);
                        if (string3 == null) continue;
                        arrayList2.add(string3);
                    }
                    stringArray = new String[arrayList2.size()];
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        stringArray[n2] = (String)arrayList2.get(n2);
                    }
                } else {
                    stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
                }
            } else {
                stringArray = new String[]{"File", "Insert", "Zoom"};
                this.updateToolBarPatternInPreferences(stringArray);
            }
            sGDrawingWindow.setToolBarPattern(stringArray);
            sGDrawingWindow.setLocation(100, 100);
            if (!sGDrawingWindow.init()) {
                return null;
            }
            this.setPasteMenuEnabled();
            return sGDrawingWindow;
        }

        private int getCurrentWindowID() {
            int n = this.mWndMap.size() == 0 ? 1 : (Integer)this.mWndMap.lastKey() + 1;
            return n;
        }

        private int setPropertyFile(SGDrawingWindow sGDrawingWindow, Element element, Map map) {
            if (!sGDrawingWindow.readProperty(element)) {
                return 1;
            }
            int n = this.createFiguresFromPropertyFile(element, sGDrawingWindow, map);
            if (n != 0) {
                return n;
            }
            sGDrawingWindow.initPropertiesHistory();
            sGDrawingWindow.initSavedHistory();
            sGDrawingWindow.setSaved(true);
            return 0;
        }

        private Element getWindowElement(Document document) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return null;
            }
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }

        private boolean setPropertyFile(SGDrawingWindow sGDrawingWindow, Document document, Map map) {
            Element element = this.getWindowElement(document);
            int n = this.setPropertyFile(sGDrawingWindow, element, map);
            String string = null;
            if (n == 0) {
                string = "Successful completion.";
            } else if (n == 3) {
                string = "Data number shortage.";
            } else if (n == 4) {
                string = "Data number excess.";
            } else if (n == 5) {
                string = "Cannot open the selected file.";
            } else if (n == 1) {
                string = "The property file is invalid.";
            } else if (n == 2) {
                string = "The data file is invalid.";
            } else {
                throw new Error();
            }
            if (string != "Successful completion.") {
                SGUtility.showMessageDialog(null, string, "Property file", 0);
                return false;
            }
            return true;
        }

        private int createFiguresFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, Map map) {
            Set set = map.keySet();
            ArrayList arrayList = new ArrayList(map.values());
            NodeList nodeList = element.getElementsByTagName("Figure");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                ArrayList arrayList2 = (ArrayList)arrayList.get(i);
                if (arrayList2.contains("NO_DATA")) {
                    arrayList2 = new ArrayList();
                }
                if ((n2 = this.createSingleFigureFromPropertyFile(element2, sGDrawingWindow, arrayList2)) == 0) continue;
                return n2;
            }
            return 0;
        }

        private int createSingleFigureFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            int n;
            float f;
            StringBuffer stringBuffer;
            String string = null;
            Number number = null;
            Object var7_6 = null;
            Object var8_7 = null;
            string = element.getAttribute("Type");
            if (string.length() == 0) {
                return 1;
            }
            SGXYFigure sGXYFigure = null;
            if (string.equals("SXY")) {
                sGXYFigure = new SGSXYFigure(sGDrawingWindow);
            } else if (string.equals("VXY")) {
                sGXYFigure = new SGVXYFigure(sGDrawingWindow);
            } else {
                return 1;
            }
            int n2 = sGDrawingWindow.getCurrentFigureId();
            sGXYFigure.setID(n2);
            if (!sGXYFigure.readProperty(element)) {
                return 1;
            }
            if (this.createFigureElementFromPropertyFile(sGXYFigure, element) == 1) {
                return 1;
            }
            string = element.getAttribute("SpaceAxisLineAndNumber");
            if (string.length() != 0) {
                stringBuffer = new StringBuffer();
                number = SGUtilityText.getNumber(string, stringBuffer);
                if (number == null) {
                    return 1;
                }
                f = number.floatValue();
                if (!sGXYFigure.setSpaceAxisLineAndNumber(f, stringBuffer.toString())) {
                    return 1;
                }
            }
            if ((string = element.getAttribute("SpaceNumberAndTitle")).length() != 0) {
                stringBuffer = new StringBuffer();
                number = SGUtilityText.getNumber(string, stringBuffer);
                if (number == null) {
                    return 1;
                }
                f = number.floatValue();
                if (!sGXYFigure.setSpaceNumberAndTitle(f, stringBuffer.toString())) {
                    return 1;
                }
            }
            if ((n = this.createDataObjectsFromPropertyFile(element, sGXYFigure, arrayList)) != 0) {
                return n;
            }
            sGDrawingWindow.addFigure(sGXYFigure);
            sGXYFigure.initPropertiesHistory();
            return 0;
        }

        public int createFigureElementFromPropertyFile(SGFigure sGFigure, Element element) {
            Class clazz;
            NodeList nodeList = null;
            Element element2 = null;
            SGIFigureElement sGIFigureElement = null;
            SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
            Rectangle2D rectangle2D = sGFigure.getGraphRect();
            sGIFigureElement = this.setIElement(this.mClassOfAxisElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
            sGFigure.setIFigureElement(50, sGIAxisElement);
            nodeList = element.getElementsByTagName("Axes");
            element2 = (Element)nodeList.item(0);
            if (!sGIFigureElement.readProperty(element2)) {
                return 1;
            }
            nodeList = element.getElementsByTagName("Graph");
            element2 = (Element)nodeList.item(0);
            if (sGFigure instanceof SGSXYFigure) {
                clazz = this.mClassOfSXYGraphElement;
            } else if (sGFigure instanceof SGVXYFigure) {
                clazz = this.mClassOfVXYGraphElement;
            } else {
                throw new Error();
            }
            sGIFigureElement = this.setIElement(clazz, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
            sGFigure.setIFigureElement(30, sGIGraphElement);
            sGIFigureElement = this.setIElement(this.mClassOfLegendElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGILegendElement sGILegendElement = (SGILegendElement)sGIFigureElement;
            sGFigure.setIFigureElement(80, sGILegendElement);
            sGILegendElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Legend");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfStringElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIStringElement sGIStringElement = (SGIStringElement)sGIFigureElement;
            sGFigure.setIFigureElement(90, sGIStringElement);
            sGIStringElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Labels");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfAxisBreakElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)sGIFigureElement;
            sGFigure.setIFigureElement(70, sGIAxisBreakElement);
            sGIAxisBreakElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("AxisBreakSymbols");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfSignificantDifferenceElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)sGIFigureElement;
            sGFigure.setIFigureElement(40, sGISignificantDifferenceElement);
            sGISignificantDifferenceElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("SignificantDifferenceSymbols");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfTimingLineElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)sGIFigureElement;
            sGFigure.setIFigureElement(20, sGITimingLineElement);
            sGITimingLineElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("TimingLines");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfGridElement, sGFigure, sGDrawingWindow);
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            SGIGridElement sGIGridElement = (SGIGridElement)sGIFigureElement;
            sGFigure.setIFigureElement(10, sGIGridElement);
            sGIGridElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Grid");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            sGIFigureElement = this.setIElement(this.mClassOfShapeElement, sGFigure, sGDrawingWindow);
            SGIShapeElement sGIShapeElement = (SGIShapeElement)sGIFigureElement;
            if (sGIFigureElement == null) {
                return 1;
            }
            sGIFigureElement.setGraphRect(rectangle2D);
            sGFigure.setIFigureElement(60, sGIShapeElement);
            sGIShapeElement.setAxisElement(sGIAxisElement);
            nodeList = element.getElementsByTagName("Shape");
            if (nodeList.getLength() != 0 && !sGIFigureElement.readProperty(element2 = (Element)nodeList.item(0))) {
                return 1;
            }
            this.setRelationOfFigureElements(sGFigure);
            return 0;
        }

        private int createDataObjectsFromPropertyFile(Element element, SGFigure sGFigure, ArrayList arrayList) {
            NodeList nodeList = element.getElementsByTagName("Data");
            if (nodeList.getLength() != arrayList.size()) {
                return 1;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Element element2;
                block35: {
                    Object object2;
                    Object object3;
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    element2 = (Element)node;
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    String string = element2.getAttribute("Type");
                    if (string == null) {
                        return 1;
                    }
                    arrayList2.add(string);
                    String string2 = null;
                    if (string.equals("SXY")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYData).getName();
                    } else if (string.equals("VXY")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGVXYData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGVXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGVXYData).getName();
                        object3 = element2.getAttribute("Polar");
                        if (((String)object3).length() == 0) {
                            return 1;
                        }
                        object = SGUtilityText.getBoolean((String)object3);
                        if (object == null) {
                            return 1;
                        }
                        arrayList2.add(object);
                    } else if (string.equals("SXY_MULTIPLE")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData).getName();
                    } else if (string.equals("SXY_SAMPLING")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData).getName();
                        object3 = element2.getAttribute("SamplingRate");
                        if (((String)object3).length() == 0) {
                            return 1;
                        }
                        object = SGUtilityText.getDouble((String)object3);
                        if (object == null) {
                            return 1;
                        }
                        arrayList2.add(object);
                    } else if (string.equals("SXY_DATE")) {
                        string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData == null ? SGDrawingServer.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYDateData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData).getName();
                    } else {
                        return 1;
                    }
                    object3 = null;
                    try {
                        object3 = Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return 1;
                    }
                    if (object3 == null) {
                        return 1;
                    }
                    object = null;
                    try {
                        object = (SGData)((Class)object3).newInstance();
                    }
                    catch (Exception exception) {
                        return 1;
                    }
                    if (object == null) {
                        return 1;
                    }
                    if (arrayList.size() == 0) {
                        return 3;
                    }
                    Object e = arrayList.get(i);
                    if (e instanceof String) {
                        object2 = (String)e;
                        ArrayList arrayList3 = new ArrayList();
                        SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                        try {
                            if (!this.mDataCreator.getFileTypeCandidateList((String)object2, arrayList3)) {
                                return 2;
                            }
                            if (arrayList3.size() == 0 || !arrayList3.contains(string)) {
                                return 2;
                            }
                            SGData sGData = this.mDataCreator.create((String)object2, arrayList2);
                            if (sGData == null) {
                                return 2;
                            }
                            if (!((SGData)object).setData(sGData)) {
                                return 2;
                            }
                            break block35;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return 5;
                        }
                    }
                    if (e instanceof SGData) {
                        object2 = (SGData)e;
                        if (!((SGData)object).setData((SGData)object2)) {
                            return 1;
                        }
                    } else {
                        return 1;
                    }
                }
                if (sGFigure.createDataObjectFromPropertyFile(element2, (SGData)object)) continue;
                return 1;
            }
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                sGIFigureElementArray[i].initPropertiesHistory();
            }
            return 0;
        }

        private boolean actionFromWindow(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            if (string.equals("Create New Window")) {
                SGDrawingWindow sGDrawingWindow2 = this.createNewWindow();
                if (sGDrawingWindow2 == null) {
                    return false;
                }
                sGDrawingWindow2.setVisible(true);
            } else if (string.equals("Close Window")) {
                this.closeWindow(sGDrawingWindow);
            } else if (string.equals("Exit")) {
                this.exit();
            } else if (string.equals("Draw Graph")) {
                this.createAllWizardDialogsForDataAdditionFromToolBar(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setCenter(sGDrawingWindow);
                this.mFigureIDSelectionWizardDialog.setVisible(true);
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 0);
                }
            } else if (string.equals("Save Property")) {
                int n = this.saveProperties(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Property")) {
                int n;
                if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (n = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    return true;
                }
                this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setCenter(sGDrawingWindow);
                this.mPropertyFileChooserWizardDilaog.setVisible(true);
                File file = this.mPropertyFileChooserWizardDilaog.getSelectedFile();
                File file2 = this.mMultiDataFileChooserWizardDialog.getSelectedFile();
                long l = this.mPropertyFileChooserWizardDilaog.lastUsed();
                long l2 = this.mMultiDataFileChooserWizardDialog.lastUsed();
                if (file != null & file2 != null) {
                    if (l < l2) {
                        this.updateCurrentFile(file2, 0);
                    } else {
                        this.updateCurrentFile(file, 1);
                    }
                } else if (file != null) {
                    this.updateCurrentFile(file, 1);
                } else if (file2 != null) {
                    this.updateCurrentFile(file2, 0);
                }
            } else if (string.equals("Save Data Set")) {
                int n = this.saveDataSet(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Data Set")) {
                int n;
                if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (n = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    return true;
                }
                n = this.loadDataSet(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Background Image")) {
                String string2;
                SGFileChooser sGFileChooser = new SGFileChooser();
                SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
                sGExtensionFileFilter.setDescription("Image File");
                String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
                for (int i = 0; i < stringArray.length; ++i) {
                    sGExtensionFileFilter.addExtension(stringArray[i]);
                }
                sGFileChooser.setFileFilter(sGExtensionFileFilter);
                String string3 = string2 = this.getCurrentFileDirectory();
                if (this.mCurrentImageFileName != null) {
                    string3 = string3 + SGIConstants.FILE_SEPARATOR + this.mCurrentImageFileName;
                }
                ((JFileChooser)sGFileChooser).setSelectedFile(new File(string3));
                int n = sGFileChooser.showOpenDialog(sGDrawingWindow);
                File file = null;
                if (n == 0) {
                    file = sGFileChooser.getSelectedFile();
                }
                if (file != null) {
                    this.updateCurrentFile(file, 2);
                    if (!this.setImage(file, sGDrawingWindow)) {
                        return false;
                    }
                }
            } else if (string.equals("Cut")) {
                this.cutAndCopy(sGDrawingWindow, false);
            } else if (string.equals("Copy")) {
                this.cutAndCopy(sGDrawingWindow, true);
            } else if (string.equals("Paste")) {
                this.pasteToWindow(sGDrawingWindow);
            } else if (string.equals("Duplicate")) {
                if (!this.duplicateFocusedFigures(sGDrawingWindow)) {
                    return false;
                }
            } else if (string.equals("Export as Image")) {
                this.mImageFileCreator.setBaseDirectory(this.getCurrentFileDirectory());
                sGDrawingWindow.exportAsImage(false);
                this.setCurrentFileDirectory(this.mImageFileCreator.getBaseDirectory());
            } else if (string.equals("Print")) {
                sGDrawingWindow.printImage(false);
            } else if (string.equals("Upgrade")) {
                this.mUpgradeManager.showUpgradeDialog(sGDrawingWindow);
            } else {
                if (string.equals("Change Log")) {
                    return this.showChangeLogDialog(sGDrawingWindow);
                }
                if (string.equals("Proxy")) {
                    return this.mProxyManager.showProxySettingDialog(sGDrawingWindow);
                }
                if (string.equals("About")) {
                    this.showAboutDialog(sGDrawingWindow);
                }
            }
            return true;
        }

        private int saveProperties(SGDrawingWindow sGDrawingWindow) {
            return this.saveProperties(sGDrawingWindow, this.getCurrentFileDirectory(), this.mCurrentPropertyFileName);
        }

        private int saveProperties(SGDrawingWindow sGDrawingWindow, String string, String string2) {
            this.mPropertyFileCreator.setFile(string, string2);
            int n = this.mPropertyFileCreator.create(sGDrawingWindow);
            if (n != 0) {
                return n;
            }
            File file = this.mPropertyFileCreator.getSelectedFile();
            if (file != null) {
                this.updateCurrentFile(file, 1);
            }
            return 0;
        }

        private int saveProperties(SGDrawingWindow sGDrawingWindow, String string) {
            int n = this.mPropertyFileCreator.create(sGDrawingWindow, string);
            if (n != 0) {
                return n;
            }
            return 0;
        }

        private int saveDataSet(SGDrawingWindow sGDrawingWindow) {
            return this.saveDataSet(sGDrawingWindow, this.getCurrentFileDirectory(), this.mCurrentArchiveFileName);
        }

        private ArrayList dumpDataSet(SGDrawingWindow sGDrawingWindow, File file) {
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = file.getPath() + SGIConstants.FILE_SEPARATOR + DATASET_PROPERTY_FILENAME;
            int n = this.saveProperties(sGDrawingWindow, string);
            if (n != 0) {
                return null;
            }
            arrayList.add(new File(string));
            ArrayList arrayList2 = sGDrawingWindow.getVisibleFigureList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList2.get(i);
                List list = sGFigure.getVisibleDataList();
                for (int j = 0; j < list.size(); ++j) {
                    String string2;
                    File file2;
                    SGData sGData = (SGData)list.get(j);
                    if (!sGData.saveData(file2 = new File(string2 = file.getPath() + SGIConstants.FILE_SEPARATOR + "id" + i + "-" + j + ".csv"))) {
                        for (int k = 0; k < arrayList.size(); ++k) {
                            File file3 = (File)arrayList.get(k);
                            file3.delete();
                        }
                        return null;
                    }
                    arrayList.add(file2);
                }
            }
            return arrayList;
        }

        private int saveDataSet(SGDrawingWindow sGDrawingWindow, String string, String string2) {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                return -1;
            }
            ArrayList arrayList = this.dumpDataSet(sGDrawingWindow, file);
            if (arrayList == null) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                file.delete();
                return -1;
            }
            this.mArchiveFileCreator.setFile(string, string2);
            int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath());
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = (File)arrayList.get(i);
                file2.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            File file3 = this.mArchiveFileCreator.getSelectedFile();
            if (file3 != null) {
                this.updateCurrentFile(file3, 3);
            }
            return 0;
        }

        private int saveDataSet(SGDrawingWindow sGDrawingWindow, String string) {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                return -1;
            }
            ArrayList arrayList = this.dumpDataSet(sGDrawingWindow, file);
            if (arrayList == null) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                file.delete();
                return -1;
            }
            int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath(), string);
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = (File)arrayList.get(i);
                file2.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            File file3 = this.mArchiveFileCreator.getSelectedFile();
            if (file3 != null) {
                this.updateCurrentFile(file3, 3);
            }
            return 0;
        }

        private int loadDataSet(SGDrawingWindow sGDrawingWindow) {
            ArrayList arrayList = new ArrayList();
            String string = MSG_LOAD_DATASET_FAILED;
            File file = this.createTemporaryDirectory(sGDrawingWindow);
            if (file == null) {
                return -1;
            }
            int n = this.mArchiveFileExtractor.extract(sGDrawingWindow, file.getPath());
            ArrayList arrayList2 = this.mArchiveFileExtractor.getExtractedFileList();
            if (n != 0) {
                this.mArchiveFileExtractor.deleteExtractedFiles();
                file.delete();
                return n;
            }
            n = this.afterExtracted(sGDrawingWindow, file, arrayList2);
            return n;
        }

        private int loadDataSet(SGDrawingWindow sGDrawingWindow, String string, ArrayList arrayList) {
            Object object;
            File file = new File(string);
            if (!file.exists()) {
                return -1;
            }
            String string2 = SGUtility.getCanonicalPath(file.getPath());
            if (string2 == null) {
                return -1;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return -1;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                return -1;
            }
            Element element = this.getWindowElement(document);
            NodeList nodeList = element.getElementsByTagName("Figure");
            int n = nodeList.getLength();
            int n2 = 0;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) {
                    return -1;
                }
                Element element2 = (Element)node;
                object = element2.getElementsByTagName("Data");
                nArray[i] = object.getLength();
                n2 += nArray[i];
            }
            if (n2 != arrayList.size()) {
                return -1;
            }
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                object = new ArrayList();
                for (int j = 0; j < n3; ++j) {
                    ((ArrayList)object).add(arrayList.get(n2 + j));
                }
                treeMap.put(new Integer(i), object);
                n2 += n3;
            }
            sGDrawingWindow.clearUndoBuffer();
            sGDrawingWindow.removeAllFigures();
            sGDrawingWindow.updateClientRect();
            if (!this.setPropertyFile(sGDrawingWindow, document, treeMap)) {
                return -1;
            }
            return 0;
        }

        private int loadDataSet(SGDrawingWindow sGDrawingWindow, File file) {
            File file2 = this.createTemporaryDirectory(sGDrawingWindow);
            if (file2 == null) {
                return -1;
            }
            int n = this.mArchiveFileExtractor.extract(sGDrawingWindow, file2.getPath(), file);
            ArrayList arrayList = this.mArchiveFileExtractor.getExtractedFileList();
            if (n != 0) {
                this.mArchiveFileExtractor.deleteExtractedFiles();
                file2.delete();
                return n;
            }
            n = this.afterExtracted(sGDrawingWindow, file2, arrayList);
            return n;
        }

        private int afterExtracted(SGDrawingWindow sGDrawingWindow, File file, ArrayList arrayList) {
            String string = file.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + DATASET_PROPERTY_FILENAME;
            if (!arrayList.contains(new File(string))) {
                this.mArchiveFileExtractor.deleteExtractedFiles();
                file.delete();
                return -1;
            }
            ArrayList arrayList2 = new ArrayList();
            this.sortDataList(file, arrayList, arrayList2);
            int n = this.loadDataSet(sGDrawingWindow, string, arrayList2);
            this.mArchiveFileExtractor.deleteExtractedFiles();
            file.delete();
            File file2 = this.mArchiveFileCreator.getSelectedFile();
            if (file2 != null) {
                this.updateCurrentFile(file2, 3);
            }
            return n;
        }

        private File createTemporaryDirectory(Component component) {
            String string = MSG_LOAD_DATASET_FAILED;
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(component, string);
                return null;
            }
            return file;
        }

        private void sortDataList(File file, ArrayList arrayList, ArrayList arrayList2) {
            int n = 0;
            int n2 = 0;
            while (true) {
                String string;
                n = 0;
                while (arrayList.contains(new File(string = file.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + "id" + n2 + "-" + n + ".csv"))) {
                    arrayList2.add(string);
                    ++n;
                }
                if (n == 0) break;
                ++n2;
            }
        }

        private boolean cutAndCopy(SGDrawingWindow sGDrawingWindow, boolean bl) {
            this.mCopiedObjectsBuffer.clear();
            this.mCopiedDataObjectBuffer.clear();
            this.mCopiedDataNameBuffer.clear();
            this.mCopiedDataPropertiesBuffer.clear();
            ArrayList arrayList = sGDrawingWindow.getCopiedObjectsList();
            this.mCopiedObjectsBuffer.addAll(arrayList);
            ArrayList arrayList2 = sGDrawingWindow.getCopiedObjectsDataList();
            this.mCopiedDataObjectBuffer.addAll(arrayList2);
            ArrayList arrayList3 = sGDrawingWindow.getCopiedDataNameList();
            this.mCopiedDataNameBuffer.addAll(arrayList3);
            ArrayList arrayList4 = sGDrawingWindow.getCopiedDataPropertiesMapList();
            this.mCopiedDataPropertiesBuffer.addAll(arrayList4);
            WindowInfo windowInfo = new WindowInfo();
            if (bl ? !this.copyFigures(sGDrawingWindow, windowInfo) : !this.cutFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            this.mWindowInfo = windowInfo;
            this.setPasteMenuEnabled();
            return true;
        }

        private void setPasteMenuEnabled() {
            int n;
            Object object;
            boolean bl = this.mCopiedObjectsBuffer.size() != 0;
            boolean bl2 = this.mCopiedDataObjectBuffer.size() != 0;
            boolean bl3 = false;
            if (this.mWindowInfo != null) {
                Document document = this.mWindowInfo.mDocument;
                object = document.getElementsByTagName("Figure");
                n = object.getLength();
                bl3 = n != 0;
            }
            boolean bl4 = bl | bl2 | bl3;
            object = new ArrayList(this.mWndMap.values());
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)((ArrayList)object).get(n);
                sGDrawingWindow.setPasteMenuEnabled(bl4);
            }
        }

        private boolean pasteToWindow(SGDrawingWindow sGDrawingWindow) {
            sGDrawingWindow.pasteToFigures(this.mCopiedObjectsBuffer, this.mCopiedDataObjectBuffer, this.mCopiedDataNameBuffer, this.mCopiedDataPropertiesBuffer);
            WindowInfo windowInfo = this.mWindowInfo;
            if (windowInfo == null) {
                return false;
            }
            Map map = windowInfo.mDataListMap;
            Element element = windowInfo.mDocument.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            int n = sGDrawingWindow.getFigureList().size();
            int n2 = this.createFiguresFromPropertyFile(element2, sGDrawingWindow, map);
            if (n2 != 0) {
                return false;
            }
            int n3 = sGDrawingWindow.getFigureList().size();
            sGDrawingWindow.setChanged(n != n3);
            return true;
        }

        private void showAboutDialog(SGDrawingWindow sGDrawingWindow) {
            SGAboutDialog sGAboutDialog = new SGAboutDialog((Frame)sGDrawingWindow, true, ApplicationProperties.VERSION);
            int n = sGAboutDialog.getWidth();
            int n2 = sGAboutDialog.getHeight();
            int n3 = sGDrawingWindow.getX() + sGDrawingWindow.getWidth() / 2 - n / 2;
            int n4 = sGDrawingWindow.getY() + sGDrawingWindow.getHeight() / 2 - n2 / 2;
            sGAboutDialog.setLocation(n3, n4);
            sGAboutDialog.setVisible(true);
            sGAboutDialog.dispose();
        }

        private boolean duplicateFocusedFigures(SGDrawingWindow sGDrawingWindow) {
            Object object;
            Object object2;
            sGDrawingWindow.initProgressValue();
            DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
            if (dOMImplementation == null) {
                return false;
            }
            Document document = dOMImplementation.createDocument("", TAG_NAME_FOCUSED_FIGURES, null);
            if (!sGDrawingWindow.createDOMTree(document, 3)) {
                return false;
            }
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            ArrayList arrayList = sGDrawingWindow.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (SGFigure)arrayList.get(i);
                object = new ArrayList(((SGFigure)object2).getVisibleDataList());
                object = (ArrayList)((ArrayList)object).clone();
                treeMap.put(Integer.toString(((SGFigure)object2).getID()), object);
            }
            Element element = document.getDocumentElement();
            object2 = element.getElementsByTagName("Window");
            if (object2.getLength() == 0) {
                return false;
            }
            object = (Element)object2.item(0);
            int n = sGDrawingWindow.getFigureList().size();
            int n2 = this.createFiguresFromPropertyFile((Element)object, sGDrawingWindow, treeMap);
            if (n2 != 0) {
                return false;
            }
            int n3 = sGDrawingWindow.getFigureList().size();
            sGDrawingWindow.setChanged(n != n3);
            sGDrawingWindow.initProgressValue();
            return true;
        }

        private boolean cutFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            if (!this.copyFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            if (windowInfo.mDataListMap.size() != 0) {
                sGDrawingWindow.hideSelectedObjects();
            }
            return true;
        }

        private boolean copyFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
            if (dOMImplementation == null) {
                return false;
            }
            Document document = dOMImplementation.createDocument("", TAG_NAME_FOCUSED_FIGURES, null);
            if (!sGDrawingWindow.createDOMTree(document, 3)) {
                return false;
            }
            TreeMap<String, ArrayList> treeMap = new TreeMap<String, ArrayList>();
            ArrayList arrayList = sGDrawingWindow.getCopiedFiguresList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                ArrayList arrayList2 = new ArrayList(sGFigure.getVisibleDataList());
                arrayList2 = (ArrayList)arrayList2.clone();
                String string = Integer.toString(sGFigure.getID());
                treeMap.put(string, arrayList2);
            }
            windowInfo.mDocument = document;
            windowInfo.mDataListMap = treeMap;
            return true;
        }

        private Document createChangeLogDocument() {
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource("/resources/ChangeLog.xml");
            if (uRL == null) {
                return null;
            }
            Document document = SGUtilityText.getDocument(uRL.toString());
            return document;
        }

        private boolean showChangeLogDialog(Frame frame) {
            SGChangeLogDialog sGChangeLogDialog = new SGChangeLogDialog(frame, true);
            sGChangeLogDialog.addActionListener(this);
            sGChangeLogDialog.setCenter(frame);
            String string = "Change Log of Samurai Graph.";
            sGChangeLogDialog.setMessage(string);
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource("/resources/ChangeLog.html");
            if (uRL == null) {
                JOptionPane.showMessageDialog(frame, "Failed to get log information.");
                return false;
            }
            sGChangeLogDialog.setPage(uRL);
            sGChangeLogDialog.pack();
            sGChangeLogDialog.setVisible(true);
            sGChangeLogDialog.dispose();
            return true;
        }

        private boolean fromCLorDDWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            return true;
        }

        private boolean addDataByToolBar(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getPrevious();
            SGWizardDialog sGWizardDialog3 = sGWizardDialog.getNext();
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
                return true;
            }
            if (string.equals("<Prev")) {
                sGWizardDialog.showPrevious();
                return true;
            }
            if (object.equals(this.mFigureIDSelectionWizardDialog)) {
                if (string.equals("Next>")) {
                    sGWizardDialog.showNext();
                }
            } else if (object.equals(this.mSingleDataFileChooserWizardDilaog)) {
                if (string.equals("Next>")) {
                    File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFileFromTextField();
                    if (!file.exists()) {
                        SGUtility.showFileNotFoundMessageDialog(this.mSingleDataFileChooserWizardDilaog);
                        return false;
                    }
                    String string2 = file.getPath();
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    try {
                        if (!this.mDataCreator.getFileTypeCandidateList(string2, arrayList2)) {
                            Utility.showDataFileInvalidMessageDialog(window);
                            return false;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        SGUtility.showFileNotFoundMessageDialog(window);
                        return false;
                    }
                    if (arrayList2.size() == 0) {
                        Utility.showDataFileInvalidMessageDialog(window);
                        return false;
                    }
                    if (!this.mXYDataTypeSelectionWizardDialog.setEffectiveDataType(arrayList2)) {
                        Utility.showDataFileInvalidMessageDialog(window);
                        return false;
                    }
                    this.mSingleDataFileChooserWizardDilaog.setSelectedFile(file);
                    sGWizardDialog.showNext();
                }
            } else if (object.equals(this.mXYDataTypeSelectionWizardDialog) && string.equals("OK")) {
                sGWizardDialog.setVisible(false);
                SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
                int n = this.mFigureIDSelectionWizardDialog.getFigureID();
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
                String string3 = file.getPath();
                String string4 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
                if (string4 == null) {
                    SGUtility.showMessageDialog(window, "Failed to get the data type.", "Error", 2);
                    return false;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string4);
                if (string4.equals("SXY_SAMPLING")) {
                    Double d = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                    if (d == null) {
                        return false;
                    }
                    arrayList.add(d);
                } else if (string4.equals("VXY")) {
                    boolean bl = this.mXYDataTypeSelectionWizardDialog.isPolarSelected();
                    arrayList.add(bl);
                }
                if (!this.drawGraph(sGDrawingWindow, n, arrayList, string3, true)) {
                    return false;
                }
            }
            return true;
        }

        private boolean drawGraph(SGDrawingWindow sGDrawingWindow, int n, ArrayList arrayList, String string, boolean bl) {
            boolean bl2;
            SGData sGData;
            if (sGDrawingWindow == null | arrayList == null | string == null) {
                throw new IllegalArgumentException("wnd==null | infoList==null | pathName==null");
            }
            if (arrayList.size() == 0) {
                return false;
            }
            SGFigure sGFigure = sGDrawingWindow.getFigure(n);
            try {
                sGData = this.mDataCreator.create(string, arrayList);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
                }
                return false;
            }
            if (sGData == null) {
                if (bl) {
                    SGUtility.showMessageDialog(sGDrawingWindow, "Failed to create a data object.", "Error", 2);
                }
                return false;
            }
            boolean bl3 = bl2 = sGFigure == null;
            if (sGFigure != null && !sGFigure.isVisible()) {
                bl2 = true;
            }
            if (bl2) {
                String string2 = this.getSimpleFileName(string);
                if (string2 == null) {
                    return false;
                }
                if (this.createNewFigure(sGDrawingWindow, n, sGData, new Point(), string2) == null) {
                    sGDrawingWindow.initProgressValue();
                    return false;
                }
            } else {
                String string3 = this.getNewDataName(sGFigure, string);
                if (string3 == null) {
                    return false;
                }
                if (!this.addData(sGData, string3, sGFigure)) {
                    if (bl) {
                        Utility.showDataFileInvalidMessageDialog(sGDrawingWindow);
                    }
                    return false;
                }
            }
            sGDrawingWindow.repaint();
            return true;
        }

        private boolean getDataInfoFromPropertyFile(Document document, ArrayList arrayList, ArrayList arrayList2) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Figure");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                NodeList nodeList3 = element3.getElementsByTagName("Data");
                int n = nodeList3.getLength();
                if (n == 0) {
                    arrayList.add(null);
                    arrayList2.add(null);
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    Node node2 = nodeList3.item(j);
                    if (!(node2 instanceof Element)) continue;
                    Element element4 = (Element)node2;
                    String string = element4.getAttribute("Name");
                    arrayList.add(string);
                    String string2 = element4.getAttribute("Type");
                    arrayList2.add(string2);
                }
            }
            return true;
        }

        private boolean loadProperty(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            if (object instanceof SGPropertyFileChooserWizardDialog) {
                SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
                File file = sGPropertyFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 1);
                    this.mMultiDataFileChooserWizardDialog.setFile(this.getCurrentFileDirectory(), this.mCurrentDataFileName);
                }
                if (!this.fromPropertyFileChooserDialog(actionEvent, sGWizardDialog)) {
                    return false;
                }
            } else if (object instanceof SGMultiDataFileChooserWizardDialog) {
                SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
                File file = sGMultiDataFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    this.updateCurrentFile(file, 0);
                    if (object.equals(this.mMultiDataFileChooserWizardDialog)) {
                        this.mPropertyFileChooserWizardDilaog.setFile(this.getCurrentFileDirectory(), this.mCurrentPropertyFileName);
                    }
                }
                if (!this.fromMultiDataFileChooser(actionEvent)) {
                    return false;
                }
            }
            if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            } else if (string.equals("<Prev")) {
                sGWizardDialog.showPrevious();
            }
            return true;
        }

        private void updateCurrentFile(File file, int n) {
            String string = file.getPath();
            String string2 = file.getParent();
            this.setCurrentFileDirectory(string2);
            String string3 = string.substring(string2.length() + 1);
            if (n == 0) {
                this.mCurrentDataFileName = string3;
            } else if (n == 1) {
                this.mCurrentPropertyFileName = string3;
            } else if (n == 2) {
                this.mCurrentImageFileName = string3;
            } else if (n == 3) {
                this.mCurrentArchiveFileName = string3;
            }
        }

        private boolean fromPropertyFileChooserDialog(ActionEvent actionEvent, SGWizardDialog sGWizardDialog) {
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getNext();
            if (!(sGWizardDialog instanceof SGPropertyFileChooserWizardDialog)) {
                return false;
            }
            if (!(sGWizardDialog2 instanceof SGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog2;
            return !string.equals("Next>") || this.fromPropertyFileChooserDialogNext(sGPropertyFileChooserWizardDialog, sGMultiDataFileChooserWizardDialog);
        }

        private boolean fromPropertyFileChooserDialogNext(SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            File file = sGPropertyFileChooserWizardDialog.getSelectedFileFromTextField();
            if (!file.exists()) {
                SGUtility.showFileNotFoundMessageDialog(sGPropertyFileChooserWizardDialog);
                return false;
            }
            sGPropertyFileChooserWizardDialog.setSelectedFile(file);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, sGPropertyFileChooserWizardDialog, arrayList, arrayList2, arrayList3)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList.size());
            if (!this.setMultiDataFileChooser(arrayList, arrayList2, arrayList3, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            sGPropertyFileChooserWizardDialog.showNext();
            return true;
        }

        private boolean getInfoFromPropertyFile(File file, Component component, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
            String string = SGUtility.getCanonicalPath(file.getPath());
            if (string == null) {
                SGUtility.showMessageDialog(component, "Cannot open the selected file.", "File open failure", 0);
                return false;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            this.mPropertyFileDocument = document;
            NodeList nodeList = document.getElementsByTagName("Figure");
            if (nodeList.getLength() == 0) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("Data");
                int n2 = i + 1;
                int n3 = nodeList2.getLength();
                if (n3 == 0) {
                    arrayList.add(new Integer(n2));
                    continue;
                }
                for (int j = 0; j < n3; ++j) {
                    arrayList.add(new Integer(n2));
                }
            }
            if (!this.getDataInfoFromPropertyFile(document, arrayList2, arrayList3)) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            if (arrayList3.size() != arrayList.size()) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            return true;
        }

        private boolean setMultiDataFileChooser(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            int n = arrayList3.size();
            sGMultiDataFileChooserWizardDialog.setFileNumber(n);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Integer)arrayList.get(i)).toString();
            }
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList2.get(i);
                if (object == null) {
                    object = "NO_DATA";
                    arrayList4.add(new Integer(i));
                }
                stringArray2[i] = (String)object;
            }
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList3.get(i);
                if (arrayList4.contains(new Integer(i))) {
                    object = "NO_DATA";
                }
                stringArray3[i] = (String)object;
            }
            String[] stringArray4 = new String[n];
            for (int i = 0; i < n; ++i) {
                if (!arrayList4.contains(new Integer(i))) continue;
                stringArray4[i] = "NO_DATA";
            }
            sGMultiDataFileChooserWizardDialog.setFigureIDArray(stringArray);
            sGMultiDataFileChooserWizardDialog.setDataNameArray(stringArray2);
            sGMultiDataFileChooserWizardDialog.setDataTypeArray(stringArray3);
            sGMultiDataFileChooserWizardDialog.setFileNameArray(stringArray4);
            return true;
        }

        private boolean fromMultiDataFileChooser(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
            Window window = sGWizardDialog.getOwner();
            if (string.equals("OK")) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)window;
                sGDrawingWindow.deleteImage();
                sGDrawingWindow.clearUndoBuffer();
                sGDrawingWindow.removeAllFigures();
                sGDrawingWindow.updateClientRect();
                TreeMap treeMap = sGMultiDataFileChooserWizardDialog.getSelectedFilePathListMap();
                if (!this.setPropertyFile(sGDrawingWindow, this.mPropertyFileDocument, (Map)treeMap)) {
                    return false;
                }
                sGDrawingWindow.updateClientRect();
                sGWizardDialog.setVisible(false);
            } else if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            }
            return true;
        }

        private boolean actionFromWizardDialog(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            if (object.equals(this.mXYDataTypeSelectionWizardDialogFromCLorDD)) {
                return this.fromCLorDDWizardDialog(actionEvent);
            }
            if (object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mXYDataTypeSelectionWizardDialog)) {
                return this.addDataByToolBar(actionEvent);
            }
            if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog) || object.equals(this.mMultiDataFileChooserWizardDialogDD)) {
                return this.loadProperty(actionEvent);
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object instanceof SGDrawingWindow) {
                this.actionFromWindow(actionEvent);
            } else if (object instanceof SGWizardDialog) {
                this.actionFromWizardDialog(actionEvent);
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof SGDrawingWindow) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
                this.closeWindow(sGDrawingWindow);
            }
        }

        private int confirmBeforeClosing(SGDrawingWindow sGDrawingWindow) {
            Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
            return this.showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
        }

        private int confirmBeforeDiscard(SGDrawingWindow sGDrawingWindow) {
            Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
            return this.showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
        }

        private int showConfirmationDialog(SGDrawingWindow sGDrawingWindow, Object[] objectArray, Object object) {
            Toolkit.getDefaultToolkit().beep();
            int n = JOptionPane.showOptionDialog(sGDrawingWindow, object, "Confirmation", 1, 2, null, objectArray, objectArray[2]);
            return n;
        }

        public void closeWindow(int n) {
            SGDrawingWindow sGDrawingWindow = this.getWindow(n);
            if (sGDrawingWindow == null) {
                return;
            }
            this.closeWindow(sGDrawingWindow);
        }

        public int closeWindow(SGDrawingWindow sGDrawingWindow) {
            if (this.needsConfirmationBeforeDiscard(sGDrawingWindow)) {
                int n = this.confirmBeforeClosing(sGDrawingWindow);
                if (n == 0) {
                    this.removeWindow(sGDrawingWindow);
                } else {
                    if (n == 1 | n == -1) {
                        return 1;
                    }
                    if (n == 2) {
                        int n2 = this.saveProperties(sGDrawingWindow);
                        if (n2 == 0) {
                            this.removeWindow(sGDrawingWindow);
                        }
                        return n2;
                    }
                }
            } else {
                this.removeWindow(sGDrawingWindow);
            }
            return 0;
        }

        public void exit() {
            SGDrawingWindow sGDrawingWindow;
            int n;
            ArrayList arrayList = new ArrayList(this.mWndMap.values());
            for (int i = arrayList.size() - 1; i >= 0 && (n = this.closeWindow(sGDrawingWindow = (SGDrawingWindow)arrayList.get(i))) != 1; --i) {
            }
        }

        private void exitApplication(int n) {
            if (n != 0) {
                String string = "A fatal error has occured.\nThe current application will be terminated.";
                String string2 = " Forced termination";
                SGUtility.showMessageDialog(null, string, string2, 0);
            }
            System.exit(n);
        }

        private boolean removeWindow(SGDrawingWindow sGDrawingWindow) {
            int n = sGDrawingWindow.getID();
            this.mWndMap.remove(new Integer(n));
            sGDrawingWindow.removeWindowListener(this);
            sGDrawingWindow.removeActionListener(this);
            sGDrawingWindow.setVisible(false);
            sGDrawingWindow.dispose();
            System.gc();
            if (this.mWndMap.size() == 0) {
                this.exitApplication(0);
            }
            return true;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            dropTargetDropEvent.acceptDrop(3);
            try {
                if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    DropEventHandler dropEventHandler = new DropEventHandler(this, dropTargetDropEvent, list);
                }
            }
            catch (Exception exception) {
            }
            finally {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean openFile(SGDrawingWindow sGDrawingWindow, String string) {
            block16: {
                sGDrawingWindow.setEnabled(false);
                try {
                    ArrayList arrayList = new ArrayList();
                    File file = null;
                    File file2 = null;
                    Object var6_6 = null;
                    File file3 = new File(string);
                    String string2 = file3.getAbsolutePath();
                    boolean bl = string2.endsWith("sgp");
                    boolean bl2 = string2.endsWith("sga");
                    if (bl) {
                        file = file3;
                    } else if (bl2) {
                        file2 = file3;
                    } else {
                        boolean bl3 = false;
                        return bl3;
                    }
                    sGDrawingWindow.initProgressValue();
                    if (file != null) {
                        boolean bl4;
                        if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (bl4 = this.beforeDiscard(sGDrawingWindow))) {
                            boolean bl5 = true;
                            return bl5;
                        }
                        if (!this.showMultiDataFileChooserDialog(file, arrayList, sGDrawingWindow)) {
                            bl4 = false;
                            return bl4;
                        }
                        break block16;
                    }
                    if (file2 != null) {
                        int n;
                        if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (n = this.beforeDiscard(sGDrawingWindow)) == 1) {
                            boolean bl6 = true;
                            return bl6;
                        }
                        n = this.loadDataSet(sGDrawingWindow, file2);
                        sGDrawingWindow.setSaved(n == 0);
                        break block16;
                    }
                    boolean bl7 = false;
                    return bl7;
                }
                finally {
                    sGDrawingWindow.initProgressValue();
                    sGDrawingWindow.setEnabled(true);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fromDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            sGDrawingWindow.setEnabled(false);
            try {
                int n3;
                ArrayList<File> arrayList2 = new ArrayList<File>();
                File file = null;
                File file2 = null;
                File file3 = null;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    File file4 = (File)arrayList.get(n3);
                    String string = file4.getAbsolutePath();
                    boolean bl = string.endsWith("sgp");
                    boolean bl2 = string.endsWith("sga");
                    boolean bl3 = false;
                    String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!(string.endsWith(stringArray[i]) | string.endsWith(stringArray[i].toUpperCase()))) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl) {
                        file = file4;
                        continue;
                    }
                    if (bl2) {
                        file2 = file4;
                        continue;
                    }
                    if (bl3) {
                        file3 = file4;
                        continue;
                    }
                    arrayList2.add(file4);
                }
                sGDrawingWindow.initProgressValue();
                if (file != null) {
                    if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                        boolean bl = true;
                        return bl;
                    }
                    if (!this.showMultiDataFileChooserDialog(file, arrayList2, sGDrawingWindow)) {
                        n3 = 0;
                        return n3 != 0;
                    }
                } else if (file2 != null) {
                    if (this.needsConfirmationBeforeDiscard(sGDrawingWindow) && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                        boolean bl = true;
                        return bl;
                    }
                    n3 = this.loadDataSet(sGDrawingWindow, file2);
                    sGDrawingWindow.setSaved(n3 == 0);
                } else if (file3 != null) {
                    if (!this.setImage(file3, sGDrawingWindow)) {
                        n3 = 0;
                        return n3 != 0;
                    }
                } else if (!this.addDataByDragAndDrop(n, n2, sGDrawingWindow, arrayList2)) {
                    n3 = 0;
                    return n3 != 0;
                }
            }
            finally {
                sGDrawingWindow.initProgressValue();
                sGDrawingWindow.setEnabled(true);
            }
            return true;
        }

        private boolean setImage(String string, SGDrawingWindow sGDrawingWindow) {
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            return this.setImage(file, sGDrawingWindow);
        }

        private boolean setImage(File file, SGDrawingWindow sGDrawingWindow) {
            try {
                URL uRL = file.toURL();
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                MediaTracker mediaTracker = new MediaTracker(sGDrawingWindow);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sGDrawingWindow.setImage(image);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return false;
            }
            return true;
        }

        private boolean needsConfirmationBeforeDiscard(SGDrawingWindow sGDrawingWindow) {
            return sGDrawingWindow.getVisibleFigureList().size() != 0 & !sGDrawingWindow.isSaved();
        }

        private int beforeDiscard(SGDrawingWindow sGDrawingWindow) {
            int n = this.confirmBeforeDiscard(sGDrawingWindow);
            if (n != 0) {
                if (n == 1 | n == -1) {
                    return 1;
                }
                if (n == 2) {
                    int n2 = this.saveProperties(sGDrawingWindow);
                    return n2;
                }
            }
            return 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof SGDrawingWindow && "Tool Bar".equals(string)) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
                this.updateToolBarPatternInPreferences(sGDrawingWindow.getToolBarPattern());
            }
        }

        private void updateToolBarPatternInPreferences(String[] stringArray) {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i];
                if (i == stringArray.length - 1) continue;
                string = string + ",";
            }
            preferences.put("Tool Bar Pattern", string);
        }

        private boolean showMultiDataFileChooserDialog(File file, ArrayList arrayList, Frame frame) {
            if (!file.exists()) {
                SGUtility.showMessageDialog(frame, "Cannot open the selected file.", "File open failure", 0);
                return false;
            }
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = this.mMultiDataFileChooserWizardDialogDD = new SGMultiDataFileChooserWizardDialog(frame, true);
            sGMultiDataFileChooserWizardDialog.getPreviousButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.pack();
            sGMultiDataFileChooserWizardDialog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialogDD.setFile(this.getCurrentFileDirectory(), this.mCurrentDataFileName);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, frame, arrayList2, arrayList3, arrayList4)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList2.size());
            if (!this.setMultiDataFileChooser(arrayList2, arrayList3, arrayList4, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            if (frame != null) {
                sGMultiDataFileChooserWizardDialog.setCenter(frame);
            } else {
                sGMultiDataFileChooserWizardDialog.setLocationRelativeTo(null);
            }
            sGMultiDataFileChooserWizardDialog.setVisible(true);
            return true;
        }

        private boolean addDataByDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            int n3;
            this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.mNextButton.setVisible(false);
            this.mXYDataTypeSelectionWizardDialogFromCLorDD.pack();
            File file = (File)arrayList.get(0);
            ArrayList arrayList2 = new ArrayList();
            try {
                n3 = this.createDataFromFile(file.getPath(), arrayList2, sGDrawingWindow);
            }
            catch (FileNotFoundException fileNotFoundException) {
                SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
                return false;
            }
            if (n3 == -1) {
                Utility.showDataFileInvalidMessageDialog(sGDrawingWindow);
                return false;
            }
            if (n3 == 1) {
                return true;
            }
            if (arrayList2.size() == 0) {
                return false;
            }
            SGData sGData = (SGData)arrayList2.get(0);
            String string = file.getAbsolutePath();
            Object object = sGDrawingWindow.getComponent(n, n2);
            if (object instanceof SGDrawingWindow) {
                int n4 = sGDrawingWindow.getCurrentFigureId();
                SGFigure sGFigure = sGDrawingWindow.getFigure(n4);
                if (sGFigure == null) {
                    String string2 = this.getSimpleFileName(string);
                    if (string2 == null) {
                        return false;
                    }
                    Point point = new Point(n, n2);
                    sGFigure = this.createNewFigure(sGDrawingWindow, n4, sGData, point, string2);
                    if (sGFigure == null) {
                        sGDrawingWindow.initProgressValue();
                        return false;
                    }
                } else {
                    String string3 = this.getNewDataName(sGFigure, string);
                    if (string3 == null) {
                        return false;
                    }
                    if (!this.addData(sGData, string3, sGFigure)) {
                        Utility.showDataTypeInvalidMessageDialog(sGDrawingWindow);
                        return false;
                    }
                }
            } else if (object instanceof SGFigure) {
                SGFigure sGFigure = (SGFigure)object;
                String string4 = this.getNewDataName(sGFigure, string);
                if (string4 == null) {
                    return false;
                }
                if (!this.addData(sGData, string4, sGFigure)) {
                    Utility.showDataTypeInvalidMessageDialog(sGDrawingWindow);
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private SGFigure createNewFigure(SGDrawingWindow sGDrawingWindow, int n, SGData sGData, Point point, String string) {
            SGFigure sGFigure = this.createFigure(n, sGDrawingWindow, sGData);
            if (sGFigure == null) {
                return null;
            }
            sGDrawingWindow.setProgressValue(0.7f);
            if (!sGDrawingWindow.addFigure(sGFigure, point)) {
                return null;
            }
            sGDrawingWindow.setProgressValue(0.8f);
            if (!this.addData(sGData, string, sGFigure)) {
                return null;
            }
            sGDrawingWindow.setProgressValue(0.9f);
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                if (sGIFigureElementArray[i].initPropertiesHistory()) continue;
                return null;
            }
            sGDrawingWindow.setProgressValue(1.0f);
            sGDrawingWindow.drawBackFigure(sGFigure);
            sGFigure.initPropertiesHistory();
            sGFigure.setVisible(true);
            sGDrawingWindow.setChanged(true);
            sGDrawingWindow.notifyToRoot();
            sGDrawingWindow.setVisible(true);
            sGDrawingWindow.updateItemsByFigureNumbers();
            sGDrawingWindow.initProgressValue();
            return sGFigure;
        }

        private boolean addData(SGData sGData, String string, SGFigure sGFigure) {
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>(Arrays.asList(sGIFigureElementArray));
            SGIAxisElement sGIAxisElement = sGFigure.getAxisElement();
            arrayList.remove(sGIAxisElement);
            arrayList.add(0, sGIAxisElement);
            SGIFigureElement[] sGIFigureElementArray2 = arrayList.toArray(new SGIFigureElement[0]);
            return sGFigure.addData(sGData, string, sGIFigureElementArray2);
        }

        private SGSplashWindow createSplashWindow() {
            Class<?> clazz = this.getClass();
            String string = "/resources/Splash.png";
            URL uRL = clazz.getResource(string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            if (image == null) {
                return null;
            }
            SGSplashWindow sGSplashWindow = new SGSplashWindow(image, ApplicationProperties.VERSION);
            return sGSplashWindow;
        }

        private class WindowInfo {
            private Document mDocument;
            private Map mDataListMap = new TreeMap();

            private WindowInfo() {
            }
        }
    }

    private static class DropEventHandler
    extends Thread {
        private Main mMain;
        private DropTargetDropEvent mDropTargetDropEvent = null;
        private ArrayList mDroppedFileList = null;

        private DropEventHandler(Main main, DropTargetDropEvent dropTargetDropEvent, List list) {
            this.mMain = main;
            this.mDropTargetDropEvent = dropTargetDropEvent;
            this.mDroppedFileList = new ArrayList(list);
            this.start();
        }

        public void run() {
            DropTargetDropEvent dropTargetDropEvent = this.mDropTargetDropEvent;
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            Point point = dropTargetDropEvent.getLocation();
            this.mMain.fromDragAndDrop(point.x, point.y, sGDrawingWindow, this.mDroppedFileList);
            sGDrawingWindow.getContentPane().repaint();
            this.mDropTargetDropEvent = null;
            this.mDroppedFileList = null;
        }
    }

    private static class Connect
    extends Thread {
        private ServerSocket mServerSocket = null;
        private Main mMain;

        private Connect(Main main, ServerSocket serverSocket) {
            this.mMain = main;
            this.mServerSocket = serverSocket;
            this.start();
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            try {
                while (true) {
                    String string;
                    if ((string = bufferedReader.readLine()) == null) {
                        continue;
                    }
                    int n = this.mMain.exec(string);
                    String string2 = Integer.toString(n) + "\n";
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
    }

    private static class Utility
    implements SGIApplicationTextConstants {
        private Utility() {
        }

        public static boolean compareVersionNumber(int n, int n2, int n3, int n4, int n5, int n6) {
            boolean bl = n < n4 ? true : (n == n4 ? (n2 < n5 ? true : (n2 == n5 ? n3 < n6 : false)) : false);
            return bl;
        }

        private static final void showDataFileInvalidMessageDialog(Window window) {
            SGUtility.showErrorMessageDialog(window, "The data file is invalid.", "Error");
        }

        private static final void showDataTypeInvalidMessageDialog(Window window) {
            SGUtility.showErrorMessageDialog(window, "The data type is invalid.", "Error");
        }
    }

    private static class UpgradeManager
    implements ActionListener,
    SGIConstants,
    SGIUpgradeConstants,
    SGIPreferencesConstants {
        private static final String MSG_LATEST_VERSION_INSTALLED = "The latest version is already installed.";
        private static final String MSG_NEW_VERSION_FOUND_BEFORE = "Samurai Graph Ver.";
        private static final String MSG_NEW_VERSION_FOUND_AFTER = " is found.\nDownload now?\n";
        private static final String MSG_UPGRADE_FAILED = "Upgrade is failed for some reason.";
        private static final String MSG_UPGRADE_WARNING = "This application will be terminated.\nPresent work will be lost.";
        private static final String TITLE_WARNING = "Warning";
        private static final String MSG_LOCAL_FILE_NOT_FOUND = "Local file is not found.";
        private static final String MSG_CONNECTION_FAILED = "Connection Failed.";
        private JFileChooser mUpgradeFileChooser;
        private SGUpgradeDialog mUpgradeDialog;
        private ProxyManager mProxyManager;

        private UpgradeManager(ProxyManager proxyManager) {
            this.mProxyManager = proxyManager;
            this.mUpgradeFileChooser = new SGFileChooser();
            this.mUpgradeFileChooser.setCurrentDirectory(new File(SGIConstants.USER_HOME));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SGUpgradeDialog sGUpgradeDialog;
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                int n;
                String string2 = this.mUpgradeDialog.getUpgradeCycle();
                if (string2.equals("No Upgrade")) {
                    n = 0;
                } else if (string2.equals("Every Time")) {
                    n = 1;
                } else if (string2.equals("Every Day")) {
                    n = 2;
                } else if (string2.equals("Every Week")) {
                    n = 3;
                } else if (string2.equals("Every Month")) {
                    n = 4;
                } else {
                    throw new Error();
                }
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putInt("Upgrade Cycle", n);
            } else if (string.equals("Check for Update Now") && !this.upgradeByCommand(sGUpgradeDialog = (SGUpgradeDialog)object)) {
                return;
            }
        }

        private boolean showUpgradeDialog(Frame frame) {
            this.mUpgradeDialog = new SGUpgradeDialog(frame, true);
            this.mUpgradeDialog.addActionListener(this);
            this.mUpgradeDialog.setCenter(frame);
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", 0);
            String string = null;
            switch (n) {
                case 0: {
                    string = "No Upgrade";
                    break;
                }
                case 1: {
                    string = "Every Time";
                    break;
                }
                case 2: {
                    string = "Every Day";
                    break;
                }
                case 3: {
                    string = "Every Week";
                    break;
                }
                case 4: {
                    string = "Every Month";
                    break;
                }
                default: {
                    string = "No Upgrade";
                }
            }
            this.mUpgradeDialog.setUpgradeCycle(string);
            this.mUpgradeDialog.setVisible(true);
            return true;
        }

        private boolean upgradeOnStartup(Window window) {
            return this.upgrade(window, true);
        }

        private boolean upgradeByCommand(Window window) {
            return this.upgrade(window, false);
        }

        private boolean upgrade(Window window, boolean bl) {
            Object object;
            boolean bl2 = this.mProxyManager.isDirectAccess();
            String string = this.mProxyManager.getProxyHostName();
            int n = this.mProxyManager.getProxyPortNumber();
            URL uRL = null;
            try {
                uRL = bl2 ? new URL("http://samurai-graph.sourceforge.jp/product.xml") : new URL("http", string, n, "http://samurai-graph.sourceforge.jp/product.xml");
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                return false;
            }
            if (bl) {
                object = Preferences.userNodeForPackage(this.getClass());
                ((Preferences)object).putLong("Date", System.currentTimeMillis());
            }
            if (this.compareVersion((Element)(object = document.getDocumentElement()))) {
                if (!this.installLatestVersion((Element)object, window, bl)) {
                    return false;
                }
            } else if (!bl) {
                JOptionPane.showMessageDialog(window, MSG_LATEST_VERSION_INSTALLED);
            }
            return true;
        }

        private boolean compareVersion(Element element) {
            int n = ApplicationProperties.MAJOR_VERSION;
            int n2 = ApplicationProperties.MINOR_VERSION;
            int n3 = ApplicationProperties.MINOR_VERSION;
            int n4 = this.getVersion(element, "majorver");
            int n5 = this.getVersion(element, "minorver");
            int n6 = this.getVersion(element, "microver");
            boolean bl = Utility.compareVersionNumber(n, n2, n3, n4, n5, n6);
            return bl;
        }

        private int getVersion(Element element, String string) {
            Element element2 = (Element)element.getElementsByTagName(string).item(0);
            String string2 = element2.getFirstChild().getNodeValue();
            int n = Integer.parseInt(string2);
            return n;
        }

        private boolean installLatestVersion(Element element, Window window, boolean bl) {
            Object object;
            Element element2;
            Object object2;
            Object object3;
            int n;
            int n2 = ApplicationProperties.MAJOR_VERSION;
            int n3 = ApplicationProperties.MINOR_VERSION;
            int n4 = ApplicationProperties.MICRO_VERSION;
            NodeList nodeList = element.getElementsByTagName("release");
            Element element3 = null;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (n = 0; n < nodeList.getLength(); ++n) {
                int n5;
                int n6;
                int n7;
                Element element4 = (Element)nodeList.item(n);
                String string = element4.getAttribute("latest");
                if (Boolean.TRUE.toString().equals(string)) {
                    element3 = element4;
                }
                if (!Utility.compareVersionNumber(n2, n3, n4, n7 = this.getVersion(element4, "majorver"), n6 = this.getVersion(element4, "minorver"), n5 = this.getVersion(element4, "microver"))) continue;
                arrayList.add(element4);
            }
            if (element3 == null) {
                return false;
            }
            n = this.getVersion(element3, "majorver");
            int n8 = this.getVersion(element3, "minorver");
            int n9 = this.getVersion(element3, "microver");
            String string = new Integer(n).toString();
            String string2 = new Integer(n8).toString();
            String string3 = new Integer(n9).toString();
            String string4 = MSG_NEW_VERSION_FOUND_BEFORE + string + "." + string2 + "." + string3 + MSG_NEW_VERSION_FOUND_AFTER;
            StringBuffer stringBuffer = new StringBuffer("<html><head></head><body>-- New Features --");
            String string5 = "<font size=\"3\">";
            stringBuffer.append(string5);
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (Element)arrayList.get(i);
                object2 = new StringBuffer();
                NodeList nodeList2 = object3.getElementsByTagName("releaseinfo");
                element2 = (Element)nodeList2.item(0);
                object = element2.getElementsByTagName("changelog");
                Element element5 = (Element)object.item(0);
                this.printNode(element5, (StringBuffer)object2);
                stringBuffer.append((StringBuffer)object2);
            }
            SGScrollPaneDialog sGScrollPaneDialog = null;
            if (window instanceof Frame) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Frame)window, true);
            } else if (window instanceof Dialog) {
                sGScrollPaneDialog = new SGUpgradeConfirmDialog((Dialog)window, true);
            }
            sGScrollPaneDialog.setMessage(string4);
            ((SGUpgradeConfirmDialog)sGScrollPaneDialog).setPage(new String(stringBuffer));
            sGScrollPaneDialog.pack();
            sGScrollPaneDialog.setCenter(window);
            sGScrollPaneDialog.setVisible(true);
            if (sGScrollPaneDialog.isCanceled()) {
                return true;
            }
            object3 = null;
            object3 = SGUtility.identifyOS("windows") ? "win32" : (SGUtility.identifyOS("mac os x") ? "macosx" : "other");
            object2 = element3.getElementsByTagName("package");
            for (int i = 0; i < object2.getLength(); ++i) {
                element2 = (Element)object2.item(i);
                object = element2.getAttribute("category");
                if (((String)object).equals("win32")) {
                    if (!((String)object3).equals("win32")) continue;
                    if (this.forWin32(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (((String)object).equals("macosx")) {
                    if (!((String)object3).equals("macosx")) continue;
                    if (this.forMacOSX(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (((String)object).equals("bin")) {
                    if (!((String)object3).equals("other")) continue;
                    if (this.forOtherPlatform(element2, string, string2, string3, window, bl)) break;
                    return false;
                }
                if (!((String)object).equals("src")) continue;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean forWin32(Element element, String string, String string2, String string3, Window window, boolean bl) {
            Object object;
            Object[] objectArray;
            int n;
            if (!(bl || (n = JOptionPane.showOptionDialog(window, MSG_UPGRADE_WARNING, TITLE_WARNING, -1, 2, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0])) != 1 && n != -1)) {
                return true;
            }
            objectArray = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, SGIConstants.PATH_SEPARATOR);
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (!((String)object).endsWith("samurai-graph.jar")) continue;
                string4 = new File((String)object).getParent();
                break;
            }
            if (string4 == null) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            object = new File(string4 + SGIConstants.FILE_SEPARATOR + "lib" + SGIConstants.FILE_SEPARATOR + "upgrade-helper.jar");
            if (!((File)object).exists()) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + "SamuraiGraphTemp");
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            file.deleteOnExit();
            File file2 = new File(file.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + "upgrade-helper.jar");
            file2.deleteOnExit();
            try {
                SGApplicationUtility.copyBinaryFile((File)object, file2);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            File file3 = null;
            try {
                file3 = File.createTempFile("tmp_", ".exe");
            }
            catch (IOException iOException) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                if (file3 != null) {
                    file3.delete();
                }
            }
            if (!this.download(element, window, file3)) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                file3.delete();
                file2.delete();
                file.delete();
                return false;
            }
            String string5 = new File(string4).getParent();
            String string6 = file3.getAbsolutePath();
            String string7 = string + "." + string2 + "." + string3;
            String string8 = string4;
            String[] stringArray = new String[]{System.getProperty("java.home") + SGIConstants.FILE_SEPARATOR + "bin" + SGIConstants.FILE_SEPARATOR + "javaw.exe", "-jar", file2.getAbsolutePath(), string4, string6, string8};
            if (!file2.exists()) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            try {
                Runtime.getRuntime().exec(stringArray, null, new File(string5));
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
                return false;
            }
            return true;
        }

        private boolean forOtherPlatform(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-bin", "zip", "Zip Archive");
        }

        private boolean forMacOSX(Element element, String string, String string2, String string3, Window window, boolean bl) {
            return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-mac", "dmg.gz", "Compressed Disk Image");
        }

        private boolean downloadWithFileChooser(Element element, String string, String string2, String string3, Window window, boolean bl, String string4, String string5, String string6) {
            File file;
            JFileChooser jFileChooser = this.mUpgradeFileChooser;
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription(string5);
            sGExtensionFileFilter.addExtension(string6);
            jFileChooser.setFileFilter(sGExtensionFileFilter);
            String string7 = string4 + "-" + string + "." + string2 + "." + string3 + "." + string5;
            jFileChooser.setSelectedFile(new File(string7));
            int n = jFileChooser.showSaveDialog(window);
            File file2 = null;
            switch (n) {
                case 0: {
                    file2 = jFileChooser.getSelectedFile();
                    break;
                }
                case 1: {
                    return true;
                }
                case -1: {
                    throw new Error();
                }
            }
            String string8 = file2.getAbsolutePath();
            if (!string8.endsWith(string5) && !string8.endsWith(string5.toUpperCase())) {
                string8 = string8 + "." + string5;
            }
            return this.download(element, window, file = new File(string8));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean download(Element var1_1, Window var2_2, File var3_3) {
            block32: {
                block29: {
                    block27: {
                        block28: {
                            var4_4 = null;
                            var5_5 = null;
                            var6_6 = null;
                            var7_7 = false;
                            try {
                                try {
                                    var4_4 = new BufferedOutputStream(new FileOutputStream(var3_3));
                                    var8_8 = var1_1.getElementsByTagName("url");
                                    for (var9_10 = 0; var9_10 < var8_8.getLength(); ++var9_10) {
                                        var10_12 = (Element)var8_8.item(var9_10);
                                        var11_13 = var10_12.getFirstChild().getNodeValue();
                                        var12_14 = null;
                                        try {
                                            var12_14 = new URL(var11_13);
                                        }
                                        catch (MalformedURLException var13_16) {
                                            continue;
                                        }
                                        var13_15 = null;
                                        try {
                                            var13_15 = var12_14.openConnection();
                                            var5_5 = new BufferedInputStream(var13_15.getInputStream());
                                        }
                                        catch (IOException var14_17) {
                                            continue;
                                        }
                                        var14_18 = var3_3.getAbsolutePath();
                                        var15_19 = var13_15.getContentLength();
                                        var16_20 = true;
                                        if (var2_2 instanceof Dialog) {
                                            var6_6 = new SGProgressMonitorDialog((Dialog)var2_2, var16_20);
                                        } else if (var2_2 instanceof JFrame) {
                                            var6_6 = new SGProgressMonitorDialog((Frame)var2_2, var16_20);
                                        }
                                        var17_21 = var6_6.getProgressBar();
                                        var17_21.setMinimum(0);
                                        var17_21.setMaximum(var15_19);
                                        var17_21.setStringPainted(true);
                                        var6_6.setInputSize(var15_19);
                                        var6_6.setInputStream(var5_5);
                                        var6_6.setOutputStream(var4_4);
                                        var6_6.setLabel(var14_18);
                                        var6_6.pack();
                                        var6_6.setCenter(var2_2);
                                        var2_2.setCursor(Cursor.getPredefinedCursor(3));
                                        var18_22 = new Thread(var6_6);
                                        var18_22.start();
                                        var6_6.setVisible(true);
                                        if (var6_6.isCanceled()) {
                                            var19_23 = false;
                                            var21_24 = null;
                                            var2_2.setCursor(Cursor.getDefaultCursor());
                                            var6_6.setInputStream(null);
                                            var6_6.setOutputStream(null);
                                            if (var5_5 == null) break block27;
                                            break block28;
                                        }
                                        var7_7 = true;
                                        break block29;
                                    }
                                    break block29;
                                }
                                catch (FileNotFoundException var8_9) {
                                    JOptionPane.showMessageDialog(var2_2, "Local file is not found.");
                                    var9_11 = false;
                                    var21_26 = null;
                                    var2_2.setCursor(Cursor.getDefaultCursor());
                                    var6_6.setInputStream(null);
                                    var6_6.setOutputStream(null);
                                    if (var5_5 != null) {
                                        try {
                                            var5_5.close();
                                        }
                                        catch (IOException var22_30) {
                                            // empty catch block
                                        }
                                    }
                                    if (var4_4 == null) return var9_11;
                                    try {
                                        var4_4.close();
                                        return var9_11;
                                    }
                                    catch (IOException var22_30) {
                                        // empty catch block
                                    }
                                    return var9_11;
                                }
                            }
                            catch (Throwable var20_32) {
                                block31: {
                                    var21_27 = null;
                                    var2_2.setCursor(Cursor.getDefaultCursor());
                                    var6_6.setInputStream(null);
                                    var6_6.setOutputStream(null);
                                    if (var5_5 != null) {
                                        ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl89:
                                        // 1 sources

                                        var5_5.close();
                                        break block31;
lbl91:
                                        // 1 sources

                                        catch (IOException var22_31) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (var4_4 == null) throw var20_32;
                                ** try [egrp 5[TRYBLOCK] [9 : 396->404)] { 
lbl96:
                                // 1 sources

                                var4_4.close();
                                throw var20_32;
lbl98:
                                // 1 sources

                                catch (IOException var22_31) {
                                    // empty catch block
                                }
                                throw var20_32;
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl103:
                        // 1 sources

                        var5_5.close();
                        break block27;
lbl105:
                        // 1 sources

                        catch (IOException var22_28) {
                            // empty catch block
                        }
                    }
                    if (var4_4 == null) return var19_23;
                    ** try [egrp 5[TRYBLOCK] [9 : 396->404)] { 
lbl110:
                    // 1 sources

                    var4_4.close();
                    return var19_23;
lbl112:
                    // 1 sources

                    catch (IOException var22_28) {
                        // empty catch block
                    }
                    return var19_23;
                }
                var21_25 = null;
                var2_2.setCursor(Cursor.getDefaultCursor());
                var6_6.setInputStream(null);
                var6_6.setOutputStream(null);
                if (var5_5 != null) {
                    ** try [egrp 4[TRYBLOCK] [8 : 381->389)] { 
lbl122:
                    // 1 sources

                    var5_5.close();
                    break block32;
lbl124:
                    // 1 sources

                    catch (IOException var22_29) {
                        // empty catch block
                    }
                }
            }
            if (var4_4 != null) {
                try {}
                catch (IOException var22_29) {}
                var4_4.close();
            }
            if (var7_7 != false) return true;
            JOptionPane.showMessageDialog(var2_2, "Connection Failed.");
            return false;
        }

        private void printNode(Element element, StringBuffer stringBuffer) {
            this.printNodeRecursively(element, stringBuffer, -1);
        }

        private void printNodeRecursively(Element element, StringBuffer stringBuffer, int n) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    Element element2 = (Element)node;
                    String string = element2.getTagName();
                    if (string.equals("item")) {
                        NodeList nodeList2 = element2.getChildNodes();
                        int n2 = nodeList2.getLength();
                        if (n2 == 1) {
                            stringBuffer.append("<li>");
                            this.printFirstChild(element2, stringBuffer, n);
                            stringBuffer.append("</li>");
                            continue;
                        }
                        if (n2 <= 1) continue;
                        stringBuffer.append("<li>");
                        this.printFirstChild(element2, stringBuffer, n);
                        stringBuffer.append("<ul>");
                        for (int j = 0; j < n2; ++j) {
                            Node node2 = nodeList2.item(j);
                            if (!(node2 instanceof Element)) continue;
                            Element element3 = (Element)node2;
                            this.printNodeRecursively(element3, stringBuffer, n + 1);
                        }
                        stringBuffer.append("</ul>");
                        stringBuffer.append("</li>");
                        continue;
                    }
                    if (!string.equals("itemize")) continue;
                    stringBuffer.append("<ul>");
                    this.printNodeRecursively(element2, stringBuffer, n + 1);
                    stringBuffer.append("</ul>");
                    continue;
                }
                if (!(node instanceof Text)) continue;
            }
        }

        private void printFirstChild(Node node, StringBuffer stringBuffer, int n) {
            Node node2 = node.getFirstChild();
            this.printText(node2, stringBuffer, n);
        }

        private void printText(Node node, StringBuffer stringBuffer, int n) {
            String string = node.getNodeValue();
            String string2 = this.tokenize(string);
            if (string2.length() != 0) {
                stringBuffer.append(string2);
            }
        }

        private String tokenize(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String string2 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                string2 = string2 + string3;
                if (i == arrayList.size() - 1) continue;
                string2 = string2 + " ";
            }
            return string2;
        }
    }

    private static class ProxyManager
    implements ActionListener,
    SGIPreferencesConstants {
        private boolean mDirectAccessFlag = true;
        private String mProxyHostName = null;
        private int mProxyPortNumber = -1;

        private ProxyManager() {
            this.setProxyOnStartUp();
        }

        private boolean setProxyOnStartUp() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            boolean bl = preferences.getBoolean("Direct Access", true);
            String string = preferences.get("Proxy Host Name", "");
            int n = preferences.getInt("Proxy Port Number", -1);
            this.mDirectAccessFlag = bl;
            if (!string.equals("")) {
                this.mProxyHostName = string;
            }
            if (n != -1) {
                this.mProxyPortNumber = n;
            }
            return true;
        }

        public boolean isDirectAccess() {
            return this.mDirectAccessFlag;
        }

        public void setDirectAccess(boolean bl) {
            this.mDirectAccessFlag = bl;
        }

        public String getProxyHostName() {
            return this.mProxyHostName;
        }

        public int getProxyPortNumber() {
            return this.mProxyPortNumber;
        }

        public void setProxyHostName(String string) {
            this.mProxyHostName = string;
        }

        public void setProxyPortNumber(int n) {
            this.mProxyPortNumber = n;
        }

        private boolean showProxySettingDialog(Frame frame) {
            SGProxySettingDialog sGProxySettingDialog = new SGProxySettingDialog(frame, true);
            sGProxySettingDialog.addActionListener(this);
            sGProxySettingDialog.setCenter(frame);
            sGProxySettingDialog.setDirectAccess(this.mDirectAccessFlag);
            sGProxySettingDialog.setHostName(this.mProxyHostName);
            sGProxySettingDialog.setPortNumber(this.mProxyPortNumber);
            sGProxySettingDialog.setVisible(true);
            sGProxySettingDialog.dispose();
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGProxySettingDialog sGProxySettingDialog = (SGProxySettingDialog)object;
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.mDirectAccessFlag = sGProxySettingDialog.isDirectAccess();
                this.mProxyHostName = sGProxySettingDialog.getHostName();
                this.mProxyPortNumber = sGProxySettingDialog.getPortNumber();
                Preferences preferences = Preferences.userNodeForPackage(this.getClass());
                preferences.putBoolean("Direct Access", this.mDirectAccessFlag);
                preferences.put("Proxy Host Name", this.mProxyHostName);
                preferences.putInt("Proxy Port Number", this.mProxyPortNumber);
            }
        }
    }

    private static class ApplicationProperties
    implements SGIApplicationConstants {
        private static String VERSION = "-1.-1.-1";
        private static int MAJOR_VERSION = -1;
        private static int MINOR_VERSION = -1;
        private static int MICRO_VERSION = -1;

        private ApplicationProperties() {
        }

        private static boolean loadProperties() {
            try {
                int n;
                int n2;
                int n3;
                Properties properties = new Properties();
                InputStream inputStream = ClassLoader.getSystemResourceAsStream("resources/samurai-graph.properties");
                properties.load(inputStream);
                inputStream.close();
                String string = properties.getProperty("samurai-graph.version");
                if (string == null) {
                    return false;
                }
                VERSION = string;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                if (stringTokenizer.countTokens() != 3) {
                    return false;
                }
                MAJOR_VERSION = n3 = Integer.valueOf(stringTokenizer.nextToken()).intValue();
                MINOR_VERSION = n2 = Integer.valueOf(stringTokenizer.nextToken()).intValue();
                MICRO_VERSION = n = Integer.valueOf(stringTokenizer.nextToken()).intValue();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }
}

