/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementString2D
extends SGDrawingElementString
implements SGIDrawingElementJava2D {
    private TextLayout mTextLayout;
    private Rectangle2D mStringVisualRect;
    private LineMetrics mStringMetrics;

    public SGDrawingElementString2D() {
    }

    public SGDrawingElementString2D(String string) {
        super(string);
    }

    public SGDrawingElementString2D(SGDrawingElementString sGDrawingElementString) {
        super(sGDrawingElementString);
    }

    public SGDrawingElementString2D(String string, String string2, int n, float f) {
        super(string, string2, n, f);
    }

    public SGDrawingElementString2D(String string, String string2, int n, float f, float f2, float f3) {
        super(string, string2, n, f, f2, f3);
    }

    public void dispose() {
        super.dispose();
        this.mTextLayout = null;
        this.mStringVisualRect = null;
        this.mStringMetrics = null;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.updateStringRect();
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        super.setFont(string, n, f);
        this.updateStringRect();
        return true;
    }

    public boolean setString(String string) {
        super.setString(string);
        this.updateStringRect();
        return true;
    }

    public boolean contains(int n, int n2) {
        Rectangle2D rectangle2D = this.getElementBounds();
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getElementBounds() {
        Rectangle2D rectangle2D = this.getStringRect();
        rectangle2D.setRect(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        AffineTransform affineTransform = this.getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(rectangle2D);
        return shape.getBounds2D();
    }

    protected boolean updateStringRect() {
        if (this.mFont == null | this.mString == null) {
            return false;
        }
        String string = this.mString;
        if (string.length() == 0) {
            this.mTextLayout = null;
            this.mStringVisualRect = new Rectangle2D.Float();
            this.mStringMetrics = null;
            return true;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        this.mTextLayout = new TextLayout(string, this.mFont, fontRenderContext);
        this.mStringVisualRect = this.mTextLayout.getOutline(null).getBounds2D();
        this.mStringMetrics = this.mFont.getLineMetrics(string, fontRenderContext);
        return true;
    }

    public Rectangle2D getStringRect() {
        return (Rectangle2D)this.mStringVisualRect.clone();
    }

    protected float getAscent() {
        if (this.mStringMetrics == null) {
            return 0.0f;
        }
        return this.mStringMetrics.getAscent();
    }

    protected float getStrikethroughOffset() {
        if (this.mStringMetrics == null) {
            return 0.0f;
        }
        return this.mStringMetrics.getStrikethroughOffset();
    }

    protected float getDescent() {
        if (this.mStringMetrics == null) {
            return 0.0f;
        }
        return this.mStringMetrics.getDescent();
    }

    protected float getAdvance() {
        if (this.mTextLayout == null) {
            return 0.0f;
        }
        return this.mTextLayout.getAdvance();
    }

    protected float getLeading() {
        if (this.mStringMetrics == null) {
            return 0.0f;
        }
        return this.mStringMetrics.getLeading();
    }

    protected AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        double d = this.getX();
        double d2 = this.getY();
        affineTransform.translate(d, d2);
        affineTransform.rotate(-this.getAngle());
        return affineTransform;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        String string = this.getString();
        graphics2D.setPaint(this.getColor(0));
        graphics2D.setFont(this.mFont);
        AffineTransform affineTransform = this.getAffineTransform();
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        graphics2D.drawString(string, -((float)this.mStringVisualRect.getX()), -((float)this.mStringVisualRect.getY()));
        graphics2D.setTransform(affineTransform2);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.paintElement(graphics2D);
    }

    public static void main(String[] stringArray) {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D("ABCDEFG", "Serif", 0, 15.0f, 0.0f, 0.0f);
        System.out.println(sGDrawingElementString2D.getStringRect());
        sGDrawingElementString2D.setMagnification(1.0f);
        System.out.println(sGDrawingElementString2D.getStringRect());
        sGDrawingElementString2D.setMagnification(2.0f);
        System.out.println(sGDrawingElementString2D.getStringRect());
        sGDrawingElementString2D.setMagnification(4.0f);
        System.out.println(sGDrawingElementString2D.getStringRect());
        sGDrawingElementString2D.setMagnification(2.0f);
        System.out.println(sGDrawingElementString2D.getStringRect());
    }
}

