// Copyright 2000, CERN, Geneva, Switzerland and SLAC, Stanford, California, U.S.A.
package org.freehep.jaco.generator;

import java.io.PrintWriter;
import java.util.Properties;

import org.freehep.jaco.rtti.*;

/**
 * @author Mark Donszelmann
 * @version $Id: AbstractGenerator.java,v 1.1.1.1 2004/05/31 05:08:51 kuromaru Exp $
 */
public abstract class AbstractGenerator implements Generator
{
	protected PrintWriter out;
	protected String packagePrefix;
	protected Properties properties;

    public AbstractGenerator() {
        properties = new Properties();
    }

    public Properties getProperties() {
        return properties;
    }

    public void setPackagePrefix(String prefix) {
        packagePrefix = prefix;
    }

    protected void warning()
	{
	    // first line to signal our files!
        out.println("// JACO-GENERATED");
        out.println("// ==============================================================");
        out.println("// This class was generated by JACO - Java Access to C++ Objects ");
        out.println("// DO NOT MODIFY, but use the jaco utility to regenerate it      ");
        out.println("// ==============================================================");
    }

    public String directory(IClass clazz) {
        return "";
    }

    public abstract String filename(IClass clazz);
	public abstract boolean print(PrintWriter out, IClass clazz);
}

