package org.freehep.jaco.rtti.cpp;

import java.util.Vector;

/**
 * Class scope extends Scope in that its search method also searches all its
 * superclasses.
 *
 * @author Mark Donszelmann
 * @version $Id: ClassScope.java,v 1.1.1.1 2004/05/31 05:08:50 kuromaru Exp $
 */

class ClassScope extends Scope
{
   /**
    * The list of scopes corresponding to classes this class inherits.
    */
   Vector superClasses;

   /**
    * Add a super class.
    */
   public void addSuper(Scope sc)
   {
      if (sc == null)
         return;

      if (superClasses == null)
         superClasses = new Vector();

      superClasses.addElement(sc);
   }

   /**
    * Overrides the method in Scope. It also searches in the inherited classes'
    * scopes also.
    */
   public boolean isTypeName(String name)
   {
      if (super.isTypeName(name))
         return true;

      if (superClasses == null)
         return false;

      for (int i = 0; i < superClasses.size(); i++)
         if (((Scope)superClasses.elementAt(i)).isTypeName(name))
            return true;

      return false;
   }

   /**
    * Creates a new class scope in a given scope.
    */
   public ClassScope(String name, Scope parent)
   {
      super(name, true, parent);
   }
}
