
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;

/**
 * Constants for axis break symbols.
 */
public interface SGIAxisBreakSymbolConstants extends SGIDrawingElementConstants
{

	/**
	 * 
	 */
	public static final double ANGLE_ABS_MAX = Math.PI*(1.0/3.0);

	public static final String AXIS_BREAK_LENGTH_UNIT = cm;
	public static final double AXIS_BREAK_LENGTH_MIN = 0.50;
	public static final double AXIS_BREAK_LENGTH_MAX = 2.0;

	public static final String AXIS_BREAK_INTERVAL_UNIT = cm;
	public static final double AXIS_BREAK_INTERVAL_MIN = 0.10;
	public static final double AXIS_BREAK_INTERVAL_MAX = 2.0;


	public static final double AXIS_BREAK_DISTORTION_MIN = -1.0;
	public static final double AXIS_BREAK_DISTORTION_MAX = 1.0;

	public static final double AXIS_BREAK_ANGLE_MAX = ANGLE_ABS_MAX/RADIAN_DEGREE_RATIO;
	public static final double AXIS_BERAK_ANGLE_MIN = - AXIS_BREAK_ANGLE_MAX;


	public static final String TAG_NAME_AXIS_BREAK_SYMBOL = "AxisBreakSymbol";


	public static final String KEY_X = "X";
	public static final String KEY_Y = "Y";
	public static final String KEY_LENGTH = "Length";
	public static final String KEY_INTERVAL = "Interval";
	public static final String KEY_DISTORTION = "Distortion";
	public static final String KEY_ANGLE = "Angle";
	public static final String KEY_HORIZONTAL = "Horizontal";
	public static final String KEY_LINE_WIDTH = "LineWidth";
	public static final String KEY_INNER_COLOR = "InnerColor";
	public static final String KEY_LINE_COLOR = "LineColor";

	public static final String KEY_X_VALUE = "XValue";
	public static final String KEY_Y_VALUE = "YValue";



	//
	// Default Values
	//

	// Length
	public static final float DEFAULT_AXIS_BREAK_LENGTH = 1.0f;

	// Interval
	public static final float DEFAULT_AXIS_BREAK_INTERVAL = 0.50f;

	// Line Width
	public static final float DEFAULT_AXIS_BREAK_LINE_WIDTH = 1.5f;

	// Angle
	public static final float DEFAULT_AXIS_BREAK_ANGLE = 0.0f;

	// Distortion
	public static final float DEFAULT_AXIS_BREAK_DISTORTION = 0.50f;

	// Horizontal
	public static final boolean DEFAULT_AXIS_BREAK_FOR_HORIZONTAL = true;

	// Line Color
	public static final Color DEFAULT_AXIS_BREAK_LINE_COLOR = Color.BLACK;

	// Inner Color
	public static final Color DEFAULT_AXIS_BREAK_INNER_COLOR = Color.WHITE;

	// Horizontal Axis
	public static final String DEFAULT_AXIS_BREAK_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String DEFAULT_AXIS_BREAK_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;
	
}

