
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

/**
 * An observer of the property panel for arrows.
 *
 */
public interface SGIArrowPanelObserver
{

	public float getLineWidth( final String unit );
	
	public int getLineType();
	
	public Color getColor();

	public float getHeadSize( final String unit );

	public float getHeadOpenAngle();
	
	public float getHeadCloseAngle();

	public int getStartHeadType();
	
	public int getEndHeadType();


	public boolean setLineWidth( final float width, final String unit );
	
	public boolean setLineType( final int type );
	
	public boolean setColor( final Color cl );

	public boolean setHeadSize( final float size, final String unit );
	
	public boolean setHeadOpenAngle( final float angle );
	
	public boolean setHeadCloseAngle( final float angle );
	
	public boolean setStartHeadType( final int type );

	public boolean setEndHeadType( final int type );


	/**
	 * 
	 * @param open
	 * @param close
	 * @return
	 */
	public boolean hasValidAngle( final Number open, final Number close );

}

