
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

/**
 * An observer of the property dialog for axis break symbols.
 *
 */
public interface SGIAxisBreakSymbolDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * 
	 * @return
	 */
	public double getXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getYValue();


	/**
	 * 
	 * @return
	 */
	public float getLength( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getInterval( final String unit );


	/**
	 * 
	 * @return
	 */
	public float getDistortion();


	/**
	 * 
	 * @return
	 */
	public float getAngle();


	/**
	 * 
	 * @return
	 */
	public float getLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public boolean isForHorizontalAxis();


	/**
	 * 
	 * @return
	 */
	public Color getLineColor();


	/**
	 * 
	 * @return
	 */
	public Color getInnerColor();



	/**
	 * 
	 * @param value
	 */
	public boolean setXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public boolean setYValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public boolean setLength( final float value, final String unit );


	/**
	 * 
	 * @param value
	 */
	public boolean setInterval( final float value, final String unit );


	/**
	 * 
	 * @param value
	 */
	public boolean setLineWidth( final float value, final String unit );


	/**
	 * 
	 * @param angle
	 */
	public boolean setAngle( final float angle );


	/**
	 * 
	 * @param value
	 */	
	public boolean setDistortion( final float value );


	/**
	 * 
	 * @param color
	 */
	public boolean setLineColor( final Color color );


	/**
	 * 
	 * @param color
	 */
	public boolean setInnerColor( final Color color );


	/**
	 * 
	 * @param flag
	 */
	public boolean setForHorizontalAxisFlag( final boolean flag );



	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidXValue( final int config, final Number value );

	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidYValue( final int config, final Number value );

}

