
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

/**
 * An observer of the property dialog for legend.
 *
 */
interface SGILegendDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * 
	 * @return
	 */
	public double getXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getYValue();


	/**
	 * 
	 * @return
	 */
	public String getFontName();


	/**
	 *
	 */
	public float getFontSize( final String unit );


	/**
	 *
	 */
	public int getFontStyle();


	/**
	 * 
	 * @return
	 */
	public Color getStringColor();


	/**
	 * 
	 * @return
	 */
	public boolean isFrameLineVisible();


	/**
	 * 
	 * @return
	 */
	public float getFrameLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public Color getFrameLineColor();


	/**
	 * 
	 * @return
	 */
	public boolean isLegendVisible();


	/**
	 * 
	 * @return
	 */
	public boolean isBackgroundTransparent();


	/**
	 * 
	 * @return
	 */
	public Color getBackgroundColor();


	/**
	 * @return
	 */
	public float getSymbolSpan( final String unit );


	/**
	 * 
	 * @param value
	 */
	public boolean setXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public boolean setYValue( final double value );


	/**
	 * 
	 * @param b
	 */
	public boolean setLegendVisible( final boolean b );


	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean setFontName( final String name );


	/**
	 * 
	 * @param style
	 * @return
	 */
	public boolean setFontStyle( final int style );


	/**
	 * 
	 * @param size
	 * @return
	 */
	public boolean setFontSize( final float size, final String unit );


	/**
	 * 
	 * @param cl
	 */
	public boolean setFontColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public boolean setFrameVisible( final boolean b );


	/**
	 * 
	 * @param width
	 */
	public boolean setFrameLineWidth( final float width, final String unit );


	/**
	 * 
	 * @param cl
	 */
	public boolean setFrameLineColor( final Color cl );


	/**
	 * 
	 * @param b
	 */
	public boolean setBackgroundTransparent( final boolean b );


	/**
	 * 
	 * @param cl
	 */
	public boolean setBackgroundColor( Color cl );


	/**
	 * @param f
	 */
	public boolean setSymbolSpan( final float w, final String unit );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidXAxisValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidYAxisValue( final int config, final Number value );


}

