package org.freehep.jaco.rtti.cpp;

import java.util.Iterator;
import java.util.Vector;

/**
 * Holds the various attributes of a declarator. This is filled up as the
 * declarator is parsed.
 *
 * @author Mark Donszelmann
 * @version $Id: Declarator.java,v 1.1.1.1 2004/05/31 05:08:51 kuromaru Exp $
 */

class Declarator
{
    Declarator() {
        this("Undefined");
    }

    Declarator(String name) {
        this.name = name;
        this.isReference = false;
        this.pointer = 0;
        this.isFunction = false;
        this.parameters = new Vector();
    }

    /**
    * Pointer operator or null
    */
    boolean isReference;
    int pointer;     // of String

    /**
     * Name of the declarator.
     */
    String name;

    /**
     * Is this a function
     */
    boolean isFunction;

    Vector parameters;

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (isReference) s.append("&");
        for (int i = 0; i<pointer; i++ ) {
            s.append("*");
        }
        s.append(name);
        return s.toString();
    }
}
