
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;


/**
 * A dialog to choose multiple data files for the propety file.
 *
 */
public class SGMultiDataFileChooserWizardDialog extends SGFileChooserWizardDialog
	implements TableModelListener, DropTargetListener, ComponentListener,
		PropertyChangeListener, MouseMotionListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Choose data files.";


	/**
	 * 
	 */
	public SGMultiDataFileChooserWizardDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /** Creates new form SGDataFileChooseWizardDialog */
    public SGMultiDataFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


	/**
	 * 
	 */
	public void componentResized( ComponentEvent e )
	{
		super.componentResized(e);
		this.updateTable();
	}


	/**
	 * 
	 */
	public void componentShown( ComponentEvent e )
	{
		super.componentShown(e);
		this.updateTable();
	}


	private void updateTable()
	{
		final int height = this.mTable.getHeight();
		if( height!=0 )
		{
			this.updateButtonsPanel();
			this.setPreferredColumnWidth();
		}
	}


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mScrollPane = new javax.swing.JScrollPane();
        mInsideScrollPanePanel = new javax.swing.JPanel();
        mSingleFileChooserButtonPanel = new javax.swing.JPanel();
        mTableScrollPane = new javax.swing.JScrollPane();
        mTable = new javax.swing.JTable();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mScrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        mScrollPane.setPreferredSize(new java.awt.Dimension(458, 200));
        mInsideScrollPanePanel.setLayout(new java.awt.GridBagLayout());

        mInsideScrollPanePanel.setFont(new java.awt.Font("Dialog", 0, 11));
        mSingleFileChooserButtonPanel.setLayout(null);

        mSingleFileChooserButtonPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mInsideScrollPanePanel.add(mSingleFileChooserButtonPanel, gridBagConstraints);

        mTableScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        mTableScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        mTableScrollPane.setBorder(null);
        mTableScrollPane.setFont(new java.awt.Font("Dialog", 0, 11));
        mTableScrollPane.setPreferredSize(new java.awt.Dimension(434, 196));
        mTable.setFont(new java.awt.Font("Dialog", 0, 11));
        mTableScrollPane.setViewportView(mTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mInsideScrollPanePanel.add(mTableScrollPane, gridBagConstraints);

        mScrollPane.setViewportView(mInsideScrollPanePanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        mPanel.add(mScrollPane, gridBagConstraints);

        getContentPane().add(mPanel, new java.awt.GridBagConstraints());

        mButtonPanel.setBorder(new javax.swing.border.EtchedBorder());
        mButtonPanel.setFont(new java.awt.Font("Dialog", 0, 11));
        mPreviousButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JPanel mInsideScrollPanePanel;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JScrollPane mScrollPane;
    private javax.swing.JPanel mSingleFileChooserButtonPanel;
    protected javax.swing.JTable mTable;
    private javax.swing.JScrollPane mTableScrollPane;
    // ϐ錾̏I//GEN-END:variables


    
	/**
	 * 
	 */
	public static final String COLUMN_NAME_FIGURE_ID = "Figure ID";
	public static final String COLUMN_NAME_DATA_TYPE = "Data Type";
	public static final String COLUMN_NAME_DATA_NAME = "Data Name";
	public static final String COLUMN_NAME_FILE_NAME = "File Name";
	
	public static String[] getColumnNameArray()
	{
		return new String[]{
			COLUMN_NAME_FIGURE_ID,
			COLUMN_NAME_DATA_TYPE,
			COLUMN_NAME_DATA_NAME,
			COLUMN_NAME_FILE_NAME };
	}
	
	private static final int[] PREFERRED_COLUMN_WIDTH_ARRAY
		= { 30, 80, 80, 110 };




	/**
	 * 
	 */
	private int mFileNumber;

	
	/**
	 * 
	 */
	private DefaultTableModel mTableModel = null;


	
	/**
	 * 
	 */
	private boolean initProperty()
	{
		//
		this.setTitle( SGMultiDataFileChooserWizardDialog.TITLE );

		//
		this.mOKButton.setEnabled(false);

		// table model
		this.mTableModel = new OriginalTableModel();
		this.mTableModel.addTableModelListener(this);
		
		// set the height of all rows
		this.mTable.setRowHeight( DEFAULT_ROW_HEIGHT );
		
		// drag and drop
		DropTarget target = new DropTarget(
			this.mTable,
			DnDConstants.ACTION_COPY_OR_MOVE,
			this,
			true
		);
		this.setDropTarget(target);
		
this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		this.mTable.addComponentListener(this);
		this.mTable.addPropertyChangeListener(this);
		this.mTable.addMouseMotionListener(this);

		return true;
	}


	
	/**
	 * 
	 */
	public static final int DEFAULT_ROW_HEIGHT = 20;
	

	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();

		JTable table = this.getTable();
		JButton[] array = this.mSingleFileChooserButtonArray;
		for( int ii=0; ii<array.length; ii++ )
		{
			if( source.equals( array[ii] ) )
			{
				// disable multi selection
				this.mFileChooser.setMultiSelectionEnabled(false);

				File[] files = this.showFileChooser();
				if( files==null )
				{
					return;
				}

				File f = files[0];
				this.setSelectedFile( ii, f );
				break;
			}
		}
		
	}



	/**
	 * 
	 */
	public void propertyChange( PropertyChangeEvent e )
	{
		Object source = e.getSource();
		String name = e.getPropertyName();
//System.out.println(name);
	}



	/**
	 * 
	 */
	public void mouseDragged( MouseEvent e )
	{
		
	}
	
	
	/**
	 * 
	 */
	public void mouseMoved( MouseEvent e )
	{

		// shows the tooltip text
		Point pos = e.getPoint();
		JTable table = this.mTable;
		final int row = table.rowAtPoint(pos);
		final int column = this.getFileNameColumnIndex();
		Object obj = table.getValueAt( row, column );
		if( obj==null | "".equals(obj) )
		{
			table.setToolTipText(null);
			return;
		}
		String text = (String)obj;
		table.setToolTipText(text);
	}



	/**
	 * Returns the column index of table.
	 * @param identifier
	 * @return If the column with given identifier exists, returns the index.
	 */
	public int getColumnIndex( final String identifier )
	{
		return this.mTable.getColumnModel().getColumnIndex( identifier );
	}



	/**
	 * 
	 */
	public static final String NO_DATA = "NO_DATA";


	
	/**
	 * 
	 */
	public void tableChanged( TableModelEvent e )
	{
		boolean enable = true;

		TableModel model = this.mTableModel;
		final int row = model.getRowCount();
		final int column = model.getColumnCount();

		for( int ii=0; ii<row; ii++ )
		{
			for( int jj=0; jj<column; jj++ )
			{
				Object obj = model.getValueAt(ii,jj);
				if( obj==null | "".equals(obj) )
				{
					enable = false;
					break;
				}
			}
			if( !enable )
			{
				break;
			}
		}
		
		this.getOKButton().setEnabled( enable );
	}
	
	

	/**
	 * 
	 */
	public JTable getTable()
	{
		return this.mTable;
	}


	/**
	 * 
	 */
	public boolean setTable( final JTable table )
	{
		this.mTable = table;
		return true;
	}


	/**
	 * 
	 */
	public TableModel getTableModel()
	{
		return this.mTable.getModel();
	}



	/**
	 * 
	 */
	public boolean setTableModel( final TableModel model )
	{
		JTable table = this.mTable;
		table.setModel( model );
		return true;
	}

	
	/**
	 * 
	 * @return
	 */
	public int getFigureIDColumnIndex()
	{
		return this.getColumnIndex( COLUMN_NAME_FIGURE_ID );
	}

	
	/**
	 * 
	 * @param array
	 */
	public void setFigureIDArray( final String[] array )
	{
		this.setData( array, this.getFigureIDColumnIndex() );
	}

	
	/**
	 * 
	 * @return
	 */
	public int getDataNameColumnIndex()
	{
		return this.getColumnIndex( COLUMN_NAME_DATA_NAME );
	}
	
	
	/**
	 * 
	 * @param array
	 */
	public void setDataNameArray( final String[] array )
	{
		this.setData( array, this.getDataNameColumnIndex() );
	}


	/**
	 * 
	 * @return
	 */
	public int getDataTypeColumnIndex()
	{
		return this.getColumnIndex( COLUMN_NAME_DATA_TYPE );
	}


	/**
	 * 
	 * @param array
	 */
	public void setDataTypeArray( final String[] array )
	{
		this.setData( array, this.getDataTypeColumnIndex() );
	}


	/**
	 * 
	 * @return
	 */
	public int getFileNameColumnIndex()
	{
		return this.getColumnIndex( COLUMN_NAME_FILE_NAME );
	}

	
	/**
	 * 
	 * @param array
	 */
	public void setFileNameArray( final String[] array )
	{
		this.setData( array, this.getFileNameColumnIndex() );
	}
	

	private void setData( final Object[] data, final int index )
	{
		DefaultTableModel model = this.mTableModel;

		final int column = getColumnNameArray().length;
		final int row = this.mTableModel.getRowCount();
		Object[][] array = new Object[row][column];
		for( int ii=0; ii<column; ii++ )
		{
			if( ii==index )
			{
				for( int jj=0; jj<row; jj++ )
				{
					array[jj][ii] = data[jj];
				}
			}
			else
			{
				for( int jj=0; jj<row; jj++ )
				{
					array[jj][ii] = ((Vector)model.getDataVector().elementAt(jj)).elementAt(ii);
				}
			}
		}

		String[] cnArray = {
			COLUMN_NAME_FIGURE_ID,
			COLUMN_NAME_DATA_TYPE,
			COLUMN_NAME_DATA_NAME,
			COLUMN_NAME_FILE_NAME };
		model.setDataVector( array, cnArray );
		this.setTableModel(model);


		// set selection button unabled
		ArrayList numList = new ArrayList();
		final int col = this.getDataNameColumnIndex();
		for( int jj=0; jj<row; jj++ )
		{
			Object obj = array[jj][col];
			if( NO_DATA.equals(obj) )
			{
				numList.add( new Integer(jj) );
			}
		}

		ArrayList list = new ArrayList();
		Component[] cArray = this.mSingleFileChooserButtonPanel.getComponents();
		for( int ii=0; ii<cArray.length; ii++ )
		{
			if( cArray[ii] instanceof JButton )
			{
				list.add( cArray[ii] );
			}
		}

		for( int ii=0; ii<numList.size(); ii++ )
		{
			final int num = ((Integer)numList.get(ii)).intValue();
			JButton btn = (JButton)list.get(num);
			btn.setEnabled(false);
		}

	}
	


	/**
	 * Refreshes the button panel.
	 *
	 */
	private void updateButtonsPanel()
	{
		final int dataNumber = this.mFileNumber;
		JTableHeader hdr = this.mTable.getTableHeader();
		final int top = hdr.getHeight();

		final int width = DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH;
		final int height = top + ( dataNumber + 1 )*DEFAULT_ROW_HEIGHT;
		Dimension dim = new Dimension( width, height );
		this.mSingleFileChooserButtonPanel.setSize(dim);

		Component[] old = this.mSingleFileChooserButtonPanel.getComponents();
		int y = top;
		final int size = DEFAULT_ROW_HEIGHT;
		for( int ii=0; ii<old.length; ii++ )
		{
			if( old[ii] instanceof JButton )
			{
				JButton b = (JButton)old[ii];
				b.setSize( size, size );
				b.setLocation( b.getX(), y );
				y += size;
			}
		}
	}



	/**
	 * Set size of columns.
	 *
	 */
	private void setPreferredColumnWidth()
	{
		JTable table = this.mTable;
		String[] array = getColumnNameArray();
		final int[] size = PREFERRED_COLUMN_WIDTH_ARRAY;
		for( int ii=0; ii<array.length; ii++ )
		{
			TableColumn cl = table.getColumn( array[ii] );
			cl.setPreferredWidth( size[ii] );
		}
	}


	/**
	 * 
	 *
	 */
	private void setOriginalTableCellRenderer()
	{
		JTable table = this.mTable;
		String[] array = getColumnNameArray();
		for( int ii=0; ii<array.length; ii++ )
		{
			TableColumn cl = table.getColumn( array[ii] );
			cl.setCellRenderer( new OriginalTableCellRenderer() );
		}
	}

	
	/**
	 * 
	 * @param dataNumber
	 */
	public void init( final int dataNumber )
	{

		// remove old buttons
		Component[] old = this.mSingleFileChooserButtonPanel.getComponents();
		for( int ii=0; ii<old.length; ii++ )
		{
			if( old[ii] instanceof JButton )
			{
				JButton b = (JButton)old[ii];
				b.removeActionListener(this);
				this.mSingleFileChooserButtonPanel.remove(b);
			}
		}


		// Set the preferred size of a JPanel component which contains buttons.
		final int width = DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH;
		final int height = DEFAULT_ROW_HEIGHT;
		final int pHeight = height*( dataNumber + 1 );
		this.mSingleFileChooserButtonPanel.setPreferredSize( new Dimension( width, pHeight ) );

		
		// Set the preferred size of the scroll pane which contains a JTable component.
		// For the height, use the larger value of mInsideScrollPanePanel and pHeight
		final int insideHeight = this.mInsideScrollPanePanel.getHeight();
		final int h = insideHeight<pHeight ? pHeight : insideHeight;
		final int prefWidth = this.mTableScrollPane.getPreferredSize().width;
		this.mTableScrollPane.setPreferredSize( new Dimension( prefWidth, h ) );

		
		// add new buttons
		this.mSingleFileChooserButtonArray = new JButton[dataNumber];
		JButton[] bArray = this.mSingleFileChooserButtonArray;
		for( int ii=0; ii<dataNumber; ii++ )
		{
			JButton b = new JButton(" ");
			b.setFont( new java.awt.Font("Dialog", 1, 12 ) );
			b.setPreferredSize( new Dimension( width, DEFAULT_ROW_HEIGHT ) );
			b.addActionListener(this);
			bArray[ii] = b;
			this.mSingleFileChooserButtonPanel.add( b );
		}

		
		// init the table model
		Object[][] data = new Object[dataNumber][];
		final int len = getColumnNameArray().length;
		for( int ii=0; ii<data.length; ii++ )
		{
			data[ii] = new Object[len];
		}
		this.setData(data);

	}
	

/*
	public void paint( Graphics g )
	{
		super.paint(g);
		Graphics2D g2d = (Graphics2D)g;
		
		g2d.setStroke( new BasicStroke(3) );
		g2d.setPaint( Color.red );

		JTable table = this.getTable();
		JTableHeader header = table.getTableHeader();
		
		final int x = this.getInsets().left + this.mPanel.getX() + this.mScrollPane.getX()
			+ this.mInsideScrollPanePanel.getX() + this.mTableScrollPane.getX()
			+ this.mTable.getX();
		final int y = this.getInsets().top + this.mPanel.getY() + this.mScrollPane.getY()
			+ this.mInsideScrollPanePanel.getY() + this.mTableScrollPane.getY()
			+ this.mTable.getY();
		final int w = this.mTable.getWidth();
		final int h = this.mTable.getHeight() + header.getHeight();
		Rectangle rect = new Rectangle( x, y, w, h );
//		g2d.draw( rect );

	}
*/	
	
	
	/**
	 * 
	 */
	public static final int DEFAULT_SINGLE_FILE_CHOOSER_BUTTON_WIDTH = 20;
	
	
	/**
	 * 
	 */
	private JButton[] mSingleFileChooserButtonArray = null;

	
	
	/**
	 * 
	 * @param data
	 */
	public void setData( final Object[][] data )
	{
		DefaultTableModel model = this.mTableModel;
		model.setDataVector( data, getColumnNameArray() );
		this.setTableModel( model );
	}
	
	
	
	/**
	 * 
	 */
	private File[] showFileChooser()
	{
		ArrayList list = this.openFileChooser();
		if( list==null )
		{
			return null;
		}
		if( list.size()==0 )
		{
			return null;
		}

		File[] files = new File[list.size()];
		for( int ii=0; ii<files.length; ii++ )
		{
			files[ii] = (File)list.get(ii);
		}

		return files;
	}



	/**
	 * Returns a TreeMap object of figure ID to a list of data files.
	 * @return map object obtained from dialog
	 */
	public TreeMap getSelectedFilePathListMap()
	{
		JTable tab = this.mTable;

		final int cnFigureID = this.getFigureIDColumnIndex();
		final int cnFileName = this.getFileNameColumnIndex();

		TreeMap map = new TreeMap();
		for( int ii=0; ii<tab.getRowCount(); ii++ )
		{
			// figure ID
			Object id = tab.getValueAt(ii,cnFigureID);

			// list of the path of data files
			Object obj = map.get(id);
			if( obj==null )
			{
				obj = new ArrayList();
				map.put( id, obj );
			}
			ArrayList list = (ArrayList)obj;

			// add the path to the list
			Object name = tab.getValueAt(ii,cnFileName);
			list.add( name );
		}

		return map;
	}





	/**
	 * 
	 */
	public String[] getSelectedFileNames()
	{
		JTable table = this.getTable();
		final int col = this.getFileNameColumnIndex();
		final int num = table.getRowCount();
		String[] array = new String[num];
		for( int ii=0; ii<num; ii++ )
		{
			array[ii] = (String)table.getValueAt(ii,col);
		}
		return array;
	}


	/**
	 * 
	 */
	private boolean setSelectedFiles( final File[] files )
	{

		JTable table = this.getTable();
		final int col = this.getFileNameColumnIndex();

		// t@CXV
		for( int ii=0; ii<table.getRowCount(); ii++ )
		{
			table.setValueAt( null, ii, col );
		}

		for( int ii=0; ii<files.length; ii++ )
		{
			this.setSelectedFile( ii, files[ii] );
		}

		return true;
	}

	
	
	/**
	 * 
	 */
	private boolean setSelectedFile( final int row, final File file )
	{
		final int col = this.getFileNameColumnIndex();
		String path = file.getPath();
		this.mTable.setValueAt( path, row, col );
		return true;
	}

	

	/**
	 * 
	 * @return
	 */
	public int getFileNumber()
	{
		return this.mFileNumber;
	}


	/**
	 * 
	 * @param num
	 */
	public void setFileNumber( final int num )
	{
		if( num<0 )
		{
			new IllegalArgumentException("num<0");
		}
		this.mFileNumber = num;
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


	
	
	/**
	 * 
	 */
	public void dragEnter( final DropTargetDragEvent dtde )
	{
		dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}



	/**
	 * 
	 */
	public void dragExit( final DropTargetEvent dte )
	{
	}



	/**
	 * 
	 */
	public void dragOver( final DropTargetDragEvent dtde )
	{
	}



	/**
	 * 
	 */
	public void drop( final DropTargetDropEvent dtde )
	{
		DropTarget tg = (DropTarget)dtde.getSource();
		Component com = tg.getComponent();
		SGMultiDataFileChooserWizardDialog dg
			= (SGMultiDataFileChooserWizardDialog)com;
		dtde.acceptDrop( DnDConstants.ACTION_COPY_OR_MOVE );

		JTable table = this.mTable;
		JTableHeader header = table.getTableHeader();
		TableModel model = this.mTableModel;
		JViewport vp = this.mScrollPane.getViewport();
		Point vpPos = vp.getViewPosition();
		Point location = dtde.getLocation();
		Insets ins = this.getInsets();
		final int originX = ins.left - vpPos.x;
		final int originY = ins.top + this.mScrollPane.getY() - vpPos.y + header.getHeight();
		final Point pos = new Point( location.x-originX, location.y-originY );
		final int column = this.getFileNameColumnIndex();
		try
		{
			if( ( dtde.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE ) != 0 )
			{
				Transferable trans = dtde.getTransferable();
				List list = (List)trans.getTransferData( DataFlavor.javaFileListFlavor );
				if( list.size()==0 )
				{
					return;
				}
				File file = (File)list.get(0);
				final int row = table.rowAtPoint(pos);
				if( row==-1 )
				{
					return;
				}
				if( NO_DATA.equals( model.getValueAt(row,column) ) == false )
				{
					Rectangle rect = table.getCellRect(row,column,true);
					table.setValueAt( file.getPath(), row, column );
				}
			}
		}
		catch ( Exception ex )
		{
			ex.printStackTrace();
		}
		finally
		{
			dtde.dropComplete( false );
		}
	}

	
	
	/**
	 * 
	 */
	public void dropActionChanged( final DropTargetDragEvent dtde )
	{
	}


//	/**
//	 * 
//	 */
//	public void close( final WindowEvent e )
//	{
//		// call onCanceled when not called on start-up
//		if( this.calledOnStartUp() == false )
//		{
//			Object obj = e.getSource();
//			if( obj.equals( this ) )
//			{
//				this.onCanceled();
//			}
//		}
//	}


//	/**
//	 * 
//	 * @return
//	 */
//	private boolean calledOnStartUp()
//	{
//		return (this.getOwnerWindow()==null);
//	}

	
//	/**
//	 * Overrode the cancel method
//	 */
//	protected boolean onCanceled()
//	{
//		
//		// if this dialog is used on the start-up,
//		// this shows the confirm dialog
//		if( this.calledOnStartUp() )
//		{
//			final int ret = JOptionPane.showConfirmDialog(
//				this,
//				"You cancel using the property file?",
//				"Confirmation",
//				JOptionPane.OK_CANCEL_OPTION
//			);
//
//			if( ret==JOptionPane.CANCEL_OPTION )
//			{
//				return true;
//			}
//		}
//		
//		super.onCanceled();
//		return true;
//	}
	
	
	/**
	 * 
	 *
	 */
	private class OriginalTableModel extends DefaultTableModel
	{
		public OriginalTableModel()
		{
			super();
		}

		public boolean isCellEditable( int rowIndex, int columnIndex )
		{
			JTable table = mTable;
			String name = table.getColumnName(columnIndex);
			boolean b = false;
			if( name.equals( COLUMN_NAME_FILE_NAME ) )
			{
				Object obj = table.getValueAt( rowIndex, columnIndex );
				if( obj==null )
				{
					b = true;
				}
				else
				{
					if( obj.equals(NO_DATA) == false )
					{
						b = true;
					}
				}
			}

			return b;
		}

	}



	/**
	 * 
	 *
	 */
	private class OriginalTableCellRenderer extends DefaultTableCellRenderer
	{
		OriginalTableCellRenderer()
		{
			super();
		}
		
		public Component getTableCellRendererComponent(
			JTable table,
			Object object,
			boolean isSelected,
			boolean hasFocus,
			int row,
			int column )
		{
			if( object==null )
			{
				return(null);
			}

			this.setText( (String)object );
			String name = table.getColumnName(column);
			if( name.equals( COLUMN_NAME_FIGURE_ID ) )
			{
				this.setHorizontalAlignment( LEFT );
			}
			else if( name.equals( COLUMN_NAME_DATA_TYPE ) )
			{
				this.setHorizontalAlignment( LEFT );
			}
			else if( name.equals( COLUMN_NAME_DATA_NAME ) )
			{
				this.setHorizontalAlignment( LEFT );
			}
			else if( name.equals( COLUMN_NAME_FILE_NAME ) )
			{
				this.setHorizontalAlignment( RIGHT );
			}

			return(this);
		}
	}


	
/*
    private class OriginalPanel extends JPanel
    {
    	public OriginalPanel()
    	{
    		super();
    	}
    	
    	public void paint( Graphics g )
    	{
    		super.paint(g);

    		Graphics2D g2d = (Graphics2D)g;
    		
    		g2d.setStroke( new BasicStroke(3) );
    		g2d.setPaint( Color.red );
    		
    		final Dimension dim = this.getSize();
    		Rectangle rect = new Rectangle( 0, 0, dim.width, dim.height );
    		g2d.draw(rect);
    	}
   	
    }
*/    
    

	
}

